/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="ItemID" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="SupplierPartID" type="{http://www.kuali.org/kfs/purap/types}catalogNumberType"/&gt;
 *                   &lt;element name="SupplierPartAuxiliaryID" type="{http://www.kuali.org/kfs/purap/types}auxiliaryIDType" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Description" minOccurs="0"/&gt;
 *         &lt;element name="Classification" maxOccurs="unbounded" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
 *                 &lt;attribute name="domain" use="required" type="{http://www.kuali.org/kfs/sys/types}oneToTenCharType" /&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;choice minOccurs="0"&gt;
 *           &lt;sequence&gt;
 *             &lt;element name="ManufacturerPartID" type="{http://www.kuali.org/kfs/purap/types}hundredCharsType"/&gt;
 *             &lt;element name="ManufacturerName"&gt;
 *               &lt;complexType&gt;
 *                 &lt;simpleContent&gt;
 *                   &lt;extension base="&lt;http://www.kuali.org/kfs/purap/types&gt;hundredCharsType"&gt;
 *                     &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *                   &lt;/extension&gt;
 *                 &lt;/simpleContent&gt;
 *               &lt;/complexType&gt;
 *             &lt;/element&gt;
 *           &lt;/sequence&gt;
 *         &lt;/choice&gt;
 *         &lt;element name="Country" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.kuali.org/kfs/purap/types&gt;addressType"&gt;
 *                 &lt;attribute name="isoCountryCode" use="required" type="{http://www.kuali.org/kfs/sys/types}oneToFourCharType" /&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="SerialNumbers" type="{http://www.w3.org/2001/XMLSchema}string" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="lineNumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedByte" /&gt;
 *       &lt;attribute name="serialNumber" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"itemID", "description", "classification", "manufacturerPartID", "manufacturerName",
    "country", "serialNumbers"})
public class InvoiceDetailItemReference {

    @XmlElement(name = "ItemID", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected ItemID itemID;
    @XmlElement(name = "Description", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected Description description;
    @XmlElement(name = "Classification", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected List<Classification> classification;
    @XmlElement(name = "ManufacturerPartID", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected String manufacturerPartID;
    @XmlElement(name = "ManufacturerName", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected ManufacturerName manufacturerName;
    @XmlElement(name = "Country", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected Country country;
    @XmlElement(name = "SerialNumber", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected List<String> serialNumbers;
    @XmlAttribute(name = "lineNumber", required = true)
    @XmlSchemaType(name = "unsignedByte")
    protected short lineNumber;
    @XmlAttribute(name = "serialNumber")
    protected String serialNumber;

    /**
     * Gets the value of the itemID property.
     *
     * @return possible object is {@link ItemID }
     */
    public ItemID getItemID() {
        return itemID;
    }

    /**
     * Sets the value of the itemID property.
     *
     * @param itemID allowed object is {@link ItemID }
     */
    public void setItemID(final ItemID itemID) {
        this.itemID = itemID;
    }

    /**
     * Gets the value of the description property.
     *
     * @return possible object is {@link Description }
     */
    public Description getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     *
     * @param description allowed object is {@link Description }
     */
    public void setDescription(final Description description) {
        this.description = description;
    }

    /**
     * Gets the value of the classification property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the classification property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getClassification().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link Classification }
     */
    public List<Classification> getClassification() {
        if (classification == null) {
            classification = new ArrayList<>();
        }
        return classification;
    }

    /**
     * Gets the value of the manufacturerPartID property.
     *
     * @return possible object is {@link String }
     */
    public String getManufacturerPartID() {
        return manufacturerPartID;
    }

    /**
     * Sets the value of the manufacturerPartID property.
     *
     * @param manufacturerPartID allowed object is {@link String }
     */
    public void setManufacturerPartID(final String manufacturerPartID) {
        this.manufacturerPartID = manufacturerPartID;
    }

    /**
     * Gets the value of the manufacturerName property.
     *
     * @return possible object is {@link ManufacturerName }
     */
    public ManufacturerName getManufacturerName() {
        return manufacturerName;
    }

    /**
     * Sets the value of the manufacturerName property.
     *
     * @param manufacturerName allowed object is {@link ManufacturerName }
     */
    public void setManufacturerName(final ManufacturerName manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    /**
     * Gets the value of the country property.
     *
     * @return possible object is {@link Country }
     */
    public Country getCountry() {
        return country;
    }

    /**
     * Sets the value of the country property.
     *
     * @param country allowed object is {@link Country }
     */
    public void setCountry(final Country country) {
        this.country = country;
    }

    /**
     * Gets the value of the serialNumbers property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the serialNumbers property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSerialNumbers().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link String }
     */
    public List<String> getSerialNumbers() {
        if (serialNumbers == null) {
            serialNumbers = new ArrayList<>();
        }
        return serialNumbers;
    }

    /**
     * Gets the value of the lineNumber property.
     */
    public short getLineNumber() {
        return lineNumber;
    }

    /**
     * Sets the value of the lineNumber property.
     */
    public void setLineNumber(final short lineNumber) {
        this.lineNumber = lineNumber;
    }

    /**
     * Gets the value of the serialNumber property.
     *
     * @return possible object is {@link String }
     */
    public String getSerialNumber() {
        return serialNumber;
    }

    /**
     * Sets the value of the serialNumber property.
     *
     * @param serialNumber allowed object is {@link String }
     */
    public void setSerialNumber(final String serialNumber) {
        this.serialNumber = serialNumber;
    }

}
