/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;simpleContent&gt;
 *     &lt;extension base="&lt;http://www.kuali.org/kfs/purap/types&gt;emptyType"&gt;
 *       &lt;attribute name="isTaxInLine"&gt;
 *         &lt;simpleType&gt;
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *             &lt;enumeration value="yes"/&gt;
 *           &lt;/restriction&gt;
 *         &lt;/simpleType&gt;
 *       &lt;/attribute&gt;
 *       &lt;attribute name="isSpecialHandlingInLine"&gt;
 *         &lt;simpleType&gt;
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *             &lt;enumeration value="yes"/&gt;
 *           &lt;/restriction&gt;
 *         &lt;/simpleType&gt;
 *       &lt;/attribute&gt;
 *       &lt;attribute name="isShippingInLine"&gt;
 *         &lt;simpleType&gt;
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *             &lt;enumeration value="yes"/&gt;
 *           &lt;/restriction&gt;
 *         &lt;/simpleType&gt;
 *       &lt;/attribute&gt;
 *       &lt;attribute name="isDiscountInLine"&gt;
 *         &lt;simpleType&gt;
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *             &lt;enumeration value="yes"/&gt;
 *           &lt;/restriction&gt;
 *         &lt;/simpleType&gt;
 *       &lt;/attribute&gt;
 *       &lt;attribute name="isAccountingInLine"&gt;
 *         &lt;simpleType&gt;
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *             &lt;enumeration value="yes"/&gt;
 *           &lt;/restriction&gt;
 *         &lt;/simpleType&gt;
 *       &lt;/attribute&gt;
 *     &lt;/extension&gt;
 *   &lt;/simpleContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = "value")
public class InvoiceDetailLineIndicator {

    @XmlAttribute(name = "isAccountingInLine")
    String isAccountingInLine;

    @XmlAttribute(name = "isDiscountInLine")
    String isDiscountInLine;

    @XmlAttribute(name = "isShippingInLine")
    String isShippingInLine;

    @XmlAttribute(name = "isSpecialHandlingInLine")
    String isSpecialHandlingInLine;

    @XmlAttribute(name = "isTaxInLine")
    String isTaxInLine;

    @XmlValue
    String value;

    public InvoiceDetailLineIndicator() {
    }

    public InvoiceDetailLineIndicator(
            final String isDiscountInLine,
            final String isShippingInLine,
            final String isSpecialHandlingInLine,
            final String isTaxInLine
    ) {
        this.isDiscountInLine = isDiscountInLine;
        this.isShippingInLine = isShippingInLine;
        this.isSpecialHandlingInLine = isSpecialHandlingInLine;
        this.isTaxInLine = isTaxInLine;
    }

    /**
     * Gets the value of the isAccountingInLine property.
     *
     * @return possible object is {@link String }
     */
    public String getIsAccountingInLine() {
        return isAccountingInLine;
    }

    /**
     * Sets the value of the isAccountingInLine property.
     *
     * @param isAccountingInLine allowed object is {@link String }
     */
    public void setIsAccountingInLine(final String isAccountingInLine) {
        this.isAccountingInLine = isAccountingInLine;
    }

    /**
     * Gets the value of the isDiscountInLine property.
     *
     * @return possible object is {@link String }
     */
    public String getIsDiscountInLine() {
        return isDiscountInLine;
    }

    /**
     * Sets the value of the isDiscountInLine property.
     *
     * @param isDiscountInLine allowed object is {@link String }
     */
    public void setIsDiscountInLine(final String isDiscountInLine) {
        this.isDiscountInLine = isDiscountInLine;
    }

    /**
     * Gets the value of the isShippingInLine property.
     *
     * @return possible object is {@link String }
     */
    public String getIsShippingInLine() {
        return isShippingInLine;
    }

    /**
     * Sets the value of the isShippingInLine property.
     *
     * @param isShippingInLine allowed object is {@link String }
     */
    public void setIsShippingInLine(final String isShippingInLine) {
        this.isShippingInLine = isShippingInLine;
    }

    /**
     * Gets the value of the isSpecialHandlingInLine property.
     *
     * @return possible object is {@link String }
     */
    public String getIsSpecialHandlingInLine() {
        return isSpecialHandlingInLine;
    }

    /**
     * Sets the value of the isSpecialHandlingInLine property.
     *
     * @param isSpecialHandlingInLine allowed object is {@link String }
     */
    public void setIsSpecialHandlingInLine(final String isSpecialHandlingInLine) {
        this.isSpecialHandlingInLine = isSpecialHandlingInLine;
    }

    /**
     * Gets the value of the isTaxInLine property.
     *
     * @return possible object is {@link String }
     */
    public String getIsTaxInLine() {
        return isTaxInLine;
    }

    /**
     * Sets the value of the isTaxInLine property.
     *
     * @param isTaxInLine allowed object is {@link String }
     */
    public void setIsTaxInLine(final String isTaxInLine) {
        this.isTaxInLine = isTaxInLine;
    }

    /**
     * Gets the value of the value property.
     *
     * @return possible object is {@link String }
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     *
     * @param value allowed object is {@link String }
     */
    public void setValue(final String value) {
        this.value = value;
    }

}
