/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="InvoiceDetailOrderInfo"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;choice&gt;
 *                     &lt;sequence&gt;
 *                       &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}OrderReference"/&gt;
 *                       &lt;choice minOccurs="0"&gt;
 *                         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}MasterAgreementReference"/&gt;
 *                         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}MasterAgreementIDInfo"/&gt;
 *                       &lt;/choice&gt;
 *                       &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo" minOccurs="0"/&gt;
 *                     &lt;/sequence&gt;
 *                     &lt;sequence&gt;
 *                       &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}MasterAgreementReference"/&gt;
 *                       &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}OrderIDInfo" minOccurs="0"/&gt;
 *                       &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo" minOccurs="0"/&gt;
 *                     &lt;/sequence&gt;
 *                     &lt;sequence&gt;
 *                       &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}MasterAgreementIDInfo"/&gt;
 *                       &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}OrderIDInfo" minOccurs="0"/&gt;
 *                       &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo" minOccurs="0"/&gt;
 *                     &lt;/sequence&gt;
 *                     &lt;sequence&gt;
 *                       &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}OrderIDInfo"/&gt;
 *                       &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo" minOccurs="0"/&gt;
 *                     &lt;/sequence&gt;
 *                     &lt;sequence&gt;
 *                       &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo"/&gt;
 *                     &lt;/sequence&gt;
 *                   &lt;/choice&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;choice&gt;
 *           &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}InvoiceDetailItem" maxOccurs="unbounded"/&gt;
 *           &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}InvoiceDetailServiceItem" maxOccurs="unbounded"/&gt;
 *         &lt;/choice&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"invoiceDetailOrderInfo", "invoiceDetailItem", "invoiceDetailServiceItem"})
public class InvoiceDetailOrder {

    @XmlElement(name = "InvoiceDetailOrderInfo", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected InvoiceDetailOrderInfo invoiceDetailOrderInfo;
    @XmlElement(name = "InvoiceDetailItem", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected List<InvoiceDetailItem> invoiceDetailItem;
    @XmlElement(name = "InvoiceDetailServiceItem", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected List<InvoiceDetailServiceItem> invoiceDetailServiceItem;

    /**
     * Gets the value of the invoiceDetailOrderInfo property.
     *
     * @return possible object is {@link InvoiceDetailOrderInfo }
     */
    public InvoiceDetailOrderInfo getInvoiceDetailOrderInfo() {
        return invoiceDetailOrderInfo;
    }

    /**
     * Sets the value of the invoiceDetailOrderInfo property.
     *
     * @param invoiceDetailOrderInfo allowed object is {@link InvoiceDetailOrderInfo }
     */
    public void setInvoiceDetailOrderInfo(final InvoiceDetailOrderInfo invoiceDetailOrderInfo) {
        this.invoiceDetailOrderInfo = invoiceDetailOrderInfo;
    }

    /**
     * Gets the value of the invoiceDetailItem property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the invoiceDetailItem property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInvoiceDetailItem().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link InvoiceDetailItem }
     */
    public List<InvoiceDetailItem> getInvoiceDetailItem() {
        if (invoiceDetailItem == null) {
            invoiceDetailItem = new ArrayList<>();
        }
        return invoiceDetailItem;
    }

    /**
     * Gets the value of the invoiceDetailServiceItem property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the invoiceDetailServiceItem property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInvoiceDetailServiceItem().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link InvoiceDetailServiceItem }
     */
    public List<InvoiceDetailServiceItem> getInvoiceDetailServiceItem() {
        if (invoiceDetailServiceItem == null) {
            invoiceDetailServiceItem = new ArrayList<>();
        }
        return invoiceDetailServiceItem;
    }

    ElectronicInvoiceOrder toElectronicInvoiceOrder() {
        final ElectronicInvoiceOrder order = new ElectronicInvoiceOrder();

        for (final Object orderInfo : invoiceDetailOrderInfo.getContent()) {
            if (orderInfo instanceof OrderReference) {
                final OrderReference instance = (OrderReference) orderInfo;
                order.setOrderReferenceOrderID(instance.getOrderID());
                order.setOrderReferenceOrderDateString(instance.getOrderDate());
                if (instance.getDocumentReference() != null) {
                    order.setOrderReferenceDocumentRefPayloadID(instance.getDocumentReference().getPayloadID());
                    order.setOrderReferenceDocumentRef(instance.getDocumentReference().getValue());
                }
            } else if (orderInfo instanceof MasterAgreementReference) {
                final MasterAgreementReference instance = (MasterAgreementReference) orderInfo;
                order.setMasterAgreementReferenceID(instance.getAgreementID());
                order.setMasterAgreementReferenceDateString(instance.getAgreementDate());
            } else if (orderInfo instanceof MasterAgreementIDInfo) {
                final MasterAgreementIDInfo instance = (MasterAgreementIDInfo) orderInfo;
                order.setMasterAgreementIDInfoID(instance.getAgreementID());
                order.setMasterAgreementIDInfoDateString(instance.getAgreementDate());
            } else if (orderInfo instanceof OrderIDInfo) {
                final OrderIDInfo instance = (OrderIDInfo) orderInfo;
                order.setOrderIDInfoID(instance.getOrderID());
                order.setOrderIDInfoDateString(instance.getOrderDate());
            } else if (orderInfo instanceof SupplierOrderInfo) {
                final SupplierOrderInfo instance = (SupplierOrderInfo) orderInfo;
                order.setSupplierOrderInfoID(instance.getOrderID());
            }
        }

        if (CollectionUtils.isNotEmpty(invoiceDetailItem)) {
            invoiceDetailItem.forEach(item -> order.addInvoiceItem(item.toElectronicInvoiceItem()));
        }

        if (CollectionUtils.isNotEmpty(invoiceDetailServiceItem)) {
            invoiceDetailServiceItem.forEach(item -> order.addInvoiceItem(item.toElectronicInvoiceItem()));
        }

        return order;
    }

}
