/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;choice&gt;
 *           &lt;sequence&gt;
 *             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}OrderReference"/&gt;
 *             &lt;choice minOccurs="0"&gt;
 *               &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}MasterAgreementReference"/&gt;
 *               &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}MasterAgreementIDInfo"/&gt;
 *             &lt;/choice&gt;
 *             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo" minOccurs="0"/&gt;
 *           &lt;/sequence&gt;
 *           &lt;sequence&gt;
 *             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}MasterAgreementReference"/&gt;
 *             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}OrderIDInfo" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo" minOccurs="0"/&gt;
 *           &lt;/sequence&gt;
 *           &lt;sequence&gt;
 *             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}MasterAgreementIDInfo"/&gt;
 *             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}OrderIDInfo" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo" minOccurs="0"/&gt;
 *           &lt;/sequence&gt;
 *           &lt;sequence&gt;
 *             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}OrderIDInfo"/&gt;
 *             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo" minOccurs="0"/&gt;
 *           &lt;/sequence&gt;
 *           &lt;sequence&gt;
 *             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo"/&gt;
 *           &lt;/sequence&gt;
 *         &lt;/choice&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = "content")
public class InvoiceDetailOrderInfo {

    @XmlElementRefs({
        @XmlElementRef(name = "OrderReference", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, type =
            OrderReference.class, required = false),
        @XmlElementRef(name = "MasterAgreementReference", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE,
            type = MasterAgreementReference.class, required = false),
        @XmlElementRef(name = "MasterAgreementIDInfo", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, type =
            MasterAgreementIDInfo.class, required = false),
        @XmlElementRef(name = "SupplierOrderInfo", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, type =
            SupplierOrderInfo.class, required = false),
        @XmlElementRef(name = "OrderIDInfo", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, type =
            OrderIDInfo.class, required = false)})
    protected List<Object> content;

    /**
     * Gets the rest of the content model.
     *
     * <p>
     * You are getting this "catch-all" property because of the following reason: The field name
     * "MasterAgreementReference" is used by two different parts of a schema. See: line 805 of
     * file:/financials/kfs-purap/src/main/resources/org/kuali/kfs/module/purap/batch /electronicInvoice.xsd line 798 of
     * file:/financials/kfs-purap/src/main/resources/org /kuali/kfs/module/purap /batch/electronicInvoice.xsd
     * <p>
     * To get rid of this property, apply a property customization to one of both of the following declarations to
     * change their names: Gets the value of the content property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the content property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContent().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link MasterAgreementIDInfo } {@link
     * MasterAgreementReference } {@link OrderIDInfo } {@link OrderReference } {@link SupplierOrderInfo }
     */
    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<>();
        }
        return content;
    }

}
