/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;

import java.math.BigDecimal;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;attribute name="payInNumberOfDays" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
 *       &lt;attribute name="percentageRate" use="required" type="{http://www.w3.org/2001/XMLSchema}decimal" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
class InvoiceDetailPaymentTerm {

    @XmlAttribute(name = "payInNumberOfDays", required = true)
    @XmlSchemaType(name = "unsignedInt")
    long payInNumberOfDays;

    @XmlAttribute(name = "percentageRate", required = true)
    BigDecimal percentageRate;

    /**
     * Gets the value of the payInNumberOfDays property.
     */
    public long getPayInNumberOfDays() {
        return payInNumberOfDays;
    }

    /**
     * Sets the value of the payInNumberOfDays property.
     */
    public void setPayInNumberOfDays(final long payInNumberOfDays) {
        this.payInNumberOfDays = payInNumberOfDays;
    }

    /**
     * Gets the value of the percentageRate property.
     *
     * @return possible object is {@link BigDecimal }
     */
    public BigDecimal getPercentageRate() {
        return percentageRate;
    }

    /**
     * Sets the value of the percentageRate property.
     *
     * @param percentageRate allowed object is {@link BigDecimal }
     */
    public void setPercentageRate(final BigDecimal percentageRate) {
        this.percentageRate = percentageRate;
    }

}
