/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="InvoiceDetailRequestHeader"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="InvoiceDetailHeaderIndicator"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;simpleContent&gt;
 *                         &lt;extension base="&lt;http://www.kuali.org/kfs/purap/types&gt;emptyType"&gt;
 *                           &lt;attribute name="isHeaderInvoice"&gt;
 *                             &lt;simpleType&gt;
 *                               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                                 &lt;enumeration value="yes"/&gt;
 *                               &lt;/restriction&gt;
 *                             &lt;/simpleType&gt;
 *                           &lt;/attribute&gt;
 *                           &lt;attribute name="isVatRecoverable"&gt;
 *                             &lt;simpleType&gt;
 *                               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                                 &lt;enumeration value="yes"/&gt;
 *                               &lt;/restriction&gt;
 *                             &lt;/simpleType&gt;
 *                           &lt;/attribute&gt;
 *                         &lt;/extension&gt;
 *                       &lt;/simpleContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                   &lt;element name="InvoiceDetailLineIndicator"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;simpleContent&gt;
 *                         &lt;extension base="&lt;http://www.kuali.org/kfs/purap/types&gt;emptyType"&gt;
 *                           &lt;attribute name="isTaxInLine"&gt;
 *                             &lt;simpleType&gt;
 *                               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                                 &lt;enumeration value="yes"/&gt;
 *                               &lt;/restriction&gt;
 *                             &lt;/simpleType&gt;
 *                           &lt;/attribute&gt;
 *                           &lt;attribute name="isSpecialHandlingInLine"&gt;
 *                             &lt;simpleType&gt;
 *                               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                                 &lt;enumeration value="yes"/&gt;
 *                               &lt;/restriction&gt;
 *                             &lt;/simpleType&gt;
 *                           &lt;/attribute&gt;
 *                           &lt;attribute name="isShippingInLine"&gt;
 *                             &lt;simpleType&gt;
 *                               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                                 &lt;enumeration value="yes"/&gt;
 *                               &lt;/restriction&gt;
 *                             &lt;/simpleType&gt;
 *                           &lt;/attribute&gt;
 *                           &lt;attribute name="isDiscountInLine"&gt;
 *                             &lt;simpleType&gt;
 *                               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                                 &lt;enumeration value="yes"/&gt;
 *                               &lt;/restriction&gt;
 *                             &lt;/simpleType&gt;
 *                           &lt;/attribute&gt;
 *                           &lt;attribute name="isAccountingInLine"&gt;
 *                             &lt;simpleType&gt;
 *                               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                                 &lt;enumeration value="yes"/&gt;
 *                               &lt;/restriction&gt;
 *                             &lt;/simpleType&gt;
 *                           &lt;/attribute&gt;
 *                         &lt;/extension&gt;
 *                       &lt;/simpleContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                   &lt;element name="InvoicePartner" maxOccurs="unbounded" minOccurs="0"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Contact" maxOccurs="unbounded"/&gt;
 *                             &lt;element name="IdReference" minOccurs="0"&gt;
 *                               &lt;complexType&gt;
 *                                 &lt;complexContent&gt;
 *                                   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                                     &lt;sequence&gt;
 *                                       &lt;element name="Creator" type="{http://www.kuali.org/kfs/sys/types}zeroToTwentyCharType" minOccurs="0"/&gt;
 *                                       &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Description" minOccurs="0"/&gt;
 *                                     &lt;/sequence&gt;
 *                                     &lt;attribute name="domain" use="required" type="{http://www.kuali.org/kfs/sys/types}zeroToTwentyCharType" /&gt;
 *                                     &lt;attribute name="identifier" use="required" type="{http://www.kuali.org/kfs/sys/types}zeroToTwentyCharType" /&gt;
 *                                   &lt;/restriction&gt;
 *                                 &lt;/complexContent&gt;
 *                               &lt;/complexType&gt;
 *                             &lt;/element&gt;
 *                           &lt;/sequence&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}InvoiceDetailShipping" minOccurs="0"/&gt;
 *                   &lt;choice maxOccurs="unbounded" minOccurs="0"&gt;
 *                     &lt;element name="InvoiceDetailPaymentTerm"&gt;
 *                       &lt;complexType&gt;
 *                         &lt;complexContent&gt;
 *                           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                             &lt;attribute name="payInNumberOfDays" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
 *                             &lt;attribute name="percentageRate" use="required" type="{http://www.w3.org/2001/XMLSchema}decimal" /&gt;
 *                           &lt;/restriction&gt;
 *                         &lt;/complexContent&gt;
 *                       &lt;/complexType&gt;
 *                     &lt;/element&gt;
 *                     &lt;element name="PaymentTerm"&gt;
 *                       &lt;complexType&gt;
 *                         &lt;complexContent&gt;
 *                           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                             &lt;attribute name="payInNumberOfDays" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
 *                           &lt;/restriction&gt;
 *                         &lt;/complexContent&gt;
 *                       &lt;/complexType&gt;
 *                     &lt;/element&gt;
 *                   &lt;/choice&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Comments" minOccurs="0"/&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Extrinsic" maxOccurs="unbounded" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *                 &lt;attribute name="purpose" default="standard"&gt;
 *                   &lt;simpleType&gt;
 *                     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                       &lt;enumeration value="standard"/&gt;
 *                     &lt;/restriction&gt;
 *                   &lt;/simpleType&gt;
 *                 &lt;/attribute&gt;
 *                 &lt;attribute name="operation" default="new"&gt;
 *                   &lt;simpleType&gt;
 *                     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                       &lt;enumeration value="new"/&gt;
 *                     &lt;/restriction&gt;
 *                   &lt;/simpleType&gt;
 *                 &lt;/attribute&gt;
 *                 &lt;attribute name="invoiceDate" use="required" type="{http://www.kuali.org/kfs/purap/types}dateStringType" /&gt;
 *                 &lt;attribute name="invoiceID" use="required" type="{http://www.kuali.org/kfs/purap/types}idType" /&gt;
 *                 &lt;attribute name="isInformationOnly"&gt;
 *                   &lt;simpleType&gt;
 *                     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                       &lt;enumeration value="yes"/&gt;
 *                     &lt;/restriction&gt;
 *                   &lt;/simpleType&gt;
 *                 &lt;/attribute&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="InvoiceDetailOrder" maxOccurs="unbounded"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="InvoiceDetailOrderInfo"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;choice&gt;
 *                               &lt;sequence&gt;
 *                                 &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}OrderReference"/&gt;
 *                                 &lt;choice minOccurs="0"&gt;
 *                                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}MasterAgreementReference"/&gt;
 *                                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}MasterAgreementIDInfo"/&gt;
 *                                 &lt;/choice&gt;
 *                                 &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo" minOccurs="0"/&gt;
 *                               &lt;/sequence&gt;
 *                               &lt;sequence&gt;
 *                                 &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}MasterAgreementReference"/&gt;
 *                                 &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}OrderIDInfo" minOccurs="0"/&gt;
 *                                 &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo" minOccurs="0"/&gt;
 *                               &lt;/sequence&gt;
 *                               &lt;sequence&gt;
 *                                 &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}MasterAgreementIDInfo"/&gt;
 *                                 &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}OrderIDInfo" minOccurs="0"/&gt;
 *                                 &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo" minOccurs="0"/&gt;
 *                               &lt;/sequence&gt;
 *                               &lt;sequence&gt;
 *                                 &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}OrderIDInfo"/&gt;
 *                                 &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo" minOccurs="0"/&gt;
 *                               &lt;/sequence&gt;
 *                               &lt;sequence&gt;
 *                                 &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}SupplierOrderInfo"/&gt;
 *                               &lt;/sequence&gt;
 *                             &lt;/choice&gt;
 *                           &lt;/sequence&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                   &lt;choice&gt;
 *                     &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}InvoiceDetailItem" maxOccurs="unbounded"/&gt;
 *                     &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}InvoiceDetailServiceItem" maxOccurs="unbounded"/&gt;
 *                   &lt;/choice&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="InvoiceDetailSummary"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="SubtotalAmount"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *                           &lt;/sequence&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Tax"/&gt;
 *                   &lt;element name="SpecialHandlingAmount" minOccurs="0"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *                             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Description" minOccurs="0"/&gt;
 *                           &lt;/sequence&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                   &lt;element name="ShippingAmount" minOccurs="0"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *                           &lt;/sequence&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}GrossAmount" minOccurs="0"/&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}InvoiceDetailDiscount" minOccurs="0"/&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}NetAmount"/&gt;
 *                   &lt;element name="DepositAmount" minOccurs="0"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *                           &lt;/sequence&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                   &lt;element name="DueAmount" minOccurs="0"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *                           &lt;/sequence&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"invoiceDetailRequestHeader", "invoiceDetailOrder", "invoiceDetailSummary"})
public class InvoiceDetailRequest {

    @XmlElement(name = "InvoiceDetailRequestHeader", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected InvoiceDetailRequestHeader invoiceDetailRequestHeader;
    @XmlElement(name = "InvoiceDetailOrder", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected List<InvoiceDetailOrder> invoiceDetailOrder;
    @XmlElement(name = "InvoiceDetailSummary", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected InvoiceDetailSummary invoiceDetailSummary;

    /**
     * Gets the value of the invoiceDetailRequestHeader property.
     *
     * @return possible object is {@link InvoiceDetailRequestHeader }
     */
    public InvoiceDetailRequestHeader getInvoiceDetailRequestHeader() {
        return invoiceDetailRequestHeader;
    }

    /**
     * Sets the value of the invoiceDetailRequestHeader property.
     *
     * @param invoiceDetailRequestHeader allowed object is {@link InvoiceDetailRequestHeader }
     */
    public void setInvoiceDetailRequestHeader(final InvoiceDetailRequestHeader invoiceDetailRequestHeader) {
        this.invoiceDetailRequestHeader = invoiceDetailRequestHeader;
    }

    /**
     * Gets the value of the invoiceDetailOrder property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the invoiceDetailOrder property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInvoiceDetailOrder().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link InvoiceDetailOrder }
     */
    public List<InvoiceDetailOrder> getInvoiceDetailOrder() {
        if (invoiceDetailOrder == null) {
            invoiceDetailOrder = new ArrayList<>();
        }
        return invoiceDetailOrder;
    }

    /**
     * Gets the value of the invoiceDetailSummary property.
     *
     * @return possible object is {@link InvoiceDetailSummary }
     */
    public InvoiceDetailSummary getInvoiceDetailSummary() {
        return invoiceDetailSummary;
    }

    /**
     * Sets the value of the invoiceDetailSummary property.
     *
     * @param invoiceDetailSummary allowed object is {@link InvoiceDetailSummary }
     */
    public void setInvoiceDetailSummary(final InvoiceDetailSummary invoiceDetailSummary) {
        this.invoiceDetailSummary = invoiceDetailSummary;
    }

    public List<ElectronicInvoiceOrder> getElectronicInvoiceOrders() {
        if (CollectionUtils.isNotEmpty(invoiceDetailOrder)) {
            return invoiceDetailOrder.stream()
                    .map(InvoiceDetailOrder::toElectronicInvoiceOrder)
                    .collect(Collectors.toList());
        }
        return Collections.emptyList();

    }

}
