/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Contact" maxOccurs="unbounded"/&gt;
 *         &lt;element name="IdReference" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="Creator" type="{http://www.kuali.org/kfs/sys/types}zeroToTwentyCharType" minOccurs="0"/&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Description" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *                 &lt;attribute name="domain" use="required" type="{http://www.kuali.org/kfs/sys/types}zeroToTwentyCharType" /&gt;
 *                 &lt;attribute name="identifier" use="required" type="{http://www.kuali.org/kfs/sys/types}zeroToTwentyCharType" /&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"contact", "idReference"})
public class InvoicePartner {

    @XmlElement(name = "Contact", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    private List<Contact> contact;

    @XmlElement(name = "IdReference", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    private IdReference idReference;

    /**
     * Gets the value of the contact property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore, any modification you make
     * to the returned list will be present inside the Jakarta XML Binding object. This is why there is not a {@code
     * set} method for the contact property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContact().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link Contact }
     */
    public List<Contact> getContact() {
        if (contact == null) {
            contact = new ArrayList<>();
        }
        return contact;
    }

    /**
     * Gets the value of the idReference property.
     *
     * @return possible object is {@link IdReference }
     */
    public IdReference getIdReference() {
        return idReference;
    }

    /**
     * Sets the value of the idReference property.
     *
     * @param idReference allowed object is {@link IdReference }
     */
    public void setIdReference(final IdReference idReference) {
        this.idReference = idReference;
    }

}
