/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Credential"/&gt;
 *         &lt;element name="UserAgent" type="{http://www.kuali.org/kfs/sys/types}zeroToFiftyFiveCharType"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"credential", "userAgent"})
public class Sender {

    @XmlElement(name = "Credential", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected Credential credential;
    @XmlElement(name = "UserAgent", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected String userAgent;

    // Need to have for Unmarshalling
    public Sender() {
    }

    public Sender(final String domain, final String identity, final String sharedSecret, final String userAgent) {
        credential = new Credential();
        credential.setDomain(domain);
        credential.setIdentity(identity);
        credential.setSharedSecret(sharedSecret);
        this.userAgent = userAgent;
    }

    /**
     * Gets the value of the credential property.
     *
     * @return possible object is {@link Credential }
     */
    public Credential getCredential() {
        return credential;
    }

    /**
     * Sets the value of the credential property.
     *
     * @param credential allowed object is {@link Credential }
     */
    public void setCredential(final Credential credential) {
        this.credential = credential;
    }

    /**
     * Gets the value of the userAgent property.
     *
     * @return possible object is {@link String }
     */
    public String getUserAgent() {
        return userAgent;
    }

    /**
     * Sets the value of the userAgent property.
     *
     * @param userAgent allowed object is {@link String }
     */
    public void setUserAgent(final String userAgent) {
        this.userAgent = userAgent;
    }

}
