/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

import java.math.BigDecimal;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="TaxableAmount" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="TaxAmount"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="TaxLocation" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
 *                 &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang use="required""/&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Description" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="purpose" type="{http://www.kuali.org/kfs/sys/types}oneToFiftyCharType" /&gt;
 *       &lt;attribute name="category" use="required" type="{http://www.kuali.org/kfs/sys/types}oneToFiftyCharType" /&gt;
 *       &lt;attribute name="percentageRate" type="{http://www.w3.org/2001/XMLSchema}decimal" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"taxableAmount", "taxAmount", "taxLocation", "description"})
public class TaxDetail {

    @XmlElement(name = "TaxableAmount", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected TaxableAmount taxableAmount;
    @XmlElement(name = "TaxAmount", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected TaxAmount taxAmount;
    @XmlElement(name = "TaxLocation", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected TaxLocation taxLocation;
    @XmlElement(name = "Description", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected Description description;
    @XmlAttribute(name = "purpose")
    protected String purpose;
    @XmlAttribute(name = "category", required = true)
    protected String category;
    @XmlAttribute(name = "percentageRate")
    protected BigDecimal percentageRate;

    /**
     * Gets the value of the taxableAmount property.
     *
     * @return possible object is {@link TaxableAmount }
     */
    public TaxableAmount getTaxableAmount() {
        return taxableAmount;
    }

    /**
     * Sets the value of the taxableAmount property.
     *
     * @param taxableAmount allowed object is {@link TaxableAmount }
     */
    public void setTaxableAmount(final TaxableAmount taxableAmount) {
        this.taxableAmount = taxableAmount;
    }

    /**
     * Gets the value of the taxAmount property.
     *
     * @return possible object is {@link TaxAmount }
     */
    public TaxAmount getTaxAmount() {
        return taxAmount;
    }

    /**
     * Sets the value of the taxAmount property.
     *
     * @param taxAmount allowed object is {@link TaxAmount }
     */
    public void setTaxAmount(final TaxAmount taxAmount) {
        this.taxAmount = taxAmount;
    }

    /**
     * Gets the value of the taxLocation property.
     *
     * @return possible object is {@link TaxLocation }
     */
    public TaxLocation getTaxLocation() {
        return taxLocation;
    }

    /**
     * Sets the value of the taxLocation property.
     *
     * @param taxLocation allowed object is {@link TaxLocation }
     */
    public void setTaxLocation(final TaxLocation taxLocation) {
        this.taxLocation = taxLocation;
    }

    /**
     * Gets the value of the description property.
     *
     * @return possible object is {@link Description }
     */
    public Description getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     *
     * @param description allowed object is {@link Description }
     */
    public void setDescription(final Description description) {
        this.description = description;
    }

    /**
     * Gets the value of the purpose property.
     *
     * @return possible object is {@link String }
     */
    public String getPurpose() {
        return purpose;
    }

    /**
     * Sets the value of the purpose property.
     *
     * @param purpose allowed object is {@link String }
     */
    public void setPurpose(final String purpose) {
        this.purpose = purpose;
    }

    /**
     * Gets the value of the category property.
     *
     * @return possible object is {@link String }
     */
    public String getCategory() {
        return category;
    }

    /**
     * Sets the value of the category property.
     *
     * @param category allowed object is {@link String }
     */
    public void setCategory(final String category) {
        this.category = category;
    }

    /**
     * Gets the value of the percentageRate property.
     *
     * @return possible object is {@link BigDecimal }
     */
    public BigDecimal getPercentageRate() {
        return percentageRate;
    }

    /**
     * Sets the value of the percentageRate property.
     *
     * @param percentageRate allowed object is {@link BigDecimal }
     */
    public void setPercentageRate(final BigDecimal percentageRate) {
        this.percentageRate = percentageRate;
    }

}
