/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.dataaccess.impl;

import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.kfs.module.purap.dataaccess.B2BDao;
import org.kuali.kfs.module.purap.exception.B2BConnectionException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

import java.io.IOException;

public class B2BDaoImpl extends PlatformAwareDaoBaseOjb implements B2BDao {

    private static final Logger LOG = LogManager.getLogger();

    /**
     * Take the request XML, post it to SciQuest, then get the response XML and return it.
     */
    @Override
    public String sendPunchOutRequest(final String request, final String punchoutUrl) {
        LOG.debug("sendPunchOutRequest() started");

        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            final HttpPost httpPost = new HttpPost(punchoutUrl);
            httpPost.addHeader(HttpHeaders.ACCEPT, MediaType.TEXT_XML);
            httpPost.addHeader(HttpHeaders.CONTENT_TYPE, MediaType.TEXT_XML);
            httpPost.setEntity(new StringEntity(request));

            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                final HttpEntity entity = response.getEntity();
                return EntityUtils.toString(entity);
            }

        } catch (IOException | ParseException e) {
            LOG.error("postPunchOutSetupRequestMessage() Error posting setup", e);
            throw new B2BConnectionException("Unable to connect to remote site for punchout.", e);
        }
    }
}
