/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.document;

import org.kuali.kfs.module.purap.businessobject.AccountsPayableItem;
import org.kuali.kfs.module.purap.businessobject.PurApItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.service.AccountsPayableDocumentSpecificService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.vnd.businessobject.CampusParameter;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.sql.Timestamp;

public interface AccountsPayableDocument extends PurchasingAccountsPayableDocument {

    Integer getPurchaseOrderIdentifier();

    void setPurchaseOrderIdentifier(Integer purchaseOrderIdentifier);

    String getAccountsPayableProcessorIdentifier();

    void setAccountsPayableProcessorIdentifier(String accountsPayableProcessorIdentifier);

    String getLastActionPerformedByPersonId();

    void setLastActionPerformedByPersonId(String lastActionPerformedByPersonId);

    String getProcessingCampusCode();

    void setProcessingCampusCode(String processingCampusCode);

    Timestamp getAccountsPayableApprovalTimestamp();

    void setAccountsPayableApprovalTimestamp(Timestamp accountsPayableApprovalTimestamp);

    Timestamp getExtractedTimestamp();

    void setExtractedTimestamp(Timestamp extractedTimestamp);

    boolean isHoldIndicator();

    void setHoldIndicator(boolean holdIndicator);

    String getNoteLine1Text();

    void setNoteLine1Text(String noteLine1Text);

    String getNoteLine2Text();

    void setNoteLine2Text(String noteLine2Text);

    String getNoteLine3Text();

    void setNoteLine3Text(String noteLine3Text);

    CampusParameter getProcessingCampus();

    PurchaseOrderDocument getPurchaseOrderDocument();

    void setPurchaseOrderDocument(PurchaseOrderDocument purchaseOrderDocument);

    /**
     * @return true if review is required, false otherwise.
     */
    boolean requiresAccountsPayableReviewRouting();

    /**
     * @return true if approval is available during review, false otherwise.
     */
    boolean approvalAtAccountsPayableReviewAllowed();

    boolean isUnmatchedOverride();

    void setUnmatchedOverride(boolean unmatchedOverride);

    /**
     * @return grand total amount for document.
     */
    KualiDecimal getGrandTotal();

    /**
     * @return total of document tax to remit to the vendor; null if none
     */
    KualiDecimal getTotalRemitTax();

    /**
     * @return amount entered by user on initial screen
     */
    KualiDecimal getInitialAmount();

    boolean isContinuationAccountIndicator();

    void setContinuationAccountIndicator(boolean continuationAccountIndicator);

    /**
     * @return true if document has been extracted, false otherwise.
     */
    boolean isExtracted();

    AccountsPayableItem getAPItemFromPOItem(PurchaseOrderItem poi);

    AccountsPayableDocumentSpecificService getDocumentSpecificService();

    boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail,
            GeneralLedgerPendingEntrySequenceHelper sequenceHelper, PurApItemUseTax offsetUseTax);

}

