/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentPresentationController;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADConstants;
import org.kuali.kfs.module.purap.PurapAuthorizationConstants;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.PurapParameterConstants;
import org.kuali.kfs.module.purap.PurapRuleConstants;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

import java.util.Set;

public class RequisitionNewIndividualItemValidation extends PurchasingNewIndividualItemValidation {

    private DocumentDictionaryService documentDictionaryService;

    @Override
    protected boolean commodityCodeIsRequired() {
        // if the ENABLE_COMMODITY_CODE_IND parameter is N then we don't need to check for the
        // ITEMS_REQUIRE_COMMODITY_CODE_IND parameter anymore, just return false.
        boolean enableCommodityCode = parameterService.getParameterValueAsBoolean(PurapConstants.PURAP_NAMESPACE,
                KfsParameterConstants.DOCUMENT_COMPONENT, PurapParameterConstants.ENABLE_COMMODITY_CODE_IND);

        if (!enableCommodityCode) {
            return false;
        }

        final Boolean itemsRequireCommodityCode = parameterService.getParameterValueAsBoolean(RequisitionDocument.class,
                PurapRuleConstants.ITEMS_REQUIRE_COMMODITY_CODE_IND);

        if (!itemsRequireCommodityCode) {
            return false;
        }

        // If we've made it this far, commodity codes are enabled and items require commodity codes. However, we only
        // want to require commodity codes if the user can actually edit them, since otherwise they could be presented
        // with an error they couldn't fix.
        return userCanEditDocument();
    }

    private boolean userCanEditDocument() {
        final AccountingDocument accountingDocument = getItemForValidation().getPurapDocument();

        final TransactionalDocumentPresentationController presentationController =
                (TransactionalDocumentPresentationController) documentDictionaryService
                        .getDocumentPresentationController(accountingDocument);
        final TransactionalDocumentAuthorizer documentAuthorizer =
                (TransactionalDocumentAuthorizer) documentDictionaryService.getDocumentAuthorizer(accountingDocument);
        final Person person = GlobalVariables.getUserSession().getPerson();

        final Set<String> presentationControllerEditModes = presentationController.getEditModes(accountingDocument);
        final Set<String> editModes = documentAuthorizer.getEditModes(accountingDocument, person,
                presentationControllerEditModes);

        final Set<String> presentationControllerDocumentActions =
                presentationController.getDocumentActions(accountingDocument);
        final Set<String> documentActions = documentAuthorizer.getDocumentActions(accountingDocument,
                person, presentationControllerDocumentActions);

        return documentActions.contains(KRADConstants.KUALI_ACTION_CAN_EDIT)
                && !editModes.contains(PurapAuthorizationConstants.RequisitionEditMode.RESTRICT_FULL_ENTRY);
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }
}
