/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.util.cxml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="Identity" type="{http://www.kuali.org/kfs/purap/types}dunsNumberType"/&gt;
 *         &lt;element name="SharedSecret" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="domain" use="required" type="{http://www.kuali.org/kfs/purap/types}domainType" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"identity", "sharedSecret"})
@XmlRootElement(name = "Credential", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE)
public class Credential {

    @XmlAttribute(name = "domain", required = true)
    private String domain;

    @XmlElement(name = "Identity", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private String identity;

    @XmlElement(name = "SharedSecret", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE)
    private String sharedSecret;

    public Credential() {
    }

    public Credential(final String domain, final String identity) {
        this.domain = domain;
        this.identity = identity;
    }

    /**
     * Gets the value of the domain property.
     *
     * @return possible object is {@link String }
     */
    public String getDomain() {
        return domain;
    }

    /**
     * Sets the value of the domain property.
     *
     * @param domain allowed object is {@link String }
     */
    public void setDomain(final String domain) {
        this.domain = domain;
    }

    /**
     * Gets the value of the identity property.
     *
     * @return possible object is {@link String }
     */
    public String getIdentity() {
        return identity;
    }

    /**
     * Sets the value of the identity property.
     *
     * @param identity allowed object is {@link String }
     */
    public void setIdentity(final String identity) {
        this.identity = identity;
    }

    /**
     * Gets the value of the sharedSecret property.
     *
     * @return possible object is {@link String }
     */
    public String getSharedSecret() {
        return sharedSecret;
    }

    /**
     * Sets the value of the sharedSecret property.
     *
     * @param sharedSecret allowed object is {@link String }
     */
    public void setSharedSecret(final String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

}
