/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Created on Mar 10, 2005
 *
 */
package org.kuali.kfs.module.purap.util.cxml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="From"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Credential"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="To"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Credential"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="Sender"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Credential"/&gt;
 *                   &lt;element name="UserAgent" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"from", "to", "sender"})
public class CxmlHeader {

    @XmlElement(name = "From", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private final From from = new From();

    @XmlElement(name = "Sender", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private Sender sender = new Sender();

    @XmlElement(name = "To", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private final To to = new To();

    @XmlTransient
    private String fromType;

    @XmlTransient
    private String toType;

    @XmlTransient
    private String senderType;

    public void setFrom(final String domain, final String identity) {
        setFrom(domain, identity, null);
    }

    public void setFrom(final String domain, final String identity, final String type) {
        from.setCredential(new Credential(domain, identity));
        fromType = type;
    }

    public void setTo(final String domain, final String identity) {
        setTo(domain, identity, null);
    }

    public void setTo(final String domain, final String identity, final String type) {
        to.setCredential(new Credential(domain, identity));
        toType = type;
    }

    public void setSender(final Sender sender) {
        this.sender = sender;
    }

    public void setSender(final String domain, final String identity) {
        setSender(domain, identity, null);
    }

    public void setSender(final String domain, final String identity, final String type) {
        sender.setCredential(new Credential(domain, identity));
        senderType = type;
    }

    public String getFromDomain() {
        return from.getCredential().getDomain();
    }

    public void setFromDomain(final String fromDomain) {
        from.getCredential().setDomain(fromDomain);
    }

    public String getFromIdentity() {
        return from.getCredential().getIdentity();
    }

    public void setFromIdentity(final String fromIdentity) {
        from.getCredential().setIdentity(fromIdentity);
    }

    public String getFromType() {
        return fromType;
    }

    public void setFromType(final String fromType) {
        this.fromType = fromType;
    }

    public String getSenderDomain() {
        return sender.getCredential().getDomain();
    }

    public void setSenderDomain(final String senderDomain) {
        sender.getCredential().setDomain(senderDomain);
    }

    public String getSenderIdentity() {
        return sender.getCredential().getIdentity();
    }

    public void setSenderIdentity(final String senderIdentity) {
        sender.getCredential().setIdentity(senderIdentity);
    }

    public String getSenderType() {
        return senderType;
    }

    public void setSenderType(final String senderType) {
        this.senderType = senderType;
    }

    public String getSenderUserAgent() {
        return sender.getUserAgent();
    }

    public void setSenderUserAgent(final String senderUserAgent) {
        sender.setUserAgent(senderUserAgent);
    }

    public String getToDomain() {
        return to.getCredential().getDomain();
    }

    public void setToDomain(final String toDomain) {
        to.getCredential().setDomain(toDomain);
    }

    public String getToIdentity() {
        return to.getCredential().getIdentity();
    }

    public void setToIdentity(final String toIdentity) {
        to.getCredential().setIdentity(toIdentity);
    }

    public String getToType() {
        return toType;
    }

    public void setToType(final String toType) {
        this.toType = toType;
    }

    public String getSenderSharedSecret() {
        return sender.getCredential().getSharedSecret();
    }

    public void setSenderSharedSecret(final String senderSharedSecret) {
        sender.getCredential().setSharedSecret(senderSharedSecret);
    }

    public String getFromSharedSecret() {
        return from.getCredential().getSharedSecret();
    }

    public void setFromSharedSecret(final String fromSharedSecret) {
        from.getCredential().setSharedSecret(fromSharedSecret);
    }

    public String getToSharedSecret() {
        return to.getCredential().getSharedSecret();
    }

    public void setToSharedSecret(final String toSharedSecret) {
        to.getCredential().setSharedSecret(toSharedSecret);
    }

    @Override
    public String toString() {
        final ToStringBuilder toString = new ToStringBuilder(this);

        toString.append("FromDomain", getFromDomain());
        toString.append("FromIdentity", getFromIdentity());
        toString.append("FromSharedSecret", getFromSharedSecret());
        toString.append("FromType", fromType);

        toString.append("ToDomain", getToDomain());
        toString.append("ToIdentity", getToIdentity());
        toString.append("ToSharedSecret", getToSharedSecret());
        toString.append("ToType", toType);

        toString.append("SenderDomain", getSenderDomain());
        toString.append("SenderIdentity", getSenderIdentity());
        toString.append("SenderType", senderType);
        toString.append("SenderSharedSecret", getSenderSharedSecret());
        toString.append("SenderUserAgent", getSenderUserAgent());

        return toString.toString();
    }
}
