/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.util.cxml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="BuyerCookie" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="PunchOutOrderMessageHeader"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="Total"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Money"/&gt;
 *                           &lt;/sequence&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                 &lt;/sequence&gt;
 *                 &lt;attribute name="operationAllowed" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *                 &lt;attribute name="quoteStatus" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="ItemIn" maxOccurs="unbounded"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}ItemID"/&gt;
 *                   &lt;element name="ItemDetail"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}UnitPrice"/&gt;
 *                             &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Description"/&gt;
 *                             &lt;element name="UnitOfMeasure" type="{http://www.kuali.org/kfs/purap/types}uomType"/&gt;
 *                             &lt;element name="Classification" maxOccurs="unbounded"&gt;
 *                               &lt;complexType&gt;
 *                                 &lt;simpleContent&gt;
 *                                   &lt;extension base="&lt;http://www.kuali.org/kfs/sys/types&gt;zeroToThirtyCharType"&gt;
 *                                     &lt;attribute name="domain" type="{http://www.kuali.org/kfs/sys/types}oneToTwentyOneCharType" /&gt;
 *                                   &lt;/extension&gt;
 *                                 &lt;/simpleContent&gt;
 *                               &lt;/complexType&gt;
 *                             &lt;/element&gt;
 *                             &lt;element name="ManufacturerPartID" type="{http://www.kuali.org/kfs/sys/types}oneToTwentyOneCharType" minOccurs="0"/&gt;
 *                             &lt;element name="ManufacturerName" type="{http://www.kuali.org/kfs/sys/types}zeroToFiftyFiveCharType" minOccurs="0"/&gt;
 *                             &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Extrinsic" maxOccurs="unbounded"/&gt;
 *                           &lt;/sequence&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                   &lt;element name="SupplierID" maxOccurs="unbounded" minOccurs="0"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;simpleContent&gt;
 *                         &lt;extension base="&lt;http://www.kuali.org/kfs/sys/types&gt;zeroToNinetyCharType"&gt;
 *                           &lt;attribute name="domain" type="{http://www.kuali.org/kfs/sys/types}zeroToTwentyCharType" /&gt;
 *                         &lt;/extension&gt;
 *                       &lt;/simpleContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                 &lt;/sequence&gt;
 *                 &lt;attribute name="quantity" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"buyerCookie", "punchOutOrderMessageHeader", "itemIn"})
public class PunchOutOrderMessage {

    @XmlElement(name = "BuyerCookie", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private String buyerCookie;

    @XmlElement(name = "ItemIn", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private List<ItemIn> itemIn = new ArrayList<>();

    @XmlElement(name = "PunchOutOrderMessageHeader", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE,
            required = true)
    private PunchOutOrderMessageHeader punchOutOrderMessageHeader = new PunchOutOrderMessageHeader();

    /**
     * Gets the value of the buyerCookie property.
     *
     * @return possible object is {@link String }
     */
    public String getBuyerCookie() {
        return buyerCookie;
    }

    /**
     * Sets the value of the buyerCookie property.
     *
     * @param buyerCookie allowed object is {@link String }
     */
    public void setBuyerCookie(final String buyerCookie) {
        this.buyerCookie = buyerCookie;
    }

    /**
     * Gets the value of the itemIn property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore, any modification you
     * make to the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * {@code set} method for the itemIn property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItemIn().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link ItemIn }
     */
    public List<ItemIn> getItemInList() {
        if (itemIn == null) {
            itemIn = new ArrayList<>();
        }
        return itemIn;
    }

    /**
     * Gets the value of the punchOutOrderMessageHeader property.
     *
     * @return possible object is {@link PunchOutOrderMessageHeader }
     */
    public PunchOutOrderMessageHeader getPunchOutOrderMessageHeader() {
        return punchOutOrderMessageHeader;
    }

    /**
     * Sets the value of the punchOutOrderMessageHeader property.
     *
     * @param punchOutOrderMessageHeader allowed object is {@link PunchOutOrderMessageHeader }
     */
    public void setPunchOutOrderMessageHeader(final PunchOutOrderMessageHeader punchOutOrderMessageHeader) {
        this.punchOutOrderMessageHeader = punchOutOrderMessageHeader;
    }

}
