/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.util.cxml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="Header"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="MessageId" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *                   &lt;element name="Timestamp" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="ResponseMessage"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="Status"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;element name="StatusCode" type="{http://www.kuali.org/kfs/purap/types}statusCodeType"/&gt;
 *                             &lt;element name="StatusText" type="{http://www.kuali.org/kfs/purap/types}statusTextType"/&gt;
 *                             &lt;element name="Errors" minOccurs="0"&gt;
 *                               &lt;complexType&gt;
 *                                 &lt;complexContent&gt;
 *                                   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                                     &lt;sequence&gt;
 *                                       &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPOResponse}Error" maxOccurs="unbounded"/&gt;
 *                                     &lt;/sequence&gt;
 *                                   &lt;/restriction&gt;
 *                                 &lt;/complexContent&gt;
 *                               &lt;/complexType&gt;
 *                             &lt;/element&gt;
 *                           &lt;/sequence&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                   &lt;element name="ObjectErrors" minOccurs="0"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;element name="PurchaseOrderRef" minOccurs="0"&gt;
 *                               &lt;complexType&gt;
 *                                 &lt;complexContent&gt;
 *                                   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                                     &lt;sequence&gt;
 *                                       &lt;element name="Error" maxOccurs="unbounded"&gt;
 *                                         &lt;complexType&gt;
 *                                           &lt;complexContent&gt;
 *                                             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                                               &lt;sequence&gt;
 *                                                 &lt;element name="ErrorMessage" type="{http://www.w3.org/2001/XMLSchema}anyType" maxOccurs="unbounded"/&gt;
 *                                               &lt;/sequence&gt;
 *                                               &lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *                                             &lt;/restriction&gt;
 *                                           &lt;/complexContent&gt;
 *                                         &lt;/complexType&gt;
 *                                       &lt;/element&gt;
 *                                     &lt;/sequence&gt;
 *                                     &lt;attribute name="ponumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
 *                                   &lt;/restriction&gt;
 *                                 &lt;/complexContent&gt;
 *                               &lt;/complexType&gt;
 *                             &lt;/element&gt;
 *                             &lt;element name="PurchaseOrderLineRef" minOccurs="0"&gt;
 *                               &lt;complexType&gt;
 *                                 &lt;complexContent&gt;
 *                                   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                                     &lt;sequence&gt;
 *                                       &lt;element name="Error" maxOccurs="unbounded"&gt;
 *                                         &lt;complexType&gt;
 *                                           &lt;complexContent&gt;
 *                                             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                                               &lt;sequence&gt;
 *                                                 &lt;element name="ErrorMessage" type="{http://www.w3.org/2001/XMLSchema}anyType" maxOccurs="unbounded"/&gt;
 *                                               &lt;/sequence&gt;
 *                                               &lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *                                             &lt;/restriction&gt;
 *                                           &lt;/complexContent&gt;
 *                                         &lt;/complexType&gt;
 *                                       &lt;/element&gt;
 *                                     &lt;/sequence&gt;
 *                                     &lt;attribute name="ponumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
 *                                     &lt;attribute name="linenumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
 *                                   &lt;/restriction&gt;
 *                                 &lt;/complexContent&gt;
 *                               &lt;/complexType&gt;
 *                             &lt;/element&gt;
 *                           &lt;/sequence&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="version" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"header", "responseMessage"})
@XmlRootElement(name = "PurchaseOrderMessage", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE)
public class PurchaseOrderMessage {

    @XmlElement(name = "Header", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE, required = true)
    private PurchaseOrderMessage.Header header = new Header();
    @XmlElement(name = "ResponseMessage", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE, required = true)
    private PurchaseOrderMessage.ResponseMessage responseMessage = new ResponseMessage();
    @XmlAttribute(name = "version")
    private String version;

    /**
     * Gets the value of the header property.
     *
     * @return possible object is {@link PurchaseOrderMessage.Header }
     */
    public PurchaseOrderMessage.Header getHeader() {
        return header;
    }

    /**
     * Sets the value of the header property.
     *
     * @param header allowed object is {@link PurchaseOrderMessage.Header }
     */
    public void setHeader(final PurchaseOrderMessage.Header header) {
        this.header = header;
    }

    /**
     * Gets the value of the responseMessage property.
     *
     * @return possible object is {@link PurchaseOrderMessage.ResponseMessage }
     */
    public PurchaseOrderMessage.ResponseMessage getResponseMessage() {
        return responseMessage;
    }

    /**
     * Sets the value of the responseMessage property.
     *
     * @param responseMessage allowed object is {@link PurchaseOrderMessage.ResponseMessage }
     */
    public void setResponseMessage(final PurchaseOrderMessage.ResponseMessage responseMessage) {
        this.responseMessage = responseMessage;
    }

    /**
     * Gets the value of the version property.
     *
     * @return possible object is {@link String }
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     *
     * @param version allowed object is {@link String }
     */
    public void setVersion(final String version) {
        this.version = version;
    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element name="MessageId" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
     *         &lt;element name="Timestamp" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
     *       &lt;/sequence&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {"messageId", "timestamp"})
    public static class Header {

        @XmlElement(name = "MessageId", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE, required = true)
        private String messageId;
        @XmlElement(name = "Timestamp", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE, required = true)
        private String timestamp;

        /**
         * Gets the value of the messageId property.
         *
         * @return possible object is {@link String }
         */
        public String getMessageId() {
            return messageId;
        }

        /**
         * Sets the value of the messageId property.
         *
         * @param messageId allowed object is {@link String }
         */
        public void setMessageId(final String messageId) {
            this.messageId = messageId;
        }

        /**
         * Gets the value of the timestamp property.
         *
         * @return possible object is {@link String }
         */
        public String getTimestamp() {
            return timestamp;
        }

        /**
         * Sets the value of the timestamp property.
         *
         * @param timestamp allowed object is {@link String }
         */
        public void setTimestamp(final String timestamp) {
            this.timestamp = timestamp;
        }

    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element name="Status"&gt;
     *           &lt;complexType&gt;
     *             &lt;complexContent&gt;
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                 &lt;sequence&gt;
     *                   &lt;element name="StatusCode" type="{http://www.kuali.org/kfs/purap/types}statusCodeType"/&gt;
     *                   &lt;element name="StatusText" type="{http://www.kuali.org/kfs/purap/types}statusTextType"/&gt;
     *                   &lt;element name="Errors" minOccurs="0"&gt;
     *                     &lt;complexType&gt;
     *                       &lt;complexContent&gt;
     *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                           &lt;sequence&gt;
     *                             &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPOResponse}Error" maxOccurs="unbounded"/&gt;
     *                           &lt;/sequence&gt;
     *                         &lt;/restriction&gt;
     *                       &lt;/complexContent&gt;
     *                     &lt;/complexType&gt;
     *                   &lt;/element&gt;
     *                 &lt;/sequence&gt;
     *               &lt;/restriction&gt;
     *             &lt;/complexContent&gt;
     *           &lt;/complexType&gt;
     *         &lt;/element&gt;
     *         &lt;element name="ObjectErrors" minOccurs="0"&gt;
     *           &lt;complexType&gt;
     *             &lt;complexContent&gt;
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                 &lt;sequence&gt;
     *                   &lt;element name="PurchaseOrderRef" minOccurs="0"&gt;
     *                     &lt;complexType&gt;
     *                       &lt;complexContent&gt;
     *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                           &lt;sequence&gt;
     *                             &lt;element name="Error" maxOccurs="unbounded"&gt;
     *                               &lt;complexType&gt;
     *                                 &lt;complexContent&gt;
     *                                   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                                     &lt;sequence&gt;
     *                                       &lt;element name="ErrorMessage" type="{http://www.w3.org/2001/XMLSchema}anyType" maxOccurs="unbounded"/&gt;
     *                                     &lt;/sequence&gt;
     *                                     &lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
     *                                   &lt;/restriction&gt;
     *                                 &lt;/complexContent&gt;
     *                               &lt;/complexType&gt;
     *                             &lt;/element&gt;
     *                           &lt;/sequence&gt;
     *                           &lt;attribute name="ponumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
     *                         &lt;/restriction&gt;
     *                       &lt;/complexContent&gt;
     *                     &lt;/complexType&gt;
     *                   &lt;/element&gt;
     *                   &lt;element name="PurchaseOrderLineRef" minOccurs="0"&gt;
     *                     &lt;complexType&gt;
     *                       &lt;complexContent&gt;
     *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                           &lt;sequence&gt;
     *                             &lt;element name="Error" maxOccurs="unbounded"&gt;
     *                               &lt;complexType&gt;
     *                                 &lt;complexContent&gt;
     *                                   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                                     &lt;sequence&gt;
     *                                       &lt;element name="ErrorMessage" type="{http://www.w3.org/2001/XMLSchema}anyType" maxOccurs="unbounded"/&gt;
     *                                     &lt;/sequence&gt;
     *                                     &lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
     *                                   &lt;/restriction&gt;
     *                                 &lt;/complexContent&gt;
     *                               &lt;/complexType&gt;
     *                             &lt;/element&gt;
     *                           &lt;/sequence&gt;
     *                           &lt;attribute name="ponumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
     *                           &lt;attribute name="linenumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
     *                         &lt;/restriction&gt;
     *                       &lt;/complexContent&gt;
     *                     &lt;/complexType&gt;
     *                   &lt;/element&gt;
     *                 &lt;/sequence&gt;
     *               &lt;/restriction&gt;
     *             &lt;/complexContent&gt;
     *           &lt;/complexType&gt;
     *         &lt;/element&gt;
     *       &lt;/sequence&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {"status", "objectErrors"})
    public static class ResponseMessage {

        @XmlElement(name = "Status", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE, required = true)
        private PurchaseOrderMessage.Status status = new Status();
        @XmlElement(name = "ObjectErrors", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE)
        private PurchaseOrderMessage.ObjectErrors objectErrors = new ObjectErrors();

        /**
         * Gets the value of the status property.
         *
         * @return possible object is {@link PurchaseOrderMessage.Status }
         */
        public PurchaseOrderMessage.Status getStatus() {
            return status;
        }

        /**
         * Sets the value of the status property.
         *
         * @param status allowed object is {@link PurchaseOrderMessage.Status }
         */
        public void setStatus(final PurchaseOrderMessage.Status status) {
            this.status = status;
        }

        /**
         * Gets the value of the objectErrors property.
         *
         * @return possible object is {@link PurchaseOrderMessage.ObjectErrors }
         */
        public PurchaseOrderMessage.ObjectErrors getObjectErrors() {
            return objectErrors;
        }

        /**
         * Sets the value of the objectErrors property.
         *
         * @param objectErrors allowed object is {@link PurchaseOrderMessage.ObjectErrors }
         */
        public void setObjectErrors(final PurchaseOrderMessage.ObjectErrors objectErrors) {
            this.objectErrors = objectErrors;
        }

    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element name="ErrorMessage" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
     *       &lt;/sequence&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = "errorMessage")
    @XmlRootElement(name = "Error", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE)
    public static class Error {

        @XmlElement(name = "ErrorMessage", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE, required = true)
        private String errorMessage;

        @XmlAttribute(name = "type")
        private String type;

        /**
         * Gets the value of the errorMessage property.
         *
         * @return possible object is {@link String }
         */
        public String getErrorMessage() {
            return errorMessage;
        }

        /**
         * Sets the value of the errorMessage property.
         *
         * @param errorMessage allowed object is {@link String }
         */
        public void setErrorMessage(final String errorMessage) {
            this.errorMessage = errorMessage;
        }

        /**
         * Gets the value of the type property.
         *
         * @return possible object is {@link String }
         */
        public String getType() {
            return type;
        }

        /**
         * Sets the value of the type property.
         *
         * @param type allowed object is {@link String }
         */
        public void setType(final String type) {
            this.type = type;
        }

    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element name="PurchaseOrderRef" minOccurs="0"&gt;
     *           &lt;complexType&gt;
     *             &lt;complexContent&gt;
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                 &lt;sequence&gt;
     *                   &lt;element name="Error" maxOccurs="unbounded"&gt;
     *                     &lt;complexType&gt;
     *                       &lt;complexContent&gt;
     *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                           &lt;sequence&gt;
     *                             &lt;element name="ErrorMessage" type="{http://www.w3.org/2001/XMLSchema}anyType" maxOccurs="unbounded"/&gt;
     *                           &lt;/sequence&gt;
     *                           &lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
     *                         &lt;/restriction&gt;
     *                       &lt;/complexContent&gt;
     *                     &lt;/complexType&gt;
     *                   &lt;/element&gt;
     *                 &lt;/sequence&gt;
     *                 &lt;attribute name="ponumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
     *               &lt;/restriction&gt;
     *             &lt;/complexContent&gt;
     *           &lt;/complexType&gt;
     *         &lt;/element&gt;
     *         &lt;element name="PurchaseOrderLineRef" minOccurs="0"&gt;
     *           &lt;complexType&gt;
     *             &lt;complexContent&gt;
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                 &lt;sequence&gt;
     *                   &lt;element name="Error" maxOccurs="unbounded"&gt;
     *                     &lt;complexType&gt;
     *                       &lt;complexContent&gt;
     *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                           &lt;sequence&gt;
     *                             &lt;element name="ErrorMessage" type="{http://www.w3.org/2001/XMLSchema}anyType" maxOccurs="unbounded"/&gt;
     *                           &lt;/sequence&gt;
     *                           &lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
     *                         &lt;/restriction&gt;
     *                       &lt;/complexContent&gt;
     *                     &lt;/complexType&gt;
     *                   &lt;/element&gt;
     *                 &lt;/sequence&gt;
     *                 &lt;attribute name="ponumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
     *                 &lt;attribute name="linenumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
     *               &lt;/restriction&gt;
     *             &lt;/complexContent&gt;
     *           &lt;/complexType&gt;
     *         &lt;/element&gt;
     *       &lt;/sequence&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {"purchaseOrderRef", "purchaseOrderLineRef"})
    public static class ObjectErrors {

        @XmlElement(name = "PurchaseOrderRef", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE)
        private PurchaseOrderMessage.PurchaseOrderRef purchaseOrderRef = new PurchaseOrderRef();
        @XmlElement(name = "PurchaseOrderLineRef", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE)
        private PurchaseOrderMessage.PurchaseOrderLineRef purchaseOrderLineRef = new PurchaseOrderLineRef();

        /**
         * Gets the value of the purchaseOrderRef property.
         *
         * @return possible object is {@link PurchaseOrderMessage.PurchaseOrderRef }
         */
        public PurchaseOrderMessage.PurchaseOrderRef getPurchaseOrderRef() {
            return purchaseOrderRef;
        }

        /**
         * Sets the value of the purchaseOrderRef property.
         *
         * @param purchaseOrderRef allowed object is {@link PurchaseOrderMessage.PurchaseOrderRef }
         */
        public void setPurchaseOrderRef(final PurchaseOrderMessage.PurchaseOrderRef purchaseOrderRef) {
            this.purchaseOrderRef = purchaseOrderRef;
        }

        /**
         * Gets the value of the purchaseOrderLineRef property.
         *
         * @return possible object is {@link PurchaseOrderMessage.PurchaseOrderLineRef }
         */
        public PurchaseOrderMessage.PurchaseOrderLineRef getPurchaseOrderLineRef() {
            return purchaseOrderLineRef;
        }

        /**
         * Sets the value of the purchaseOrderLineRef property.
         *
         * @param purchaseOrderLineRef allowed object is {@link PurchaseOrderMessage.PurchaseOrderLineRef }
         */
        public void setPurchaseOrderLineRef(final PurchaseOrderMessage.PurchaseOrderLineRef purchaseOrderLineRef) {
            this.purchaseOrderLineRef = purchaseOrderLineRef;
        }

    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element name="StatusCode" type="{http://www.kuali.org/kfs/purap/types}statusCodeType"/&gt;
     *         &lt;element name="StatusText" type="{http://www.kuali.org/kfs/purap/types}statusTextType"/&gt;
     *         &lt;element name="Errors" minOccurs="0"&gt;
     *           &lt;complexType&gt;
     *             &lt;complexContent&gt;
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                 &lt;sequence&gt;
     *                   &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPOResponse}Error" maxOccurs="unbounded"/&gt;
     *                 &lt;/sequence&gt;
     *               &lt;/restriction&gt;
     *             &lt;/complexContent&gt;
     *           &lt;/complexType&gt;
     *         &lt;/element&gt;
     *       &lt;/sequence&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {"statusCode", "statusText", "errors"})
    public static class Status {

        @XmlElement(name = "StatusCode", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE, required = true)
        @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
        @XmlSchemaType(name = "token")
        private String statusCode;
        @XmlElement(name = "StatusText", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE, required = true)
        private String statusText;
        @XmlElement(name = "Errors", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE)
        private PurchaseOrderMessage.Errors errors = new Errors();

        /**
         * Gets the value of the statusCode property.
         *
         * @return possible object is {@link String }
         */
        public String getStatusCode() {
            return statusCode;
        }

        /**
         * Sets the value of the statusCode property.
         *
         * @param statusCode allowed object is {@link String }
         */
        public void setStatusCode(final String statusCode) {
            this.statusCode = statusCode;
        }

        /**
         * Gets the value of the statusText property.
         *
         * @return possible object is {@link String }
         */
        public String getStatusText() {
            return statusText;
        }

        /**
         * Sets the value of the statusText property.
         *
         * @param statusText allowed object is {@link String }
         */
        public void setStatusText(final String statusText) {
            this.statusText = statusText;
        }

        /**
         * Gets the value of the errors property.
         *
         * @return possible object is {@link PurchaseOrderMessage.Errors }
         */
        public PurchaseOrderMessage.Errors getErrors() {
            return errors;
        }

        /**
         * Sets the value of the errors property.
         *
         * @param errors allowed object is {@link PurchaseOrderMessage.Errors }
         */
        public void setErrors(final PurchaseOrderMessage.Errors errors) {
            this.errors = errors;
        }

    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element name="Error" maxOccurs="unbounded"&gt;
     *           &lt;complexType&gt;
     *             &lt;complexContent&gt;
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                 &lt;sequence&gt;
     *                   &lt;element name="ErrorMessage" type="{http://www.w3.org/2001/XMLSchema}anyType" maxOccurs="unbounded"/&gt;
     *                 &lt;/sequence&gt;
     *                 &lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
     *               &lt;/restriction&gt;
     *             &lt;/complexContent&gt;
     *           &lt;/complexType&gt;
     *         &lt;/element&gt;
     *       &lt;/sequence&gt;
     *       &lt;attribute name="ponumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
     *       &lt;attribute name="linenumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = "errorList")
    public static class PurchaseOrderLineRef {

        @XmlAttribute(name = "ponumber", required = true)
        @XmlSchemaType(name = "unsignedInt")
        private long poNumber;
        @XmlAttribute(name = "linenumber", required = true)
        @XmlSchemaType(name = "unsignedInt")
        long linenumber;
        @XmlElement(name = "Error", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE, required = true)
        private List<Error> errorList;

        /**
         * Gets the value of the errorList property.
         *
         * <p>
         * This accessor method returns a reference to the live list, not a snapshot. Therefore, any modification you
         * make to the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
         * {@code set} method for the errorList property.
         *
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getErrorList().add(newItem);
         * </pre>
         *
         *
         * <p>
         * Objects of the following type(s) are allowed in the list {@link Error }
         */
        public List<Error> getErrorList() {
            if (errorList == null) {
                errorList = new ArrayList<>();
            }
            return errorList;
        }

        /**
         * Gets the value of the ponumber property.
         */
        public long getPoNumber() {
            return poNumber;
        }

        /**
         * Sets the value of the ponumber property.
         */
        public void setPoNumber(final long poNumber) {
            this.poNumber = poNumber;
        }

        /**
         * Gets the value of the linenumber property.
         */
        public long getLinenumber() {
            return linenumber;
        }

        /**
         * Sets the value of the linenumber property.
         */
        public void setLinenumber(final long linenumber) {
            this.linenumber = linenumber;
        }

    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element name="Error" maxOccurs="unbounded"&gt;
     *           &lt;complexType&gt;
     *             &lt;complexContent&gt;
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *                 &lt;sequence&gt;
     *                   &lt;element name="ErrorMessage" type="{http://www.w3.org/2001/XMLSchema}anyType" maxOccurs="unbounded"/&gt;
     *                 &lt;/sequence&gt;
     *                 &lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
     *               &lt;/restriction&gt;
     *             &lt;/complexContent&gt;
     *           &lt;/complexType&gt;
     *         &lt;/element&gt;
     *       &lt;/sequence&gt;
     *       &lt;attribute name="ponumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = "errorList")
    public static class PurchaseOrderRef {

        @XmlElement(name = "Error", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE, required = true)
        private List<PurchaseOrderMessage.Error> errorList;
        @XmlAttribute(name = "ponumber", required = true)
        @XmlSchemaType(name = "unsignedInt")
        private long poNumber;

        /**
         * Gets the value of the errorList property.
         *
         * <p>
         * This accessor method returns a reference to the live list, not a snapshot. Therefore, any modification you
         * make to the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
         * {@code set} method for the errorList property.
         *
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getErrorList().add(newItem);
         * </pre>
         *
         *
         * <p>
         * Objects of the following type(s) are allowed in the list {@link PurchaseOrderMessage.Error }
         */
        public List<PurchaseOrderMessage.Error> getErrorList() {
            if (errorList == null) {
                errorList = new ArrayList<>();
            }
            return errorList;
        }

        /**
         * Gets the value of the ponumber property.
         */
        public long getPONumber() {
            return poNumber;
        }

        /**
         * Sets the value of the ponumber property.
         */
        public void setPONumber(final long poNumber) {
            this.poNumber = poNumber;
        }

    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPOResponse}Error" maxOccurs="unbounded"/&gt;
     *       &lt;/sequence&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = "errorList")
    public static class Errors {

        @XmlElement(name = "Error", namespace = XmlConstants.B2B_PO_RESPONSE_NAMESPACE, required = true)
        private List<Error> errorList;

        /**
         * Gets the value of the errorList property.
         *
         * <p>
         * This accessor method returns a reference to the live list, not a snapshot. Therefore, any modification you
         * make to the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
         * {@code set} method for the errorList property.
         *
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getErrorList().add(newItem);
         * </pre>
         *
         *
         * <p>
         * Objects of the following type(s) are allowed in the list {@link Error }
         */
        public List<Error> getErrorList() {
            if (errorList == null) {
                errorList = new ArrayList<>();
            }
            return errorList;
        }

    }
}
