/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.batch.service.impl;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.purap.batch.service.PurapRunDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class PurapRunDateServiceImpl
implements PurapRunDateService {
    private static final Logger LOG = LogManager.getLogger();
    protected ParameterService parameterService;
    private DateTimeService dateTimeService;

    @Override
    public Date calculateRunDate(Date executionDate) {
        CutoffTime cutoffTime;
        LocalDateTime currentDate = this.dateTimeService.getLocalDateTime(executionDate);
        if (this.isCurrentDateAfterCutoff(currentDate, cutoffTime = this.parseCutoffTime(this.retrieveCutoffTimeValue()))) {
            return this.dateTimeService.getUtilDate(currentDate.plusDays(1L).truncatedTo(ChronoUnit.DAYS));
        }
        return this.dateTimeService.getUtilDate(currentDate.truncatedTo(ChronoUnit.DAYS));
    }

    protected boolean isCurrentDateAfterCutoff(LocalDateTime localDateTime, CutoffTime cutoffTime) {
        if (cutoffTime != null) {
            LocalDateTime cutoffDateTime = localDateTime.withHour(cutoffTime.hour).withMinute(cutoffTime.minute).withSecond(cutoffTime.second).withNano(0);
            return localDateTime.isAfter(cutoffDateTime);
        }
        return false;
    }

    protected CutoffTime parseCutoffTime(String cutoffTime) {
        if (StringUtils.isBlank((CharSequence)cutoffTime)) {
            return null;
        }
        cutoffTime = cutoffTime.trim();
        LOG.debug("Cutoff time value found: {}", (Object)cutoffTime);
        StringTokenizer st = new StringTokenizer(cutoffTime, ":", false);
        try {
            String hourStr = st.nextToken();
            String minuteStr = st.nextToken();
            String secondStr = st.nextToken();
            int hourInt = Integer.parseInt(hourStr, 10);
            int minuteInt = Integer.parseInt(minuteStr, 10);
            int secondInt = Integer.parseInt(secondStr, 10);
            if (hourInt < 0 || hourInt > 23 || minuteInt < 0 || minuteInt > 59 || secondInt < 0 || secondInt > 59) {
                throw new IllegalArgumentException("Cutoff time must be in the format \"HH:mm:ss\", where HH, mm, ss are defined in the java.text.SimpleDateFormat class.  In particular, 0 <= hour <= 23, 0 <= minute <= 59, and 0 <= second <= 59");
            }
            return new CutoffTime(hourInt, minuteInt, secondInt);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cutoff time should either be null, or in the format \"HH:mm:ss\", where HH, mm, ss are defined in the java.text.SimpleDateFormat class.");
        }
    }

    protected String retrieveCutoffTimeValue() {
        String value = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_BATCH.class, "CUTOFF_TIME");
        if (StringUtils.isBlank((CharSequence)value)) {
            LOG.info("Unable to retrieve parameter for PURAP process cutoff date.  Defaulting to no cutoff time (i.e. midnight)");
            value = null;
        }
        return value;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    protected class CutoffTime {
        protected int hour;
        protected int minute;
        protected int second;

        protected CutoffTime(int hour, int minute, int second) {
            this.hour = hour;
            this.minute = minute;
            this.second = second;
        }
    }
}

