/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.purap.PurchasingAccountsPayableModuleService;
import org.kuali.kfs.kim.api.services.KimApiServiceLocator;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestView;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.util.PurApRelatedViews;

public class PurchasingAccountsPayableModuleServiceImpl
implements PurchasingAccountsPayableModuleService {
    private static final Logger LOG = LogManager.getLogger();
    protected BusinessObjectService businessObjectService;
    protected DocumentService documentService;
    protected PaymentRequestService paymentRequestService;
    protected PurapService purapService;
    protected PurchaseOrderService purchaseOrderService;
    protected RequisitionService requisitionService;
    private ParameterService parameterService;
    private CreditMemoService creditMemoService;
    private NoteService noteService;
    private AccountsPayableService accountsPayableService;

    public void addAssignedAssetNumbers(Integer purchaseOrderNumber, String principalId, String noteText) {
        PurchaseOrderDocument document = this.purchaseOrderService.getCurrentPurchaseOrder(purchaseOrderNumber);
        try {
            Note assetNote = this.documentService.createNoteFromDocument((Document)document, noteText);
            assetNote.setAuthorUniversalIdentifier(principalId);
            document.addNote(assetNote);
            this.noteService.save(assetNote);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getPurchaseOrderInquiryUrl(Integer purchaseOrderNumber) {
        PurchaseOrderDocument po = this.purchaseOrderService.getCurrentPurchaseOrder(purchaseOrderNumber);
        if (ObjectUtils.isNotNull((Object)po)) {
            return "purapPurchaseOrder.do?methodToCall=docHandler&docId=" + po.getDocumentNumber() + "&command=displayDocSearchView";
        }
        return "";
    }

    public boolean isPurchasingBatchDocument(String documentTypeCode) {
        return "PREQ".equals(documentTypeCode) || "CM".equals(documentTypeCode);
    }

    public void handlePurchasingBatchCancels(String documentNumber, String documentTypeCode, boolean primaryCancel, boolean disbursedPayment) {
        LOG.info("Begin handlePurchasingBatchCancels(documentNumber={}, documentTypeCode={}, primaryCancel={}, disbursedPayment={}", (Object)documentNumber, (Object)documentTypeCode, (Object)primaryCancel, (Object)disbursedPayment);
        String preqCancelNote = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "CANCEL_NOTE");
        String preqResetNote = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "RESET_NOTE");
        String cmCancelNote = this.parameterService.getParameterValueAsString(VendorCreditMemoDocument.class, "CANCEL_NOTE");
        String cmResetNote = this.parameterService.getParameterValueAsString(VendorCreditMemoDocument.class, "RESET_NOTE");
        if ("PREQ".equals(documentTypeCode)) {
            PaymentRequestDocument pr = this.paymentRequestService.getPaymentRequestByDocumentNumber(documentNumber);
            if (pr != null) {
                if (disbursedPayment || primaryCancel) {
                    this.paymentRequestService.cancelExtractedPaymentRequest(pr, preqCancelNote);
                } else {
                    this.paymentRequestService.resetExtractedPaymentRequest(pr, preqResetNote);
                }
            } else {
                LOG.error("processPdpCancels() DOES NOT EXIST, CANNOT PROCESS - Payment Request with doc type of {} with id {}", (Object)documentTypeCode, (Object)documentNumber);
            }
        } else if ("CM".equals(documentTypeCode)) {
            VendorCreditMemoDocument cm = this.creditMemoService.getCreditMemoByDocumentNumber(documentNumber);
            if (cm != null) {
                if (disbursedPayment || primaryCancel) {
                    this.creditMemoService.cancelExtractedCreditMemo(cm, cmCancelNote);
                } else {
                    this.creditMemoService.resetExtractedCreditMemo(cm, cmResetNote);
                }
            } else {
                LOG.error("processPdpCancels() DOES NOT EXIST, CANNOT PROCESS - Credit Memo with doc type of {} with id {}", (Object)documentTypeCode, (Object)documentNumber);
            }
        }
    }

    public void handlePurchasingBatchPaids(String documentNumber, String documentTypeCode, Date processDate) {
        if ("PREQ".equals(documentTypeCode)) {
            PaymentRequestDocument pr = this.paymentRequestService.getPaymentRequestByDocumentNumber(documentNumber);
            if (pr != null) {
                this.paymentRequestService.markPaid(pr, processDate);
            } else {
                LOG.error("processPdpPaids() DOES NOT EXIST, CANNOT MARK - Payment Request with doc type of {} with id {}", (Object)documentTypeCode, (Object)documentNumber);
            }
        } else if ("CM".equals(documentTypeCode)) {
            VendorCreditMemoDocument cm = this.creditMemoService.getCreditMemoByDocumentNumber(documentNumber);
            if (cm != null) {
                this.creditMemoService.markPaid(cm, processDate);
            } else {
                LOG.error("processPdpPaids() DOES NOT EXIST, CANNOT PROCESS - Credit Memo with doc type of {} with id {}", (Object)documentTypeCode, (Object)documentNumber);
            }
        }
    }

    public void handlePurchasingBatchReissue(String documentNumber, String documentTypeCode) {
        VendorCreditMemoDocument accountsPayableDocument;
        if ("PREQ".equals(documentTypeCode)) {
            PaymentRequestDocument accountsPayableDocument2 = this.paymentRequestService.getPaymentRequestByDocumentNumber(documentNumber);
            if (ObjectUtils.isNotNull((Object)accountsPayableDocument2) && "Cancelled".equals(accountsPayableDocument2.getApplicationDocumentStatus())) {
                String preqReissueNote = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "REISSUE_NOTE");
                this.createNoteAndRevertToPreviousAppDocStatus(documentNumber, documentTypeCode, preqReissueNote, accountsPayableDocument2);
            }
        } else if ("CM".equals(documentTypeCode) && ObjectUtils.isNotNull((Object)(accountsPayableDocument = this.creditMemoService.getCreditMemoByDocumentNumber(documentNumber))) && "Cancelled".equals(accountsPayableDocument.getApplicationDocumentStatus())) {
            String cmReissueNote = this.parameterService.getParameterValueAsString(VendorCreditMemoDocument.class, "REISSUE_NOTE");
            this.createNoteAndRevertToPreviousAppDocStatus(documentNumber, documentTypeCode, cmReissueNote, accountsPayableDocument);
        }
    }

    private void createNoteAndRevertToPreviousAppDocStatus(String documentNumber, String documentTypeCode, String preqReissueNote, AccountsPayableDocument accountsPayableDocument) {
        if (ObjectUtils.isNotNull((Object)accountsPayableDocument)) {
            Note cancelNote = this.documentService.createNoteFromDocument((Document)accountsPayableDocument, preqReissueNote);
            cancelNote.setAuthorUniversalIdentifier(this.getSystemUserPrincipalId());
            accountsPayableDocument.addNote(cancelNote);
            this.noteService.save(cancelNote);
            this.accountsPayableService.revertToPreviousAppDocStatus(accountsPayableDocument);
        } else {
            LOG.error("DOCUMENT DOES NOT EXIST, CANNOT PROCESS - doc type of {} with id {}", (Object)documentTypeCode, (Object)documentNumber);
        }
    }

    String getSystemUserPrincipalId() {
        return KimApiServiceLocator.getPersonService().getPersonByPrincipalName("kfs").getPrincipalId();
    }

    public String determineRelatedRequisitionInitiatorPrincipalId(Document document) {
        if (document instanceof PurchasingAccountsPayableDocumentBase) {
            Integer requisitionIdentifier = null;
            if (document instanceof AccountsPayableDocument) {
                PurchaseOrderDocument purchaseOrder = ((AccountsPayableDocument)document).getPurchaseOrderDocument();
                if (ObjectUtils.isNotNull((Object)purchaseOrder)) {
                    requisitionIdentifier = purchaseOrder.getRequisitionIdentifier();
                }
            } else if (document instanceof PurchaseOrderDocument) {
                requisitionIdentifier = ((PurchaseOrderDocument)document).getRequisitionIdentifier();
            }
            if (ObjectUtils.isNotNull(requisitionIdentifier)) {
                RequisitionDocument requisitionDocument = this.requisitionService.getRequisitionById(requisitionIdentifier);
                return requisitionDocument.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
            }
        }
        return null;
    }

    public KualiDecimal getTotalPaidAmountToRequisitions(List<String> documentNumbers) {
        KualiDecimal totalPaidAmountToRequests = KualiDecimal.ZERO;
        HashMap<String, List<String>> fieldValues = new HashMap<String, List<String>>();
        fieldValues.put("documentNumber", documentNumbers);
        Collection reqses = this.businessObjectService.findMatching(RequisitionDocument.class, fieldValues);
        for (RequisitionDocument reqs : reqses) {
            PurApRelatedViews relatedviews = reqs.getRelatedViews();
            if (relatedviews == null || relatedviews.getRelatedPaymentRequestViews() == null || relatedviews.getRelatedPaymentRequestViews().size() <= 0) continue;
            List<PaymentRequestView> preqViews = relatedviews.getRelatedPaymentRequestViews();
            for (PaymentRequestView preqView : preqViews) {
                PaymentRequestDocument preqDocument = (PaymentRequestDocument)this.documentService.getByDocumentHeaderId(preqView.getDocumentNumber());
                if (!preqDocument.getDocumentHeader().getWorkflowDocument().isFinal()) continue;
                totalPaidAmountToRequests = (KualiDecimal)totalPaidAmountToRequests.add((AbstractKualiDecimal)preqDocument.getVendorInvoiceAmount());
            }
        }
        return totalPaidAmountToRequests;
    }

    public HashMap<String, String> checkForDuplicatePaymentRequests(Integer vendorHeaderGeneratedId, Integer vendorDetailAssignedId, String invoiceNumber, KualiDecimal invoiceAmount, Date invoiceDate, String vendorToken, String specifiedSourceToken, boolean questionFormat) {
        return this.paymentRequestService.checkForDuplicatePaymentRequests(vendorHeaderGeneratedId, vendorDetailAssignedId, invoiceNumber, invoiceAmount, invoiceDate, vendorToken, specifiedSourceToken, questionFormat);
    }

    public boolean isDocumentPaid(String documentNumber, String financialSystemDocumentTypeCode) {
        VendorCreditMemoDocument cm;
        if ("PREQ".equals(financialSystemDocumentTypeCode)) {
            PaymentRequestDocument pr = this.paymentRequestService.getPaymentRequestByDocumentNumber(documentNumber);
            if (pr != null) {
                return pr.getPaymentPaidTimestamp() != null;
            }
        } else if ("CM".equals(financialSystemDocumentTypeCode) && (cm = this.creditMemoService.getCreditMemoByDocumentNumber(documentNumber)) != null) {
            return cm.getCreditMemoPaidTimestamp() != null;
        }
        return false;
    }

    public String getCurrentPurchaseOrderDocumentNumber(String poIdentifier) {
        PurchaseOrderDocument po;
        String currentPoDocNumber = null;
        if (StringUtils.isNumeric((CharSequence)poIdentifier) && ObjectUtils.isNotNull((Object)(po = this.purchaseOrderService.getCurrentPurchaseOrder(Integer.parseInt(poIdentifier))))) {
            currentPoDocNumber = po.getDocumentNumber();
        }
        return currentPoDocNumber;
    }

    public String getB2BUrlString() {
        return "&channelUrl=b2b.do?methodToCall=shopCatalogs";
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setPaymentRequestService(PaymentRequestService paymentRequestService) {
        this.paymentRequestService = paymentRequestService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public void setRequisitionService(RequisitionService requisitionService) {
        this.requisitionService = requisitionService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected CreditMemoService getCreditMemoService() {
        return this.creditMemoService;
    }

    public void setCreditMemoService(CreditMemoService creditMemoService) {
        this.creditMemoService = creditMemoService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setAccountsPayableService(AccountsPayableService accountsPayableService) {
        this.accountsPayableService = accountsPayableService;
    }
}

