/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.sys.context.SpringContext;

public class PurapPdf
extends PdfPageEventHelper {
    private static final Logger LOG = LogManager.getLogger();
    public PdfTemplate tpl;
    public PdfContentByte cb;
    public Image logo;
    public PdfPTable headerTable;
    public PdfPTable nestedHeaderTable;
    public String campusName;
    public PurchaseOrderDocument po;
    public String logoImage;
    public BaseFont helv;
    public String environment;
    public boolean isPreview;
    public boolean isRetransmit;
    Font ver_4_normal = FontFactory.getFont((String)"VERDANA", (float)4.0f, (int)0);
    Font ver_5_normal = FontFactory.getFont((String)"VERDANA", (float)5.0f, (int)0);
    Font ver_6_normal = FontFactory.getFont((String)"VERDANA", (float)6.0f, (int)0);
    Font ver_8_normal = FontFactory.getFont((String)"VERDANA", (float)8.0f, (int)0);
    Font ver_10_normal = FontFactory.getFont((String)"VERDANA", (float)10.0f, (int)0);
    Font ver_11_normal = FontFactory.getFont((String)"VERDANA", (float)11.0f, (int)0);
    Font ver_12_normal = FontFactory.getFont((String)"VERDANA", (float)12.0f, (int)0);
    Font ver_13_normal = FontFactory.getFont((String)"VERDANA", (float)13.0f, (int)0);
    Font ver_14_normal = FontFactory.getFont((String)"VERDANA", (float)14.0f, (int)0);
    Font ver_15_normal = FontFactory.getFont((String)"VERDANA", (float)15.0f, (int)0);
    Font ver_16_normal = FontFactory.getFont((String)"VERDANA", (float)16.0f, (int)0);
    Font ver_17_normal = FontFactory.getFont((String)"VERDANA", (float)17.0f, (int)0);
    Font ver_6_bold = FontFactory.getFont((String)"VERDANA", (float)6.0f, (int)1);
    Font ver_8_bold = FontFactory.getFont((String)"VERDANA", (float)8.0f, (int)1);
    Font ver_10_bold = FontFactory.getFont((String)"VERDANA", (float)10.0f, (int)1);
    Font cour_7_normal = FontFactory.getFont((String)"COURIER", (float)7.0f, (int)0);
    Font cour_10_normal = FontFactory.getFont((String)"COURIER", (float)10.0f, (int)0);
    Font cour_16_bold = FontFactory.getFont((String)"COURIER", (float)16.0f, (int)1);
    static KualiDecimal zero = KualiDecimal.ZERO;
    private DateTimeService dateTimeService;

    public DateTimeService getDateTimeService() {
        if (ObjectUtils.isNull((Object)this.dateTimeService)) {
            this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void onStartPage(PdfWriter writer, Document document) {
        Object watermarkText;
        PdfContentByte cb;
        if (!KRADUtils.isProductionEnvironment()) {
            cb = writer.getDirectContentUnder();
            cb.saveState();
            cb.beginText();
            cb.setFontAndSize(this.helv, 48.0f);
            watermarkText = "Test document (" + this.environment + ")";
            cb.showTextAligned(1, (String)watermarkText, document.getPageSize().getWidth() / 2.0f, document.getPageSize().getHeight() / 2.0f, 45.0f);
            cb.endText();
            cb.restoreState();
        }
        if (GlobalVariables.getUserSession() != null && GlobalVariables.getUserSession().retrieveObject("isPreview") != null) {
            GlobalVariables.getUserSession().removeObject("isPreview");
            cb = writer.getDirectContentUnder();
            cb.saveState();
            cb.beginText();
            cb.setFontAndSize(this.helv, 48.0f);
            watermarkText = "DRAFT";
            cb.showTextAligned(1, "DRAFT", document.getPageSize().getWidth() / 2.0f, document.getPageSize().getHeight() / 2.0f, 45.0f);
            cb.endText();
            cb.restoreState();
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        LOG.debug("onEndPage() started.");
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        this.headerTable.setTotalWidth(document.right() - document.left());
        this.headerTable.writeSelectedRows(0, -1, document.left(), document.getPageSize().getHeight() - 10.0f, cb);
        String text = "Page " + writer.getPageNumber() + " of ";
        float textSize = this.helv.getWidthPoint(text, 12.0f);
        float textBase = document.bottom() - 20.0f;
        cb.beginText();
        cb.setFontAndSize(this.helv, 12.0f);
        float adjust = this.helv.getWidthPoint("0", 12.0f);
        cb.setTextMatrix(document.right() - textSize - adjust, textBase);
        cb.showText(text);
        cb.endText();
        cb.addTemplate(this.tpl, document.right() - adjust, textBase);
        cb.restoreState();
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        LOG.debug("onCloseDocument() started.");
        this.tpl.beginText();
        this.tpl.setFontAndSize(this.helv, 12.0f);
        this.tpl.setTextMatrix(0.0f, 0.0f);
        this.tpl.showText("" + (writer.getPageNumber() - 1));
        this.tpl.endText();
    }

    public PurapPdf getPageEvents() {
        LOG.debug("getPageEvents() started.");
        return new PurapPdf();
    }

    public Document getDocument(float f1, float f2, float f3, float f4) {
        LOG.debug("getDocument() started");
        Document document = new Document(PageSize.A4);
        document.setMargins(f1, f2, f3, f4);
        return document;
    }

    public void deletePdf(String pdfFileLocation, String pdfFilename) {
        LOG.debug("deletePdf() started for po pdf file: {}", (Object)pdfFilename);
        File f = new File(pdfFileLocation + pdfFilename);
        f.delete();
    }
}

