/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableItemBase;
import org.kuali.kfs.module.purap.businessobject.CreditMemoAccountRevision;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.kfs.module.purap.service.PurapAccountRevisionService;
import org.kuali.kfs.module.purap.service.impl.PurapAccountRevisionGroup;

public class PurapAccountRevisionServiceImpl
implements PurapAccountRevisionService {
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;

    @Override
    public void savePaymentRequestAccountRevisions(List<PaymentRequestItem> paymentRequestItems, Integer postingYear, String postingPeriodCode) {
        ArrayList<PaymentRequestAccountRevision> accountHistories = new ArrayList<PaymentRequestAccountRevision>();
        for (PaymentRequestItem item : paymentRequestItems) {
            Map<PurapAccountRevisionGroup, PurapAccountRevisionGroup> currentAcctLineGroups = this.buildAccountLineGroups(item, postingYear, postingPeriodCode);
            Map<PurapAccountRevisionGroup, PurapAccountRevisionGroup> historyAcctLineGroups = this.buildAccountHistoryGroups(item, postingYear, postingPeriodCode, PaymentRequestAccountRevision.class);
            HashSet<PurapAccountRevisionGroup> existList = new HashSet<PurapAccountRevisionGroup>();
            for (PurapAccountRevisionGroup histGroup : historyAcctLineGroups.keySet()) {
                PurapAccountRevisionGroup currGroup = currentAcctLineGroups.get(histGroup);
                if (currGroup != null) {
                    histGroup.setChangeAmount((KualiDecimal)currGroup.getAmount().subtract((AbstractKualiDecimal)histGroup.getAmount()));
                } else {
                    histGroup.setChangeAmount((KualiDecimal)histGroup.getAmount().negated());
                }
                PaymentRequestAccountRevision history = (PaymentRequestAccountRevision)histGroup.buildRevisionRecord(PaymentRequestAccountRevision.class);
                history.setAccountRevisionTimestamp(this.dateTimeService.getCurrentTimestamp());
                accountHistories.add(history);
                existList.add(histGroup);
            }
            for (PurapAccountRevisionGroup group : currentAcctLineGroups.keySet()) {
                if (existList.contains(group)) continue;
                group.setChangeAmount(group.getAmount());
                PaymentRequestAccountRevision history = (PaymentRequestAccountRevision)group.buildRevisionRecord(PaymentRequestAccountRevision.class);
                history.setAccountRevisionTimestamp(this.dateTimeService.getCurrentTimestamp());
                accountHistories.add(history);
            }
        }
        this.businessObjectService.save(accountHistories);
    }

    @Override
    public void cancelPaymentRequestAccountRevisions(List<PaymentRequestItem> paymentRequestItems, Integer postingYear, String postingPeriodCode) {
        ArrayList<PaymentRequestAccountRevision> accountHistories = new ArrayList<PaymentRequestAccountRevision>();
        for (PaymentRequestItem item : paymentRequestItems) {
            Map<PurapAccountRevisionGroup, PurapAccountRevisionGroup> historyAcctLineGroups = this.buildAccountHistoryGroups(item, postingYear, postingPeriodCode, PaymentRequestAccountRevision.class);
            for (PurapAccountRevisionGroup histGroup : historyAcctLineGroups.keySet()) {
                histGroup.setChangeAmount((KualiDecimal)histGroup.getAmount().negated());
                PaymentRequestAccountRevision history = (PaymentRequestAccountRevision)histGroup.buildRevisionRecord(PaymentRequestAccountRevision.class);
                history.setAccountRevisionTimestamp(this.dateTimeService.getCurrentTimestamp());
                accountHistories.add(history);
            }
        }
        this.businessObjectService.save(accountHistories);
    }

    @Override
    public void saveCreditMemoAccountRevisions(List<CreditMemoItem> creditMemoItems, Integer postingYear, String postingPeriodCode) {
        ArrayList<CreditMemoAccountRevision> accountHistories = new ArrayList<CreditMemoAccountRevision>();
        for (CreditMemoItem item : creditMemoItems) {
            Map<PurapAccountRevisionGroup, PurapAccountRevisionGroup> currentAcctLineGroups = this.buildAccountLineGroups(item, postingYear, postingPeriodCode);
            Map<PurapAccountRevisionGroup, PurapAccountRevisionGroup> historyAcctLineGroups = this.buildAccountHistoryGroups(item, postingYear, postingPeriodCode, CreditMemoAccountRevision.class);
            HashSet<PurapAccountRevisionGroup> existList = new HashSet<PurapAccountRevisionGroup>();
            for (PurapAccountRevisionGroup histGroup : historyAcctLineGroups.keySet()) {
                PurapAccountRevisionGroup currGroup = currentAcctLineGroups.get(histGroup);
                if (currGroup != null) {
                    histGroup.setChangeAmount((KualiDecimal)currGroup.getAmount().subtract((AbstractKualiDecimal)histGroup.getAmount()));
                } else {
                    histGroup.setChangeAmount((KualiDecimal)histGroup.getAmount().negated());
                }
                CreditMemoAccountRevision history = (CreditMemoAccountRevision)histGroup.buildRevisionRecord(CreditMemoAccountRevision.class);
                history.setAccountRevisionTimestamp(this.dateTimeService.getCurrentTimestamp());
                accountHistories.add(history);
                existList.add(histGroup);
            }
            for (PurapAccountRevisionGroup group : currentAcctLineGroups.keySet()) {
                if (existList.contains(group)) continue;
                group.setChangeAmount(group.getAmount());
                CreditMemoAccountRevision history = (CreditMemoAccountRevision)group.buildRevisionRecord(CreditMemoAccountRevision.class);
                history.setAccountRevisionTimestamp(this.dateTimeService.getCurrentTimestamp());
                accountHistories.add(history);
            }
        }
        this.businessObjectService.save(accountHistories);
    }

    @Override
    public void cancelCreditMemoAccountRevisions(List<CreditMemoItem> creditMemoItems, Integer postingYear, String postingPeriodCode) {
        ArrayList<CreditMemoAccountRevision> accountHistories = new ArrayList<CreditMemoAccountRevision>();
        for (CreditMemoItem item : creditMemoItems) {
            Map<PurapAccountRevisionGroup, PurapAccountRevisionGroup> historyAcctLineGroups = this.buildAccountHistoryGroups(item, postingYear, postingPeriodCode, CreditMemoAccountRevision.class);
            for (PurapAccountRevisionGroup histGroup : historyAcctLineGroups.keySet()) {
                histGroup.setChangeAmount((KualiDecimal)histGroup.getAmount().negated());
                CreditMemoAccountRevision history = (CreditMemoAccountRevision)histGroup.buildRevisionRecord(CreditMemoAccountRevision.class);
                history.setAccountRevisionTimestamp(this.dateTimeService.getCurrentTimestamp());
                accountHistories.add(history);
            }
        }
        this.businessObjectService.save(accountHistories);
    }

    protected Map<PurapAccountRevisionGroup, PurapAccountRevisionGroup> buildAccountLineGroups(AccountsPayableItemBase item, Integer postingYear, String postingPeriodCode) {
        HashMap<PurapAccountRevisionGroup, PurapAccountRevisionGroup> accountLineGroups = new HashMap<PurapAccountRevisionGroup, PurapAccountRevisionGroup>();
        for (PurApAccountingLine account : item.getSourceAccountingLines()) {
            PurapAccountRevisionGroup lineGroup = new PurapAccountRevisionGroup((PurApAccountingLineBase)account);
            lineGroup.setPostingYear(postingYear);
            lineGroup.setPostingPeriodCode(postingPeriodCode);
            if (accountLineGroups.get(lineGroup) == null) {
                accountLineGroups.put(lineGroup, lineGroup);
                continue;
            }
            ((PurapAccountRevisionGroup)accountLineGroups.get(lineGroup)).combineEntry((PurApAccountingLineBase)account);
        }
        return accountLineGroups;
    }

    protected Map<PurapAccountRevisionGroup, PurapAccountRevisionGroup> buildAccountHistoryGroups(AccountsPayableItemBase item, Integer postingYear, String postingPeriodCode, Class<? extends PurApAccountingLineBase> clazz) {
        HashMap<PurapAccountRevisionGroup, PurapAccountRevisionGroup> historyGroups = new HashMap<PurapAccountRevisionGroup, PurapAccountRevisionGroup>();
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put("itemIdentifier", item.getItemIdentifier());
        Collection existingAccounts = this.businessObjectService.findMatching(clazz, fieldValues);
        if (existingAccounts != null && !existingAccounts.isEmpty()) {
            for (PurApAccountingLineBase existAcct : existingAccounts) {
                PurapAccountRevisionGroup historyGroup = new PurapAccountRevisionGroup(existAcct);
                historyGroup.setPostingYear(postingYear);
                historyGroup.setPostingPeriodCode(postingPeriodCode);
                if (historyGroups.get(historyGroup) == null) {
                    historyGroups.put(historyGroup, historyGroup);
                    continue;
                }
                ((PurapAccountRevisionGroup)historyGroups.get(historyGroup)).combineEntry(existAcct);
            }
        }
        return historyGroups;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

