/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.batch;

import java.io.InputStream;
import java.util.Objects;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceInputFileType;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoice;
import org.kuali.kfs.module.purap.businessobject.jaxb.Header;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailHeaderIndicator;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailLineIndicator;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailRequestHeader;
import org.kuali.kfs.module.purap.businessobject.jaxb.Request;
import org.kuali.kfs.module.purap.businessobject.jaxb.Sender;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.core.io.ClassPathResource;

@ExtendWith(value={MockitoExtension.class})
class ElectronicInvoiceInputFileTypeTest {
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    private static final String ELECTRONIC_INVOICE_XSD = "classpath:org/kuali/kfs/module/purap/batch/electronicInvoice.xsd";
    private static final String ELECTRONIC_XML_FILE_PATH = "org/kuali/kfs/module/purap/fixture/electronicInvoiceSample.xml";
    private ElectronicInvoiceInputFileType cut;

    ElectronicInvoiceInputFileTypeTest() {
    }

    private static ElectronicInvoice getExpectedElectronicInvoice() {
        ElectronicInvoice expectedInvoice = new ElectronicInvoice();
        Header header = new Header();
        header.setFrom("DUNS", "121212");
        header.setTo("NetworkId", "IUHIGHERM");
        header.setSender(new Sender("DUNS", "121212", "fisherscipass", "IUPUI"));
        expectedInvoice.setHeader(header);
        Request request = new Request();
        request.setDeploymentMode("production");
        InvoiceDetailRequestHeader expectedInvoiceDetailRequestHeader = new InvoiceDetailRequestHeader();
        expectedInvoiceDetailRequestHeader.setInvoiceDate("2008-07-25T00:00:00-08:00");
        expectedInvoiceDetailRequestHeader.setInvoiceID("133");
        expectedInvoiceDetailRequestHeader.setOperation("new");
        expectedInvoiceDetailRequestHeader.setPurpose("standard");
        expectedInvoiceDetailRequestHeader.setIsInformationOnly("yes");
        expectedInvoiceDetailRequestHeader.setInvoiceDetailHeaderIndicator(new InvoiceDetailHeaderIndicator("yes"));
        expectedInvoiceDetailRequestHeader.setInvoiceDetailLineIndicator(new InvoiceDetailLineIndicator("yes", "yes", "yes", "yes"));
        return expectedInvoice;
    }

    @Test
    void parse_ShouldUnmarshallToIdenticalInvoice() throws Exception {
        try (MockedStatic globalResourceLoaderMockedStatic = Mockito.mockStatic(GlobalResourceLoader.class);
             InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(ELECTRONIC_XML_FILE_PATH);){
            ClassPathResource resource = new ClassPathResource(ELECTRONIC_INVOICE_XSD.substring(CLASSPATH_URL_PREFIX.length()), this.getClass().getClassLoader());
            globalResourceLoaderMockedStatic.when(() -> GlobalResourceLoader.getResource((String)ELECTRONIC_INVOICE_XSD)).thenReturn((Object)resource);
            byte[] xmlBytes = Objects.requireNonNull(inputStream).readAllBytes();
            ElectronicInvoice expectedInvoice = ElectronicInvoiceInputFileTypeTest.getExpectedElectronicInvoice();
            ElectronicInvoice invoice = (ElectronicInvoice)this.cut.parse(xmlBytes);
            Assertions.assertNotNull((Object)invoice);
            Header expectedHeader = expectedInvoice.getHeader();
            Header actualHeader = invoice.getHeader();
            Assertions.assertEquals((Object)expectedHeader.getFromDomain(), (Object)actualHeader.getFromDomain());
            Assertions.assertEquals((Object)expectedHeader.getToDomain(), (Object)actualHeader.getToDomain());
            Assertions.assertEquals((Object)expectedHeader.getSenderDomain(), (Object)actualHeader.getSenderDomain());
            Assertions.assertEquals((Object)expectedHeader.getFromIdentity(), (Object)actualHeader.getFromIdentity());
            Assertions.assertEquals((Object)expectedHeader.getToIdentity(), (Object)actualHeader.getToIdentity());
            Assertions.assertEquals((Object)expectedHeader.getSenderIdentity(), (Object)actualHeader.getSenderIdentity());
            Assertions.assertEquals((Object)expectedHeader.getSenderUserAgent(), (Object)actualHeader.getSenderUserAgent());
        }
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.clear();
        this.cut = new ElectronicInvoiceInputFileType();
        this.cut.setSchemaLocation(ELECTRONIC_INVOICE_XSD);
        this.cut.setOutputClass(ElectronicInvoice.class);
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.clear();
    }
}

