/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.List;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.document.DocumentStatus;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.ContractManagerAssignmentDetail;
import org.kuali.kfs.module.purap.document.ContractManagerAssignmentDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.fixture.ContractManagerAssignmentDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.parke)
public class ContractManagerAssignmentDocumentIntegTest
extends KualiIntegTestBase {
    public static final Class<ContractManagerAssignmentDocument> DOCUMENT_CLASS = ContractManagerAssignmentDocument.class;
    private static final String ACCOUNT_REVIEW = "Account";
    private ContractManagerAssignmentDocument acmDocument;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.acmDocument = null;
        super.tearDown();
    }

    private int getExpectedPrePeCount() {
        return 0;
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final void testRouteDocument() throws Exception {
        this.acmDocument = this.buildSimpleDocument();
        this.acmDocument.prepareForSave();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractManagerAssignmentDocumentIntegTest.assertFalse((boolean)DocumentStatus.ENROUTE.equals((Object)this.acmDocument.getDocumentHeader().getWorkflowDocument().getStatus()));
        this.routeDocument((Document)this.acmDocument, "saving copy source document", documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)this.acmDocument.getDocumentNumber());
        Document document = documentService.getByDocumentHeaderId(this.acmDocument.getDocumentNumber());
        ContractManagerAssignmentDocumentIntegTest.assertTrue((String)"Document should now be final.", (boolean)document.getDocumentHeader().getWorkflowDocument().isFinal());
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final String testRouteDocument2() throws Exception {
        this.acmDocument = this.buildSimpleDocument2();
        this.acmDocument.prepareForSave();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractManagerAssignmentDocumentIntegTest.assertFalse((boolean)DocumentStatus.ENROUTE.equals((Object)this.acmDocument.getDocumentHeader().getWorkflowDocument().getStatus()));
        this.routeDocument((Document)this.acmDocument, "saving copy source document", documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)this.acmDocument.getDocumentNumber());
        ContractManagerAssignmentDocument document = (ContractManagerAssignmentDocument)documentService.getByDocumentHeaderId(this.acmDocument.getDocumentNumber());
        ContractManagerAssignmentDocumentIntegTest.assertTrue((String)"Document should now be final.", (boolean)document.getDocumentHeader().getWorkflowDocument().isFinal());
        return this.acmDocument.getContractManagerAssignmentDetail(0).getRequisition().getDocumentNumber();
    }

    private void routeDocument(Document document, String annotation, DocumentService documentService) {
        try {
            documentService.routeDocument(document, annotation, null);
        }
        catch (ValidationException e) {
            ContractManagerAssignmentDocumentIntegTest.fail((String)(e.getMessage() + ", " + GlobalVariables.getMessageMap()));
        }
    }

    private ContractManagerAssignmentDocument buildSimpleDocument() throws Exception {
        List<ContractManagerAssignmentDetail> details = ContractManagerAssignmentDocumentFixture.ACM_DOCUMENT_VALID.getContractManagerAssignmentDetails();
        for (ContractManagerAssignmentDetail detail : details) {
            detail.getRequisition().setAccountDistributionMethod("S");
            RequisitionDocument routedReq = this.routeRequisitionUntilAwaitingContractManager(detail.getRequisition());
            detail.setRequisitionIdentifier(routedReq.getPurapDocumentIdentifier());
            detail.refreshNonUpdateableReferences();
        }
        this.acmDocument = ContractManagerAssignmentDocumentFixture.ACM_DOCUMENT_VALID.createContractManagerAssignmentDocument();
        for (ContractManagerAssignmentDetail detail : details) {
            detail.getRequisition().setAccountDistributionMethod("S");
            detail.setContractManagerAssignmentDocument(this.acmDocument);
        }
        this.acmDocument.setContractManagerAssignmentDetailss(details);
        return this.acmDocument;
    }

    private ContractManagerAssignmentDocument buildSimpleDocument2() throws Exception {
        List<ContractManagerAssignmentDetail> details = ContractManagerAssignmentDocumentFixture.ACM_DOCUMENT_VALID_2.getContractManagerAssignmentDetails();
        for (ContractManagerAssignmentDetail detail : details) {
            RequisitionDocument routedReq = this.routeRequisitionUntilAwaitingContractManager2(detail.getRequisition());
            detail.setRequisitionIdentifier(routedReq.getPurapDocumentIdentifier());
            detail.refreshNonUpdateableReferences();
        }
        this.acmDocument = ContractManagerAssignmentDocumentFixture.ACM_DOCUMENT_VALID_2.createContractManagerAssignmentDocument();
        for (ContractManagerAssignmentDetail detail : details) {
            detail.setContractManagerAssignmentDocument(this.acmDocument);
        }
        this.acmDocument.setContractManagerAssignmentDetailss(details);
        return this.acmDocument;
    }

    private RequisitionDocument routeRequisitionUntilAwaitingContractManager(RequisitionDocument requisitionDocument) throws Exception {
        String docId = requisitionDocument.getDocumentNumber();
        AccountingDocumentTestUtils.routeDocument((AccountingDocument)requisitionDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        WorkflowTestUtils.waitForNodeChange((WorkflowDocument)requisitionDocument.getDocumentHeader().getWorkflowDocument(), (String)ACCOUNT_REVIEW);
        this.changeCurrentUser(UserNameFixture.sterner);
        requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        ContractManagerAssignmentDocumentIntegTest.assertTrue((String)"At incorrect node.", (boolean)WorkflowTestUtils.isAtNode((Document)requisitionDocument, (String)ACCOUNT_REVIEW));
        ContractManagerAssignmentDocumentIntegTest.assertTrue((String)"Document should be enroute.", (boolean)requisitionDocument.getDocumentHeader().getWorkflowDocument().isEnroute());
        ContractManagerAssignmentDocumentIntegTest.assertTrue((String)"rorenfro should have an approve request.", (boolean)requisitionDocument.getDocumentHeader().getWorkflowDocument().isApprovalRequested());
        ((DocumentService)SpringContext.getBean(DocumentService.class)).approveDocument((Document)requisitionDocument, "Test approving as rorenfro", null);
        this.changeCurrentUser(UserNameFixture.jgerhart);
        requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        ((DocumentService)SpringContext.getBean(DocumentService.class)).acknowledgeDocument((Document)requisitionDocument, "Acknowledging as jgerhart", null);
        WorkflowTestUtils.waitForDocumentApproval((String)requisitionDocument.getDocumentNumber());
        this.changeCurrentUser(UserNameFixture.khuntley);
        requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        ContractManagerAssignmentDocumentIntegTest.assertTrue((String)"Document should now be final.", (boolean)requisitionDocument.getDocumentHeader().getWorkflowDocument().isFinal());
        this.changeCurrentUser(UserNameFixture.parke);
        return requisitionDocument;
    }

    private RequisitionDocument routeRequisitionUntilAwaitingContractManager2(RequisitionDocument requisitionDocument) throws Exception {
        String docId = requisitionDocument.getDocumentNumber();
        ((DocumentService)SpringContext.getBean(DocumentService.class)).routeDocument((Document)requisitionDocument, "saving copy source document", null);
        WorkflowTestUtils.waitForNodeChange((WorkflowDocument)requisitionDocument.getDocumentHeader().getWorkflowDocument(), (String)ACCOUNT_REVIEW);
        this.changeCurrentUser(UserNameFixture.sterner);
        requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        ContractManagerAssignmentDocumentIntegTest.assertTrue((String)"At incorrect node.", (boolean)WorkflowTestUtils.isAtNode((Document)requisitionDocument, (String)ACCOUNT_REVIEW));
        ContractManagerAssignmentDocumentIntegTest.assertTrue((String)"Document should be enroute.", (boolean)requisitionDocument.getDocumentHeader().getWorkflowDocument().isEnroute());
        ContractManagerAssignmentDocumentIntegTest.assertTrue((String)"sterner should have an approve request.", (boolean)requisitionDocument.getDocumentHeader().getWorkflowDocument().isApprovalRequested());
        ((DocumentService)SpringContext.getBean(DocumentService.class)).approveDocument((Document)requisitionDocument, "Test approving as sterner", null);
        WorkflowTestUtils.waitForDocumentApproval((String)requisitionDocument.getDocumentNumber());
        this.changeCurrentUser(UserNameFixture.khuntley);
        requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        ContractManagerAssignmentDocumentIntegTest.assertTrue((String)"Document should now be Awaiting Contract Manager Assignment.", (boolean)requisitionDocument.getApplicationDocumentStatus().equals("Awaiting Contract Manager Assignment"));
        this.changeCurrentUser(UserNameFixture.parke);
        return requisitionDocument;
    }
}

