/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.ArrayList;
import org.junit.Assert;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kew.api.document.DocumentStatus;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableItem;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.fixture.CreditMemoDocumentFixture;
import org.kuali.kfs.module.purap.fixture.CreditMemoItemFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.appleton)
public class CreditMemoDocumentIntegTest
extends KualiIntegTestBase {
    public static final Class<VendorCreditMemoDocument> DOCUMENT_CLASS = VendorCreditMemoDocument.class;
    private VendorCreditMemoDocument creditMemoDocument;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.creditMemoDocument = null;
        super.tearDown();
    }

    private int getExpectedPrePeCount() {
        return 0;
    }

    public final void testAddItem() throws Exception {
        ArrayList<AccountsPayableItem> items = new ArrayList<AccountsPayableItem>();
        items.add(CreditMemoItemFixture.CM_ITEM_NO_APO.createCreditMemoItem());
        int expectedItemTotal = items.size();
        AccountsPayableDocument document = (AccountsPayableDocument)DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), DOCUMENT_CLASS);
        CreditMemoDocumentIntegTest.assertTrue((String)"no items found", (items.size() > 0 ? 1 : 0) != 0);
        CreditMemoDocumentIntegTest.assertEquals((int)0, (int)document.getItems().size());
        items.forEach(arg_0 -> ((AccountsPayableDocument)document).addItem(arg_0));
        CreditMemoDocumentIntegTest.assertEquals((String)"item count mismatch", (int)expectedItemTotal, (int)document.getItems().size());
    }

    public final void testGetNewDocument() throws Exception {
        AccountingDocumentTestUtils.testGetNewDocument_byDocumentClass(DOCUMENT_CLASS, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public final void testConvertIntoErrorCorrection() throws Exception {
        this.creditMemoDocument = this.buildSimpleDocument();
        AccountingDocumentTestUtils.testConvertIntoErrorCorrection((AccountingDocument)this.creditMemoDocument, (int)this.getExpectedPrePeCount(), (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public final void testSaveDocument() throws Exception {
        this.creditMemoDocument = this.buildSimpleDocument();
        this.creditMemoDocument.setAccountsPayableProcessorIdentifier("khuntley");
        AccountingDocumentTestUtils.testSaveDocument((FinancialSystemTransactionalDocument)this.creditMemoDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public final VendorCreditMemoDocument routeDocument(PaymentRequestDocument preqDocument) throws Exception {
        this.creditMemoDocument = this.buildSimpleDocument();
        this.creditMemoDocument.setPaymentRequestDocument(preqDocument);
        this.creditMemoDocument.setPurchaseOrderIdentifier(preqDocument.getPurchaseOrderIdentifier());
        CreditMemoItem cmItem = (CreditMemoItem)this.creditMemoDocument.getItem(0);
        cmItem.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        cmItem.setItemQuantity(new KualiDecimal(1));
        cmItem.setPreqTotalAmount(new KualiDecimal(1));
        ((CreditMemoService)SpringContext.getBean(CreditMemoService.class)).calculateCreditMemo(this.creditMemoDocument);
        this.creditMemoDocument.prepareForSave();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        Assert.assertNotEquals((Object)DocumentStatus.ENROUTE, (Object)this.creditMemoDocument.getDocumentHeader().getWorkflowDocument().getStatus());
        AccountingDocumentTestUtils.routeDocument((FinancialSystemTransactionalDocument)this.creditMemoDocument, (String)"saving copy source docu ament", null, (DocumentService)documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)this.creditMemoDocument.getDocumentNumber());
        return this.creditMemoDocument;
    }

    public VendorCreditMemoDocument buildSimpleDocument() {
        return CreditMemoDocumentFixture.CM_ONLY_REQUIRED_FIELDS.createCreditMemoDocument();
    }
}

