/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.HashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.authorization.PaymentRequestDocumentPresentationController;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PaymentRequestDocumentPresentationControllerTest {
    private PaymentRequestDocumentPresentationController cut;

    PaymentRequestDocumentPresentationControllerTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PaymentRequestDocumentPresentationController();
    }

    @Test
    void addACHSignupInfoModeWhenPREQInFinalState(@Mock(stubOnly=true) DocumentHeader docHeaderMock, @Mock(stubOnly=true) PaymentRequestDocument preqMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        Mockito.when((Object)workflowDocMock.isFinal()).thenReturn((Object)true);
        Mockito.when((Object)docHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocMock);
        Mockito.when((Object)preqMock.getDocumentHeader()).thenReturn((Object)docHeaderMock);
        HashSet editModes = new HashSet();
        this.cut.addACHSignUpInfoMode((Document)preqMock, editModes);
        Assertions.assertFalse((boolean)editModes.contains("achAccountInfoDisplayed"));
    }

    @Test
    void addACHSignupInfoModeWhenPREQInProcessedState(@Mock(stubOnly=true) DocumentHeader docHeaderMock, @Mock(stubOnly=true) PaymentRequestDocument preqMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        Mockito.when((Object)workflowDocMock.isProcessed()).thenReturn((Object)true);
        Mockito.when((Object)workflowDocMock.isFinal()).thenReturn((Object)false);
        Mockito.when((Object)docHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocMock);
        Mockito.when((Object)preqMock.getDocumentHeader()).thenReturn((Object)docHeaderMock);
        HashSet editModes = new HashSet();
        this.cut.addACHSignUpInfoMode((Document)preqMock, editModes);
        Assertions.assertFalse((boolean)editModes.contains("achAccountInfoDisplayed"));
    }

    @Test
    void addACHSignupInfoModeWhenPREQInDisapprovedState(@Mock(stubOnly=true) DocumentHeader docHeaderMock, @Mock(stubOnly=true) PaymentRequestDocument preqMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        Mockito.when((Object)workflowDocMock.isDisapproved()).thenReturn((Object)true);
        Mockito.when((Object)workflowDocMock.isProcessed()).thenReturn((Object)false);
        Mockito.when((Object)workflowDocMock.isFinal()).thenReturn((Object)false);
        Mockito.when((Object)docHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocMock);
        Mockito.when((Object)preqMock.getDocumentHeader()).thenReturn((Object)docHeaderMock);
        HashSet editModes = new HashSet();
        this.cut.addACHSignUpInfoMode((Document)preqMock, editModes);
        Assertions.assertFalse((boolean)editModes.contains("achAccountInfoDisplayed"));
    }

    @Test
    void addACHSignupInfoModeWhenPREQInEnrouteState(@Mock(stubOnly=true) DocumentHeader docHeaderMock, @Mock(stubOnly=true) PaymentRequestDocument preqMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        Mockito.when((Object)workflowDocMock.isDisapproved()).thenReturn((Object)false);
        Mockito.when((Object)workflowDocMock.isProcessed()).thenReturn((Object)false);
        Mockito.when((Object)workflowDocMock.isFinal()).thenReturn((Object)false);
        Mockito.when((Object)docHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocMock);
        Mockito.when((Object)preqMock.getDocumentHeader()).thenReturn((Object)docHeaderMock);
        HashSet editModes = new HashSet();
        this.cut.addACHSignUpInfoMode((Document)preqMock, editModes);
        Assertions.assertTrue((boolean)editModes.contains("achAccountInfoDisplayed"));
    }
}

