/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.sql.Date;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.core.impl.datetime.DateTimeServiceImpl;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.fp.document.service.DisbursementVoucherValidationService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestView;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.dataaccess.PaymentRequestDao;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.impl.PaymentRequestServiceImpl;
import org.kuali.kfs.module.purap.document.service.impl.PurapServiceImpl;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.businessobject.PaymentMethod;
import org.kuali.kfs.sys.service.BankService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PaymentRequestServiceImplTest {
    private static final String DUPLICATE_DV_TEXT = "Duplicate DV Text";
    private static final KualiDecimal INVOICE_AMOUNT = new KualiDecimal(100.0);
    private static final String INVOICE_NUMBER = "a1*2-3.45";
    private static final int PO_ID = 100;
    private static final Date TODAY = Date.valueOf(LocalDate.now());
    private static final String BANK_CODE = "bank code";
    private PaymentRequestServiceImpl cut;
    @Mock(stubOnly=true)
    private ConfigurationService configurationSvcMock;
    @Mock(stubOnly=true)
    private DisbursementVoucherValidationService disbursementVoucherValidationSvcMock;
    @Mock(stubOnly=true)
    private DocumentService documentSvcMock;
    @Mock(stubOnly=true)
    private ParameterService parameterSvcMock;
    @Mock(stubOnly=true)
    private PaymentRequestDao paymentRequestDaoMock;
    @Mock(stubOnly=true)
    private PurchaseOrderDocument purchaseOrderDocumentMock;
    private Properties purapResources;
    private Properties fpResources;
    private String expectedDuplicateInvoiceDvWarning;
    private String expectedDuplicateInvoiceDvWarningNoQuestion;
    private String expectedDuplicateInvoicePreqWarning;
    private String expectedDuplicateInvoiceDateAmountDvWarning;
    private String expectedDuplicateInvoiceDateAmountDvWarningNoQuestion;
    private String expectedDuplicateInvoiceDateAmountPreqWarning;
    private String expectedDuplicateInvoiceCancelledOrVoidedPreqToken;
    private String expectedDuplicateInvoiceCancelledPreqToken;
    private String expectedDuplicateInvoiceDateAmountVoidedPreqWarning;
    private String expectedDuplicateInvoiceVoided;
    private String expectedDuplicateInvoiceDateAmountCancelledPreqWarning;
    private String expectedDuplicateInvoiceDateAmountCancelledOrVoidedPreqWarning;

    PaymentRequestServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.purapResources = TestDataPreparator.loadPropertiesFromClassPath((String)"org/kuali/kfs/module/purap/purap-resources.properties");
        this.fpResources = TestDataPreparator.loadPropertiesFromClassPath((String)"org/kuali/kfs/fp/fp-resources.properties");
        PurapServiceImpl purapService = new PurapServiceImpl();
        purapService.setDateTimeService((DateTimeService)new DateTimeServiceImpl());
        this.cut = new PaymentRequestServiceImpl();
        this.cut.setConfigurationService(this.configurationSvcMock);
        this.cut.setDisbursementVoucherValidationService(this.disbursementVoucherValidationSvcMock);
        this.cut.setDocumentService(this.documentSvcMock);
        this.cut.setPaymentRequestDao(this.paymentRequestDaoMock);
        this.cut.setParameterService(this.parameterSvcMock);
        this.cut.setPurapService((PurapService)purapService);
    }

    private void setupMockMessages(boolean configFpResources) {
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString(ArgumentMatchers.anyString())).thenAnswer(invocationOnMock -> this.purapResources.getProperty((String)invocationOnMock.getArguments()[0]));
        if (configFpResources) {
            Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("warning.duplicate.invoice.question")).thenReturn((Object)this.fpResources.getProperty("warning.duplicate.invoice.question"));
        }
        this.expectedDuplicateInvoiceDvWarning = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice"), "Payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDvWarningNoQuestion = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice"), "Payee", "");
        this.expectedDuplicateInvoicePreqWarning = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice"), "vendor ID", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDateAmountDvWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount"), "for the specified payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDateAmountDvWarningNoQuestion = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount"), "for the specified payee", "");
        this.expectedDuplicateInvoiceDateAmountPreqWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount"), "on the specified PO", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceCancelledOrVoidedPreqToken = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.cancelledOrVoided"), "vendor ID", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceCancelledPreqToken = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.cancelled"), "vendor ID", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDateAmountVoidedPreqWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.voided"), "on the specified PO", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceVoided = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.voided"), "vendor ID", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDateAmountCancelledPreqWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.cancelled"), "on the specified PO", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDateAmountCancelledOrVoidedPreqWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.cancelledOrVoided"), "on the specified PO", this.fpResources.getProperty("warning.duplicate.invoice.question"));
    }

    private void setupMockDocuments(PaymentRequestDocument paymentRequestDocumentMock) {
        Mockito.when((Object)this.purchaseOrderDocumentMock.getVendorDetailAssignedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getVendorHeaderGeneratedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)paymentRequestDocumentMock.getInvoiceNumber()).thenReturn((Object)"A$1%2-345");
        Mockito.when((Object)paymentRequestDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocumentMock);
        Mockito.when((Object)paymentRequestDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)100);
        Mockito.when((Object)paymentRequestDocumentMock.getVendorInvoiceAmount()).thenReturn((Object)INVOICE_AMOUNT);
        Mockito.when((Object)paymentRequestDocumentMock.getInvoiceDate()).thenReturn((Object)TODAY);
    }

    private void setupMockParameters() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_DISBURSEMENT_VOUCHER_IND")).thenReturn((Object)true);
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_PAYMENT_REQUEST_IND")).thenReturn((Object)true);
    }

    @Test
    void checkForDuplicatePaymentRequests_nullPO_VALID(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock) {
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)0, (int)messages.size());
    }

    @Test
    void checkForDuplicatePaymentRequests_nullPO_oldInvoiceDate_VALID(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock) {
        this.setupMockMessages(false);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        Mockito.when((Object)paymentRequestDocumentMock.getInvoiceDate()).thenReturn((Object)Date.valueOf(LocalDate.now().minusYears(2L)));
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.purapResources.getProperty("message.invoice.date.a.year.or.more.past"), messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequests_hasPO_VALID(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock) {
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        Mockito.when((Object)paymentRequestDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocumentMock);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)0, (int)messages.size());
    }

    @Test
    void checkForDuplicatePaymentRequests_hasPO_oldInvoiceDate_VALID(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock) {
        this.setupMockMessages(false);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        Mockito.when((Object)paymentRequestDocumentMock.getInvoiceDate()).thenReturn((Object)Date.valueOf(LocalDate.now().minusYears(2L)));
        Mockito.when((Object)paymentRequestDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocumentMock);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.purapResources.getProperty("message.invoice.date.a.year.or.more.past"), messages.get("PREQDuplicateInvoice"));
    }

    private PaymentRequestView buildMockPaymentRequestView(PaymentRequestView duplicatePaymentRequestViewMock, PaymentRequestDocument duplicatePaymentRequestDocumentMock, String applicationDocumentStatus, String documentNumber) {
        Mockito.when((Object)duplicatePaymentRequestViewMock.getDocumentNumber()).thenReturn((Object)documentNumber);
        Mockito.when((Object)duplicatePaymentRequestViewMock.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)applicationDocumentStatus);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId(documentNumber)).thenReturn((Object)duplicatePaymentRequestDocumentMock);
        return duplicatePaymentRequestViewMock;
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber(@Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "In Process", "1"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_NO_QUESTION(@Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(false);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "In Process", "1"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDvWarningNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_Cancelled(@Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "Cancelled", "2"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assertions.assertEquals((int)1, (int)messages.size());
        String expectedDuplicateInvoiceCancelled = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.cancelled"), "Payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        Assertions.assertEquals((Object)expectedDuplicateInvoiceCancelled, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_Cancelled_NO_QUESTION(@Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(false);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "Cancelled", "2"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assertions.assertEquals((int)1, (int)messages.size());
        String expectedDuplicateInvoiceCancelledNoQuestion = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.cancelled"), "Payee", "");
        Assertions.assertEquals((Object)expectedDuplicateInvoiceCancelledNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_Voided(@Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "Cancelled In Process", "3"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assertions.assertEquals((int)1, (int)messages.size());
        String expectedDuplicateInvoiceVoidedPayeeToken = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.voided"), "Payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        Assertions.assertEquals((Object)expectedDuplicateInvoiceVoidedPayeeToken, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_Voided_NO_QUESTION(@Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(false);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "Cancelled In Process", "3"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assertions.assertEquals((int)1, (int)messages.size());
        String expectedDuplicateInvoiceVoidedPayeeTokenNoQuestion = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.voided"), "Payee", "");
        Assertions.assertEquals((Object)expectedDuplicateInvoiceVoidedPayeeTokenNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_CancelledOrVoided(@Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestView1Mock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocument1Mock) {
        this.setupMockMessages(true);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "Cancelled", "2"));
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestView1Mock, duplicatePaymentRequestDocument1Mock, "Cancelled In Process", "3"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assertions.assertEquals((int)1, (int)messages.size());
        String expectedDuplicateInvoiceCancelledOrVoided = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.cancelledOrVoided"), "Payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        Assertions.assertEquals((Object)expectedDuplicateInvoiceCancelledOrVoided, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_CancelledOrVoided_NO_QUESTION(@Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestView1Mock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocument1Mock) {
        this.setupMockMessages(false);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "Cancelled", "2"));
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestView1Mock, duplicatePaymentRequestDocument1Mock, "Cancelled In Process", "3"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assertions.assertEquals((int)1, (int)messages.size());
        String expectedDuplicateInvoiceCancelledOrVoidedNoQuestion = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.cancelledOrVoided"), "Payee", "");
        Assertions.assertEquals((Object)expectedDuplicateInvoiceCancelledOrVoidedNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_CancelledVoidedAndNormal(@Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock1, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock2, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock1, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock2) {
        this.setupMockMessages(true);
        Mockito.when((Object)duplicatePaymentRequestViewMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)duplicatePaymentRequestViewMock.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1")).thenReturn((Object)duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)duplicatePaymentRequestViewMock1.getDocumentNumber()).thenReturn((Object)"2");
        Mockito.when((Object)duplicatePaymentRequestViewMock1.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("2")).thenReturn((Object)duplicatePaymentRequestDocumentMock1);
        Mockito.when((Object)duplicatePaymentRequestViewMock2.getDocumentNumber()).thenReturn((Object)"3");
        Mockito.when((Object)duplicatePaymentRequestViewMock2.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("3")).thenReturn((Object)duplicatePaymentRequestDocumentMock2);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(duplicatePaymentRequestViewMock);
        duplicatePaymentRequestViews.add(duplicatePaymentRequestViewMock1);
        duplicatePaymentRequestViews.add(duplicatePaymentRequestViewMock2);
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_CancelledVoidedAndNormal_NO_QUESTION(@Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock1, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock1, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock2, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock2) {
        this.setupMockMessages(false);
        Mockito.when((Object)duplicatePaymentRequestViewMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)duplicatePaymentRequestViewMock.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1")).thenReturn((Object)duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)duplicatePaymentRequestViewMock1.getDocumentNumber()).thenReturn((Object)"2");
        Mockito.when((Object)duplicatePaymentRequestViewMock1.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("2")).thenReturn((Object)duplicatePaymentRequestDocumentMock1);
        Mockito.when((Object)duplicatePaymentRequestViewMock2.getDocumentNumber()).thenReturn((Object)"3");
        Mockito.when((Object)duplicatePaymentRequestViewMock2.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("3")).thenReturn((Object)duplicatePaymentRequestDocumentMock2);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(duplicatePaymentRequestViewMock);
        duplicatePaymentRequestViews.add(duplicatePaymentRequestViewMock1);
        duplicatePaymentRequestViews.add(duplicatePaymentRequestViewMock2);
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDvWarningNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal(@Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_NO_QUESTION(@Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(false);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountDvWarningNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_Cancelled(@Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assertions.assertEquals((int)1, (int)messages.size());
        String expectedDuplicateInvoiceDateAmountCancelledDvWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.cancelled"), "for the specified payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        Assertions.assertEquals((Object)expectedDuplicateInvoiceDateAmountCancelledDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_Cancelled_NO_QUESTION(@Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(false);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assertions.assertEquals((int)1, (int)messages.size());
        String expectedDuplicateInvoiceDateAmountCancelledDvWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.cancelled"), "for the specified payee", "");
        Assertions.assertEquals((Object)expectedDuplicateInvoiceDateAmountCancelledDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_Voided(@Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assertions.assertEquals((int)1, (int)messages.size());
        String expectedDuplicateInvoiceDateAmountVoidedDvWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.voided"), "for the specified payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        Assertions.assertEquals((Object)expectedDuplicateInvoiceDateAmountVoidedDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_Voided_NO_QUESTION(@Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(false);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assertions.assertEquals((int)1, (int)messages.size());
        String expectedDuplicateInvoiceDateAmountVoidedDvWarningNoQuestion = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.voided"), "for the specified payee", "");
        Assertions.assertEquals((Object)expectedDuplicateInvoiceDateAmountVoidedDvWarningNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_CancelledOrVoided(@Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock1) {
        this.setupMockMessages(true);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled");
        Mockito.when((Object)duplicatePaymentRequestDocumentMock1.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock1);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assertions.assertEquals((int)1, (int)messages.size());
        String expectedDuplicateInvoiceDateAmountCancelledOrVoidedDvWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.cancelledOrVoided"), "for the specified payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        Assertions.assertEquals((Object)expectedDuplicateInvoiceDateAmountCancelledOrVoidedDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_CancelledOrVoided_NO_QUESTION(@Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock1) {
        this.setupMockMessages(false);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled");
        Mockito.when((Object)duplicatePaymentRequestDocumentMock1.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock1);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assertions.assertEquals((int)1, (int)messages.size());
        String expectedDuplicateInvoiceDateAmountCancelledOrVoidedDvWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.cancelledOrVoided"), "for the specified payee", "");
        Assertions.assertEquals((Object)expectedDuplicateInvoiceDateAmountCancelledOrVoidedDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_CancelledVoidedAndNormal(@Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock1, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock2) {
        this.setupMockMessages(true);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock1);
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock2);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_CancelledVoidedAndNormal_NO_QUESTION(@Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock1, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock2) {
        this.setupMockMessages(false);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock1);
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock2);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountDvWarningNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_noDuplicateDv_noDuplicatePreq(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock) {
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)0, (int)messages.size());
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_noDuplicatePreq(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock) {
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, paymentRequestDocumentMock.getInvoiceDate(), paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byVendorAndInvoiceNumber(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "In Process", "1"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoicePreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byVendorAndInvoiceNumber_Cancelled(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "Cancelled", "2"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceCancelledPreqToken, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byVendorAndInvoiceNumber_Voided(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "Cancelled In Process", "3"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceVoided, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byVendorAndInvoiceNumber_CancelledOrVoided(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestView1Mock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocument1Mock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "Cancelled", "2"));
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestView1Mock, duplicatePaymentRequestDocument1Mock, "Cancelled In Process", "3"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceCancelledOrVoidedPreqToken, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byVendorAndInvoiceNumber_CancelledOrVoidedAndNormal(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock1, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock1, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock2, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock2) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        Mockito.when((Object)duplicatePaymentRequestViewMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)duplicatePaymentRequestViewMock.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1")).thenReturn((Object)duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)duplicatePaymentRequestViewMock1.getDocumentNumber()).thenReturn((Object)"2");
        Mockito.when((Object)duplicatePaymentRequestViewMock1.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("2")).thenReturn((Object)duplicatePaymentRequestDocumentMock1);
        Mockito.when((Object)duplicatePaymentRequestViewMock2.getDocumentNumber()).thenReturn((Object)"3");
        Mockito.when((Object)duplicatePaymentRequestViewMock2.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("3")).thenReturn((Object)duplicatePaymentRequestDocumentMock2);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(duplicatePaymentRequestViewMock);
        duplicatePaymentRequestViews.add(duplicatePaymentRequestViewMock1);
        duplicatePaymentRequestViews.add(duplicatePaymentRequestViewMock2);
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoicePreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byInvoiceDateAndTotal(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byInvoiceDateAndTotal_Cancelled(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountCancelledPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byInvoiceDateAndTotal_Voided(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled In Process");
        List<PaymentRequestDocument> duplicatePaymentRequests = List.of(duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountVoidedPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byInvoiceDateAndTotal_CancelledOrVoided(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock1) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled");
        Mockito.when((Object)duplicatePaymentRequestDocumentMock1.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock1);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountCancelledOrVoidedPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byInvoiceDateAndTotal_CancelledOrVoidedAndNormal(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock1, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock2) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock1);
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock2);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_byVendorAndInvoiceNumber(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, paymentRequestDocumentMock.getInvoiceDate(), paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "In Process", "1"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)2, (int)messages.size());
        Assertions.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assertions.assertEquals((Object)this.expectedDuplicateInvoicePreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_byVendorAndInvoiceNumber_Cancelled(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, paymentRequestDocumentMock.getInvoiceDate(), paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "Cancelled", "2"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)2, (int)messages.size());
        Assertions.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceCancelledPreqToken, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_byVendorAndInvoiceNumber_Voided(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, paymentRequestDocumentMock.getInvoiceDate(), paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "Cancelled In Process", "3"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)2, (int)messages.size());
        Assertions.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceVoided, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_byVendorAndInvoiceNumber_CancelledOrVoided(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestView1Mock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocument1Mock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, paymentRequestDocumentMock.getInvoiceDate(), paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "Cancelled", "2"));
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestView1Mock, duplicatePaymentRequestDocument1Mock, "Cancelled In Process", "3"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)2, (int)messages.size());
        Assertions.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceCancelledOrVoidedPreqToken, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_byVendorAndInvoiceNumber_CancelledOrVoidedAndNormal(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock2, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock2, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock1, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock1) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, paymentRequestDocumentMock.getInvoiceDate(), paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        Mockito.when((Object)duplicatePaymentRequestViewMock2.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)duplicatePaymentRequestViewMock2.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)duplicatePaymentRequestDocumentMock2.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1")).thenReturn((Object)duplicatePaymentRequestDocumentMock2);
        Mockito.when((Object)duplicatePaymentRequestViewMock.getDocumentNumber()).thenReturn((Object)"2");
        Mockito.when((Object)duplicatePaymentRequestViewMock.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("2")).thenReturn((Object)duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)duplicatePaymentRequestViewMock1.getDocumentNumber()).thenReturn((Object)"3");
        Mockito.when((Object)duplicatePaymentRequestViewMock1.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("3")).thenReturn((Object)duplicatePaymentRequestDocumentMock1);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(duplicatePaymentRequestViewMock2);
        duplicatePaymentRequestViews.add(duplicatePaymentRequestViewMock);
        duplicatePaymentRequestViews.add(duplicatePaymentRequestViewMock1);
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)2, (int)messages.size());
        Assertions.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assertions.assertEquals((Object)this.expectedDuplicateInvoicePreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_byInvoiceDateAndTotal(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, paymentRequestDocumentMock.getInvoiceDate(), paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)2, (int)messages.size());
        Assertions.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_byInvoiceDateAndTotal_Cancelled(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, paymentRequestDocumentMock.getInvoiceDate(), paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)2, (int)messages.size());
        Assertions.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountCancelledPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_byInvoiceDateAndTotal_Voided(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, paymentRequestDocumentMock.getInvoiceDate(), paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)2, (int)messages.size());
        Assertions.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountVoidedPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_byInvoiceDateAndTotal_CancelledOrVoided(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock1) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, paymentRequestDocumentMock.getInvoiceDate(), paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled");
        Mockito.when((Object)duplicatePaymentRequestDocumentMock1.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock1);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)2, (int)messages.size());
        Assertions.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountCancelledOrVoidedPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_byInvoiceDateAndTotal_CancelledOrVoidedAndNormal(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock1, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock2) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, paymentRequestDocumentMock.getInvoiceDate(), paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock);
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock1);
        duplicatePaymentRequests.add(duplicatePaymentRequestDocumentMock2);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)2, (int)messages.size());
        Assertions.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assertions.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_bothChecksDisabled(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock) {
        Mockito.when((Object)this.purchaseOrderDocumentMock.getVendorDetailAssignedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getVendorHeaderGeneratedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)paymentRequestDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocumentMock);
        this.setupMockParameters();
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_DISBURSEMENT_VOUCHER_IND")).thenReturn((Object)false);
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_PAYMENT_REQUEST_IND")).thenReturn((Object)false);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)0, (int)messages.size());
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_dvCheckEnabled_preqCheckDisabled(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock) {
        Mockito.when((Object)this.purchaseOrderDocumentMock.getVendorDetailAssignedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getVendorHeaderGeneratedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)paymentRequestDocumentMock.getInvoiceNumber()).thenReturn((Object)"A$1%2-345");
        Mockito.when((Object)paymentRequestDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocumentMock);
        Mockito.when((Object)paymentRequestDocumentMock.getVendorInvoiceAmount()).thenReturn((Object)INVOICE_AMOUNT);
        Mockito.when((Object)paymentRequestDocumentMock.getInvoiceDate()).thenReturn((Object)TODAY);
        this.setupMockParameters();
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_PAYMENT_REQUEST_IND")).thenReturn((Object)false);
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, paymentRequestDocumentMock.getInvoiceDate(), paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
    }

    @Test
    void checkForDuplicatePayments_duplicateDv_duplicatePreq_dvCheckDisabled_preqCheckEnabled(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PaymentRequestView duplicatePaymentRequestViewMock, @Mock(stubOnly=true) PaymentRequestDocument duplicatePaymentRequestDocumentMock) {
        this.setupMockMessages(true);
        this.setupMockDocuments(paymentRequestDocumentMock);
        this.setupMockParameters();
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_DISBURSEMENT_VOUCHER_IND")).thenReturn((Object)false);
        ArrayList<PaymentRequestView> duplicatePaymentRequestViews = new ArrayList<PaymentRequestView>();
        duplicatePaymentRequestViews.add(this.buildMockPaymentRequestView(duplicatePaymentRequestViewMock, duplicatePaymentRequestDocumentMock, "In Process", "1"));
        Mockito.when((Object)this.paymentRequestDaoMock.getPossibleDuplicatePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequestViews);
        HashMap messages = this.cut.checkForDuplicatePayments(paymentRequestDocumentMock);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertEquals((Object)this.expectedDuplicateInvoicePreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    void removeTaxItems_noNonresidentTaxItems_nothingRemoved(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock) {
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(new PaymentRequestItem());
        items.add(PaymentRequestServiceImplTest.createPaymentRequestItem("SPHD"));
        Mockito.when((Object)paymentRequestDocumentMock.getItems()).thenReturn(items);
        ArrayList expectedItems = new ArrayList(items);
        this.cut.removeTaxItems(paymentRequestDocumentMock);
        List actualItems = paymentRequestDocumentMock.getItems();
        Assertions.assertEquals((int)2, (int)actualItems.size());
        Assertions.assertEquals(expectedItems, (Object)actualItems);
    }

    private static PurApItem createPaymentRequestItem(String itemTypeCode) {
        PaymentRequestItem purApItem = new PaymentRequestItem();
        purApItem.setItemTypeCode(itemTypeCode);
        return purApItem;
    }

    @Test
    void removeTaxItems_hasNonresidentTaxItems_allNonresidentTaxItemsRemoved(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock) {
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(new PaymentRequestItem());
        ArrayList<PurApItem> expectedItems = new ArrayList<PurApItem>(items);
        items.add(PaymentRequestServiceImplTest.createPaymentRequestItem("FDTX"));
        items.add(PaymentRequestServiceImplTest.createPaymentRequestItem("STTX"));
        PurApItem shippingPaymentRequestItem = PaymentRequestServiceImplTest.createPaymentRequestItem("SPHD");
        items.add(shippingPaymentRequestItem);
        expectedItems.add(shippingPaymentRequestItem);
        items.add(PaymentRequestServiceImplTest.createPaymentRequestItem("FDGR"));
        items.add(PaymentRequestServiceImplTest.createPaymentRequestItem("STGR"));
        Mockito.when((Object)paymentRequestDocumentMock.getItems()).thenReturn(items);
        this.cut.removeTaxItems(paymentRequestDocumentMock);
        List actualItems = paymentRequestDocumentMock.getItems();
        Assertions.assertEquals((int)2, (int)actualItems.size());
        Assertions.assertEquals(expectedItems, (Object)actualItems);
    }

    @Test
    void populatePaymentRequest(@Mock(stubOnly=true) AccountsPayableService accountsPayableServiceMock, @Mock(stubOnly=true) BankService bankServiceMock, @Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock(stubOnly=true) DataDictionaryService dataDictionaryServiceMock, @Mock(stubOnly=true) PurapAccountingService purapAccountingServiceMock, @Mock PaymentRequestDocument paymentRequestDocumentMock) {
        this.cut.setAccountsPayableService(accountsPayableServiceMock);
        this.cut.setBankService(bankServiceMock);
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.cut.setDataDictionaryService(dataDictionaryServiceMock);
        this.cut.setPurapAccountingService(purapAccountingServiceMock);
        Mockito.when((Object)accountsPayableServiceMock.getExpiredOrClosedAccountList((AccountsPayableDocument)paymentRequestDocumentMock)).thenReturn(new HashMap());
        DocumentHeader header = new DocumentHeader();
        Mockito.when((Object)paymentRequestDocumentMock.getDocumentHeader()).thenReturn((Object)header);
        Mockito.when((Object)paymentRequestDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)paymentRequestDocumentMock.getVendorName()).thenReturn((Object)"vendor name");
        int longEnoughAttributeLength = 10000;
        Mockito.when((Object)dataDictionaryServiceMock.getAttributeMaxLength(DocumentHeader.class, "documentDescription")).thenReturn((Object)10000);
        PaymentMethod paymentMethod = PaymentRequestServiceImplTest.setUpPaymentMethod(businessObjectServiceMock);
        Bank bank = PaymentRequestServiceImplTest.setUpBank(bankServiceMock, paymentMethod);
        this.cut.populatePaymentRequest(paymentRequestDocumentMock);
        Assertions.assertEquals((Object)"PO: 1 Vendor: vendor name", (Object)header.getDocumentDescription());
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setPaymentMethodCode("P");
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setPaymentMethod(paymentMethod);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setBankCode(BANK_CODE);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setBank(bank);
    }

    @Test
    @DisplayName(value="initializePaymentMethodAndBank() succeeds on the happy path")
    void initializePaymentMethodAndBank(@Mock(stubOnly=true) BankService bankServiceMock, @Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock PaymentRequestDocument paymentRequestDocumentMock) {
        this.cut.setBankService(bankServiceMock);
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        PaymentMethod paymentMethod = PaymentRequestServiceImplTest.setUpPaymentMethod(businessObjectServiceMock);
        Bank bank = PaymentRequestServiceImplTest.setUpBank(bankServiceMock, paymentMethod);
        this.cut.initializePaymentMethodAndBank(paymentRequestDocumentMock);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setPaymentMethod(paymentMethod);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setPaymentMethodCode("P");
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setBankCode(BANK_CODE);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setBank(bank);
    }

    @Test
    @DisplayName(value="initializePaymentMethodAndBank() with null payment method")
    void initializePaymentMethodAndBankWithNullPaymentMethod(@Mock(stubOnly=true) BankService bankServiceMock, @Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock PaymentRequestDocument paymentRequestDocumentMock) {
        this.cut.setBankService(bankServiceMock);
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        Bank bank = PaymentRequestServiceImplTest.setUpBank(bankServiceMock, null);
        this.cut.initializePaymentMethodAndBank(paymentRequestDocumentMock);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setBankCode(BANK_CODE);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setBank(bank);
    }

    private static PaymentMethod setUpPaymentMethod(BusinessObjectService businessObjectServiceMock) {
        PaymentMethod paymentMethod = new PaymentMethod();
        paymentMethod.setActive(true);
        paymentMethod.setPaymentMethodCode("P");
        Mockito.when((Object)((PaymentMethod)businessObjectServiceMock.findBySinglePrimaryKey(PaymentMethod.class, (Object)"P"))).thenReturn((Object)paymentMethod);
        return paymentMethod;
    }

    private static Bank setUpBank(BankService bankServiceMock, PaymentMethod paymentMethod) {
        Bank bank = new Bank();
        bank.setBankCode(BANK_CODE);
        Mockito.when((Object)bankServiceMock.getInitialBank(paymentMethod, "PREQ")).thenReturn(Optional.of(bank));
        return bank;
    }
}

