/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.document.DisbursementVoucherDocument;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.ReceivingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.document.service.impl.PurchasingAccountsPayableModuleServiceImpl;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PurchasingAccountsPayableModuleServiceImplTest {
    private static final Integer REQUISITION_IDENTIFIER = 12345;
    private static final String REQUISITION_INITIATOR = "mbaxter";
    private static final String DOCUMENT_NUMBER = "123456";
    private static final String PREQ_NOTE_TEXT = "PREQ reissued inside PDP.";
    private static final String CM_NOTE_TEXT = "CM reissued inside PDP.";
    @Spy
    private PurchasingAccountsPayableModuleServiceImpl cutSpy;
    @Mock(stubOnly=true)
    private RequisitionService requisitionSvcMock;
    @Mock(stubOnly=true)
    private ParameterService parameterServiceMock;
    @Mock(stubOnly=true)
    private PaymentRequestService paymentRequestServiceMock;
    @Mock(stubOnly=true)
    private CreditMemoService creditMemoServiceMock;
    @Mock
    private DocumentService documentServiceMock;
    @Mock
    private NoteService noteServiceMock;
    @Mock
    private AccountsPayableService accountsPayableServiceMock;

    PurchasingAccountsPayableModuleServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.cutSpy.setRequisitionService(this.requisitionSvcMock);
        this.cutSpy.setParameterService(this.parameterServiceMock);
        this.cutSpy.setPaymentRequestService(this.paymentRequestServiceMock);
        this.cutSpy.setCreditMemoService(this.creditMemoServiceMock);
        this.cutSpy.setDocumentService(this.documentServiceMock);
        this.cutSpy.setNoteService(this.noteServiceMock);
        this.cutSpy.setAccountsPayableService(this.accountsPayableServiceMock);
    }

    @Test
    void determineRelatedRequisitionInitiatorPrincipalId_NoRelatedREQ(@Mock(stubOnly=true) Document documentMock) {
        Assertions.assertNull((Object)this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId(documentMock));
    }

    @Test
    void determineRelatedRequisitionInitiatorPrincipalId_AccountsPayable_NoPO(@Mock(stubOnly=true) AccountsPayableDocument accountsPayableDocumentMock) {
        Assertions.assertNull((Object)this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)accountsPayableDocumentMock));
    }

    @Test
    void determineRelatedRequisitionInitiatorPrincipalId_PREQ_HasRelatedREQ(@Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock, @Mock(stubOnly=true) RequisitionDocument requisitionDocumentMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        Mockito.when((Object)paymentRequestDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)purchaseOrderDocumentMock);
        Mockito.when((Object)purchaseOrderDocumentMock.getRequisitionIdentifier()).thenReturn((Object)REQUISITION_IDENTIFIER);
        Mockito.when((Object)this.requisitionSvcMock.getRequisitionById(REQUISITION_IDENTIFIER)).thenReturn((Object)requisitionDocumentMock);
        Mockito.when((Object)requisitionDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)workflowDocumentMock.getInitiatorPrincipalId()).thenReturn((Object)REQUISITION_INITIATOR);
        String principalId = this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)paymentRequestDocumentMock);
        Assertions.assertEquals((Object)REQUISITION_INITIATOR, (Object)principalId);
    }

    @Test
    void determineRelatedRequisitionInitiatorPrincipalId_CM_HasRelatedREQ(@Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock, @Mock(stubOnly=true) RequisitionDocument requisitionDocumentMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)purchaseOrderDocumentMock);
        Mockito.when((Object)purchaseOrderDocumentMock.getRequisitionIdentifier()).thenReturn((Object)REQUISITION_IDENTIFIER);
        Mockito.when((Object)this.requisitionSvcMock.getRequisitionById(REQUISITION_IDENTIFIER)).thenReturn((Object)requisitionDocumentMock);
        Mockito.when((Object)requisitionDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)workflowDocumentMock.getInitiatorPrincipalId()).thenReturn((Object)REQUISITION_INITIATOR);
        String principalId = this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)vendorCreditMemoDocumentMock);
        Assertions.assertEquals((Object)REQUISITION_INITIATOR, (Object)principalId);
    }

    @Test
    void determineRelatedRequisitionInitiatorPrincipalId_PO_HasRelatedREQ(@Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock, @Mock(stubOnly=true) RequisitionDocument requisitionDocumentMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        Mockito.when((Object)purchaseOrderDocumentMock.getRequisitionIdentifier()).thenReturn((Object)REQUISITION_IDENTIFIER);
        Mockito.when((Object)this.requisitionSvcMock.getRequisitionById(REQUISITION_IDENTIFIER)).thenReturn((Object)requisitionDocumentMock);
        Mockito.when((Object)requisitionDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)workflowDocumentMock.getInitiatorPrincipalId()).thenReturn((Object)REQUISITION_INITIATOR);
        String principalId = this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)purchaseOrderDocumentMock);
        Assertions.assertEquals((Object)REQUISITION_INITIATOR, (Object)principalId);
    }

    @Test
    void determineRelatedRequisitionInitiatorPrincipalId_REQS_NoRelatedREQ(@Mock(stubOnly=true) RequisitionDocument requisitionDocumentMock) {
        Assertions.assertNull((Object)this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)requisitionDocumentMock));
    }

    @Test
    void determineRelatedRequisitionInitiatorPrincipalId_Not_PREQ_CM_PO(@Mock(stubOnly=true) ReceivingDocument receivingDocumentMock) {
        Assertions.assertNull((Object)this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)receivingDocumentMock));
    }

    @Test
    void determineRelatedRequisitionInitiatorPrincipalId_NotPurapDocument(@Mock(stubOnly=true) DisbursementVoucherDocument disbursementVoucherDocumentMock) {
        Assertions.assertNull((Object)this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)disbursementVoucherDocumentMock));
    }

    @Test
    void handlePurchasingBatchReissue_PREQ(@Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock Note noteMock) {
        ((ParameterService)Mockito.doReturn((Object)PREQ_NOTE_TEXT).when((Object)this.parameterServiceMock)).getParameterValueAsString(PaymentRequestDocument.class, "REISSUE_NOTE");
        ((PaymentRequestService)Mockito.doReturn((Object)paymentRequestDocumentMock).when((Object)this.paymentRequestServiceMock)).getPaymentRequestByDocumentNumber(DOCUMENT_NUMBER);
        ((PurchasingAccountsPayableModuleServiceImpl)Mockito.doReturn((Object)"2").when((Object)this.cutSpy)).getSystemUserPrincipalId();
        Mockito.when((Object)this.documentServiceMock.createNoteFromDocument((Document)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn((Object)noteMock);
        ((PaymentRequestDocument)Mockito.doReturn((Object)"Cancelled").when((Object)paymentRequestDocumentMock)).getApplicationDocumentStatus();
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "PREQ");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).createNoteFromDocument((Document)paymentRequestDocumentMock, PREQ_NOTE_TEXT);
        ((NoteService)Mockito.verify((Object)this.noteServiceMock)).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock)).revertToPreviousAppDocStatus((AccountsPayableDocument)paymentRequestDocumentMock);
        ((Note)Mockito.verify((Object)noteMock)).setAuthorUniversalIdentifier("2");
    }

    @Test
    void handlePurchasingBatchReissue_PREQ_notFound() {
        ((PaymentRequestService)Mockito.doReturn(null).when((Object)this.paymentRequestServiceMock)).getPaymentRequestByDocumentNumber(DOCUMENT_NUMBER);
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "PREQ");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(String.class));
        ((NoteService)Mockito.verify((Object)this.noteServiceMock, (VerificationMode)Mockito.never())).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock, (VerificationMode)Mockito.never())).revertToPreviousAppDocStatus((AccountsPayableDocument)ArgumentMatchers.any());
    }

    @Test
    void handlePurchasingBatchReissue_PREQ_wrong_status(@Mock PaymentRequestDocument paymentRequestDocumentMock) {
        ((PaymentRequestService)Mockito.doReturn((Object)paymentRequestDocumentMock).when((Object)this.paymentRequestServiceMock)).getPaymentRequestByDocumentNumber(DOCUMENT_NUMBER);
        ((PaymentRequestDocument)Mockito.doReturn((Object)"Department-Approved").when((Object)paymentRequestDocumentMock)).getApplicationDocumentStatus();
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "PREQ");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.any(PaymentRequestDocument.class), (String)ArgumentMatchers.any(String.class));
        ((NoteService)Mockito.verify((Object)this.noteServiceMock, (VerificationMode)Mockito.never())).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock, (VerificationMode)Mockito.never())).revertToPreviousAppDocStatus((AccountsPayableDocument)ArgumentMatchers.any(PaymentRequestDocument.class));
    }

    @Test
    void handlePurchasingBatchReissue_CM(@Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock, @Mock(stubOnly=true) Note noteMock) {
        ((ParameterService)Mockito.doReturn((Object)CM_NOTE_TEXT).when((Object)this.parameterServiceMock)).getParameterValueAsString(VendorCreditMemoDocument.class, "REISSUE_NOTE");
        ((CreditMemoService)Mockito.doReturn((Object)vendorCreditMemoDocumentMock).when((Object)this.creditMemoServiceMock)).getCreditMemoByDocumentNumber(DOCUMENT_NUMBER);
        ((PurchasingAccountsPayableModuleServiceImpl)Mockito.doReturn((Object)"2").when((Object)this.cutSpy)).getSystemUserPrincipalId();
        Mockito.when((Object)this.documentServiceMock.createNoteFromDocument((Document)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn((Object)noteMock);
        ((VendorCreditMemoDocument)Mockito.doReturn((Object)"Cancelled").when((Object)vendorCreditMemoDocumentMock)).getApplicationDocumentStatus();
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "CM");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).createNoteFromDocument((Document)vendorCreditMemoDocumentMock, CM_NOTE_TEXT);
        ((NoteService)Mockito.verify((Object)this.noteServiceMock)).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock)).revertToPreviousAppDocStatus((AccountsPayableDocument)vendorCreditMemoDocumentMock);
    }

    @Test
    void handlePurchasingBatchReissue_CM_wrong_status(@Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        ((CreditMemoService)Mockito.doReturn((Object)vendorCreditMemoDocumentMock).when((Object)this.creditMemoServiceMock)).getCreditMemoByDocumentNumber(DOCUMENT_NUMBER);
        ((VendorCreditMemoDocument)Mockito.doReturn((Object)"Complete").when((Object)vendorCreditMemoDocumentMock)).getApplicationDocumentStatus();
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "CM");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.any(VendorCreditMemoDocument.class), (String)ArgumentMatchers.any(String.class));
        ((NoteService)Mockito.verify((Object)this.noteServiceMock, (VerificationMode)Mockito.never())).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock, (VerificationMode)Mockito.never())).revertToPreviousAppDocStatus((AccountsPayableDocument)ArgumentMatchers.any(VendorCreditMemoDocument.class));
    }

    @Test
    void handlePurchasingBatchReissue_CM_notFound() {
        ((CreditMemoService)Mockito.doReturn(null).when((Object)this.creditMemoServiceMock)).getCreditMemoByDocumentNumber(DOCUMENT_NUMBER);
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "CM");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(String.class));
        ((NoteService)Mockito.verify((Object)this.noteServiceMock, (VerificationMode)Mockito.never())).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock, (VerificationMode)Mockito.never())).revertToPreviousAppDocStatus((AccountsPayableDocument)ArgumentMatchers.any());
    }

    @Test
    void handlePurchasingBatchReissue_Not_PREQ_CM() {
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "THLD");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(String.class));
        ((NoteService)Mockito.verify((Object)this.noteServiceMock, (VerificationMode)Mockito.never())).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock, (VerificationMode)Mockito.never())).revertToPreviousAppDocStatus((AccountsPayableDocument)ArgumentMatchers.any());
    }

    @Test
    void handlePurchasingBatchReissue_NotPurapDocument() {
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "DV");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(String.class));
        ((NoteService)Mockito.verify((Object)this.noteServiceMock, (VerificationMode)Mockito.never())).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock, (VerificationMode)Mockito.never())).revertToPreviousAppDocStatus((AccountsPayableDocument)ArgumentMatchers.any());
    }
}

