/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.validation.event.AttributedAddPurchasingAccountsPayableItemEvent;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderEmptyItemWithAccountsValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PurchaseOrderEmptyItemWithAccountsValidationTest {
    private PurchaseOrderEmptyItemWithAccountsValidation cut;
    @Mock(stubOnly=true)
    private PurchaseOrderItem poItemMock;

    PurchaseOrderEmptyItemWithAccountsValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurchaseOrderEmptyItemWithAccountsValidation();
        this.cut.setItemForValidation(this.poItemMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void validate_LineItemType_NullItem_WithAccount(@Mock(stubOnly=true) ItemType itemTypeMock) {
        Mockito.when((Object)itemTypeMock.isLineItemIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.poItemMock.getItemType()).thenReturn((Object)itemTypeMock);
        Mockito.when((Object)this.poItemMock.isItemDetailEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.poItemMock.isAccountListEmpty()).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", null, (PurApItem)this.poItemMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.notallowed"));
    }

    @Test
    void validate_LineItemType_WithItem_WithAccount(@Mock(stubOnly=true) ItemType itemTypeMock) {
        Mockito.when((Object)itemTypeMock.isLineItemIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.poItemMock.getItemType()).thenReturn((Object)itemTypeMock);
        Mockito.when((Object)this.poItemMock.isItemDetailEmpty()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", null, (PurApItem)this.poItemMock)));
    }

    @Test
    void validate_LineItemType_WithItem_WithoutAccount(@Mock(stubOnly=true) ItemType itemTypeMock) {
        Mockito.when((Object)itemTypeMock.isLineItemIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.poItemMock.getItemType()).thenReturn((Object)itemTypeMock);
        Mockito.when((Object)this.poItemMock.isItemDetailEmpty()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", null, (PurApItem)this.poItemMock)));
    }

    @Test
    void validate_NonLineItemType_NullItem_WithAccount(@Mock(stubOnly=true) ItemType itemTypeMock) {
        Mockito.when((Object)this.poItemMock.getItemType()).thenReturn((Object)itemTypeMock);
        Mockito.when((Object)itemTypeMock.isLineItemIndicator()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", null, (PurApItem)this.poItemMock)));
    }

    @Test
    void validate_NonLineItemType_WithItem_WithAccount(@Mock(stubOnly=true) ItemType itemTypeMock) {
        Mockito.when((Object)this.poItemMock.getItemType()).thenReturn((Object)itemTypeMock);
        Mockito.when((Object)itemTypeMock.isLineItemIndicator()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", null, (PurApItem)this.poItemMock)));
    }

    @Test
    void validate_NonLineItemType_WithItem_WithoutAccount(@Mock(stubOnly=true) ItemType itemTypeMock) {
        Mockito.when((Object)this.poItemMock.getItemType()).thenReturn((Object)itemTypeMock);
        Mockito.when((Object)itemTypeMock.isLineItemIndicator()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", null, (PurApItem)this.poItemMock)));
    }
}

