/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Collections;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorStipulation;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderProcessVendorStipulationValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PurchaseOrderProcessVendorStipulationValidationTest {
    private PurchaseOrderProcessVendorStipulationValidation cut;

    PurchaseOrderProcessVendorStipulationValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurchaseOrderProcessVendorStipulationValidation();
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void validate_StipulationDescription_NotBlank(@Mock(stubOnly=true) PurchaseOrderDocument poDocMock) {
        PurchaseOrderVendorStipulation vendorStipulation = new PurchaseOrderVendorStipulation();
        vendorStipulation.setVendorStipulationDescription("test");
        Mockito.when((Object)poDocMock.getPurchaseOrderVendorStipulations()).thenReturn(Collections.singletonList(vendorStipulation));
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)poDocMock)));
    }

    @Test
    void validate_StipulationDescription_Blank(@Mock(stubOnly=true) PurchaseOrderDocument poDocMock) {
        PurchaseOrderVendorStipulation vendorStipulation = new PurchaseOrderVendorStipulation();
        vendorStipulation.setVendorStipulationDescription("");
        Mockito.when((Object)poDocMock.getPurchaseOrderVendorStipulations()).thenReturn(Collections.singletonList(vendorStipulation));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)poDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.purchaseOrderVendorStipulations[0].vendorStipulationDescription", "error.purchaseOrder.stipulationDescriptionEmpty"));
    }
}

