/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingDeliveryValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.PostalCodeValidationService;
import org.kuali.kfs.vnd.businessobject.CampusParameter;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PurchasingDeliveryValidationTest {
    private PurchasingDeliveryValidation cut;
    @Mock
    private AttributedDocumentEvent eventMock;
    @Mock
    private PurchasingDocument purchasingDocumentMock;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private ConfigurationService configurationSvcMock;
    @Mock
    private PostalCodeValidationService postalCodeValidationSvcMock;

    PurchasingDeliveryValidationTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.eventMock.getDocument()).thenReturn((Object)this.purchasingDocumentMock);
        Mockito.when((Object)this.businessObjectSvcMock.countMatching(CampusParameter.class, Collections.singletonMap("campusCode", null))).thenReturn((Object)1);
        this.cut = new PurchasingDeliveryValidation();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setPostalCodeValidationService(this.postalCodeValidationSvcMock);
    }

    @Test
    void validate_noEmail_noPhone_valid() {
        boolean validate = this.cut.validate(this.eventMock);
        Assertions.assertTrue((boolean)validate);
    }

    @Test
    void validate_validEmail_noPhone_valid() {
        boolean validate;
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("validationPatternRegex.emailAddress")).thenReturn((Object)"[A-Za-z0-9]+([_.\\-][A-Za-z0-9]+)*@([A-Za-z0-9][A-Za-z0-9_-]*\\.)+[A-Za-z]{2,}");
        Mockito.when((Object)this.purchasingDocumentMock.getRequestorPersonEmailAddress()).thenReturn((Object)"test@kuali.co");
        try (MockedStatic kradServiceLocatorMockedStatic = Mockito.mockStatic(KRADServiceLocator.class);){
            kradServiceLocatorMockedStatic.when(KRADServiceLocator::getKualiConfigurationService).thenReturn((Object)this.configurationSvcMock);
            validate = this.cut.validate(this.eventMock);
        }
        Assertions.assertTrue((boolean)validate);
    }

    @Test
    void validate_invalidEmail_noPhone_invalid() {
        boolean validate;
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("validationPatternRegex.emailAddress")).thenReturn((Object)"[A-Za-z0-9]+([_.\\-][A-Za-z0-9]+)*@([A-Za-z0-9][A-Za-z0-9_-]*\\.)+[A-Za-z]{2,}");
        Mockito.when((Object)this.purchasingDocumentMock.getRequestorPersonEmailAddress()).thenReturn((Object)"invalidEmail");
        try (MockedStatic kradServiceLocatorMockedStatic = Mockito.mockStatic(KRADServiceLocator.class);){
            kradServiceLocatorMockedStatic.when(KRADServiceLocator::getKualiConfigurationService).thenReturn((Object)this.configurationSvcMock);
            validate = this.cut.validate(this.eventMock);
        }
        Assertions.assertFalse((boolean)validate);
    }

    @Test
    void validate_noEmail_validPhone_valid() {
        boolean validate;
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("validationPatternRegex.phoneNumber")).thenReturn((Object)"[0-9]{3}\\-[0-9]{3}\\-[0-9]{4}");
        Mockito.when((Object)this.purchasingDocumentMock.getDeliveryToPhoneNumber()).thenReturn((Object)"585-555-1212");
        try (MockedStatic kradServiceLocatorMockedStatic = Mockito.mockStatic(KRADServiceLocator.class);){
            kradServiceLocatorMockedStatic.when(KRADServiceLocator::getKualiConfigurationService).thenReturn((Object)this.configurationSvcMock);
            validate = this.cut.validate(this.eventMock);
        }
        Assertions.assertTrue((boolean)validate);
    }

    @Test
    void validate_noEmail_invalidPhone_invalid() {
        boolean validate;
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("validationPatternRegex.phoneNumber")).thenReturn((Object)"[0-9]{3}\\-[0-9]{3}\\-[0-9]{4}");
        Mockito.when((Object)this.purchasingDocumentMock.getDeliveryToPhoneNumber()).thenReturn((Object)"invalidPhoneNumber");
        try (MockedStatic kradServiceLocatorMockedStatic = Mockito.mockStatic(KRADServiceLocator.class);){
            kradServiceLocatorMockedStatic.when(KRADServiceLocator::getKualiConfigurationService).thenReturn((Object)this.configurationSvcMock);
            validate = this.cut.validate(this.eventMock);
        }
        Assertions.assertFalse((boolean)validate);
    }
}

