/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.ArrayList;
import java.util.Map;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.MessageList;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionAccount;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.validation.PurapRuleIntegTestBase;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingBelowTheLineItemNoUnitCostValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingItemDescriptionValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingItemQuantityValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingItemUnitPriceValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingPaymentInfoValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingUnitOfMeasureValidation;
import org.kuali.kfs.module.purap.fixture.ItemFieldsFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentWithCommodityCodeFixture;
import org.kuali.kfs.module.purap.fixture.RecurringPaymentBeginEndDatesFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentWithCommodityCodeFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.IntegTestUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.Validation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.kfs.sys.document.validation.impl.CompositeValidation;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.parke)
@Execution(value=ExecutionMode.SAME_THREAD)
public class PurchasingDocumentRuleIntegTest
extends PurapRuleIntegTestBase {
    private Map<String, Validation> validations;

    protected void setUp() throws Exception {
        super.setUp();
        KNSGlobalVariables.setMessageList((MessageList)new MessageList());
        this.validations = SpringContext.getBeansOfType(Validation.class);
    }

    protected void tearDown() throws Exception {
        this.validations = null;
        super.tearDown();
    }

    public void testProcessPaymentInfoValidation_Req_RightOrder() {
        PurchasingDocument document = RecurringPaymentBeginEndDatesFixture.REQ_RIGHT_ORDER.populateDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document)));
    }

    public void testProcessPaymentInfoValidation_Req_WrongOrder() {
        PurchasingDocument document = RecurringPaymentBeginEndDatesFixture.REQ_WRONG_ORDER.populateDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        PurchasingDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document)));
    }

    public void testProcessPaymentInfoValidation_Req_Sequential_Next_FY() {
        PurchasingDocument document = RecurringPaymentBeginEndDatesFixture.REQ_SEQUENTIAL_NEXT_FY.populateDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document)));
    }

    public void testProcessPaymentInfoValidation_Req_Non_Sequential_Next_FY() {
        PurchasingDocument document = RecurringPaymentBeginEndDatesFixture.REQ_NON_SEQUENTIAL_NEXT_FY.populateDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        PurchasingDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document)));
    }

    public void testProcessPaymentInfoValidation_PO_RightOrder() {
        PurchasingDocument document = RecurringPaymentBeginEndDatesFixture.PO_RIGHT_ORDER.populateDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document)));
    }

    public void testProcessPaymentInfoValidation_PO_WrongOrder() {
        PurchasingDocument document = RecurringPaymentBeginEndDatesFixture.PO_WRONG_ORDER.populateDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        PurchasingDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document)));
    }

    public void testProcessPaymentInfoValidation_PO_Sequential_Next_FY() {
        PurchasingDocument document = RecurringPaymentBeginEndDatesFixture.PO_SEQUENTIAL_NEXT_FY.populateDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document)));
    }

    public void testProcessPaymentInfoValidation_PO_Non_Sequential_Next_FY() {
        PurchasingDocument document = RecurringPaymentBeginEndDatesFixture.PO_NON_SEQUENTIAL_NEXT_FY.populateDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        PurchasingDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document)));
    }

    public void testValidateItemQuantity_WithQuantity_QuantityBased() {
        RequisitionItem item = ItemFieldsFixture.ALL_FIELDS_ABOVE_QUANTITY_BASED.populateRequisitionItem();
        PurchasingItemQuantityValidation validation = (PurchasingItemQuantityValidation)this.validations.get("Purchasing-itemQuantityValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate(null));
    }

    public void testValidateItemQuantity_WithoutQuantity_QuantityBased() {
        RequisitionItem item = ItemFieldsFixture.NO_QUANTITY_ABOVE_QUANTITY_BASED.populateRequisitionItem();
        PurchasingItemQuantityValidation validation = (PurchasingItemQuantityValidation)this.validations.get("Purchasing-itemQuantityValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertFalse((boolean)validation.validate(null));
    }

    public void testValidateItemQuantity_WithQuantity_Service() {
        RequisitionItem item = ItemFieldsFixture.ALL_FIELDS_ABOVE_SERVICE.populateRequisitionItem();
        PurchasingItemQuantityValidation validation = (PurchasingItemQuantityValidation)this.validations.get("Purchasing-itemQuantityValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertFalse((boolean)validation.validate(null));
    }

    public void testValidateItemQuantity_WithoutQuantity_Service() {
        RequisitionItem item = ItemFieldsFixture.NO_QUANTITY_ABOVE_SERVICE.populateRequisitionItem();
        PurchasingItemQuantityValidation validation = (PurchasingItemQuantityValidation)this.validations.get("Purchasing-itemQuantityValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate(null));
    }

    public void testValidateUnitOfMeasure_WithUOM_QuantityBased() {
        RequisitionItem item = ItemFieldsFixture.ALL_FIELDS_ABOVE_QUANTITY_BASED.populateRequisitionItem();
        PurchasingUnitOfMeasureValidation validation = (PurchasingUnitOfMeasureValidation)this.validations.get("Purchasing-unitOfMeasureValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate(null));
    }

    public void testValidateUnitOfMeasure_WithoutUOM_QuantityBased() {
        RequisitionItem item = ItemFieldsFixture.NO_UOM_ABOVE_QUANTITY_BASED.populateRequisitionItem();
        PurchasingUnitOfMeasureValidation validation = (PurchasingUnitOfMeasureValidation)this.validations.get("Purchasing-unitOfMeasureValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertFalse((boolean)validation.validate(null));
    }

    public void testValidateUnitOfMeasure_WithoutUOM_Service() {
        RequisitionItem item = ItemFieldsFixture.NO_UOM_ABOVE_SERVICE.populateRequisitionItem();
        PurchasingUnitOfMeasureValidation validation = (PurchasingUnitOfMeasureValidation)this.validations.get("Purchasing-unitOfMeasureValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate(null));
    }

    public void testValidateItemDescription_WithDescription_Above() {
        RequisitionItem item = ItemFieldsFixture.ALL_FIELDS_ABOVE_QUANTITY_BASED.populateRequisitionItem();
        PurchasingItemDescriptionValidation validation = (PurchasingItemDescriptionValidation)this.validations.get("Purchasing-itemDescriptionValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate(null));
    }

    public void testValidateItemDescription_WithoutDescription_Above() {
        RequisitionItem item = ItemFieldsFixture.NO_DESC_ABOVE_QUANTITY_BASED.populateRequisitionItem();
        PurchasingItemDescriptionValidation validation = (PurchasingItemDescriptionValidation)this.validations.get("Purchasing-itemDescriptionValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertFalse((boolean)validation.validate(null));
    }

    public void testValidActiveCommodityCode() throws Exception {
        IntegTestUtils.setSystemParameter(RequisitionDocument.class, (String)"ITEMS_REQUIRE_COMMODITY_CODE_IND", (String)"Y");
        RequisitionDocumentWithCommodityCodeFixture fixture = RequisitionDocumentWithCommodityCodeFixture.REQ_VALID_ACTIVE_COMMODITY_CODE;
        CompositeValidation validation = (CompositeValidation)this.validations.get("Requisition-newProcessItemValidation");
        RequisitionDocument req = fixture.createRequisitionDocument();
        AttributedDocumentEventBase event = new AttributedDocumentEventBase("", "", (Document)req);
        boolean valid = true;
        for (RequisitionItem item : req.getItems()) {
            event.setIterationSubject((Object)item);
            valid &= validation.validate((AttributedDocumentEvent)event);
        }
        PurchasingDocumentRuleIntegTest.assertTrue((String)("There should have been no validation errors: " + GlobalVariables.getMessageMap().getErrorMessages()), (boolean)valid);
        GlobalVariables.getMessageMap().clearErrorMessages();
        IntegTestUtils.setSystemParameter(PurchaseOrderDocument.class, (String)"ITEMS_REQUIRE_COMMODITY_CODE_IND", (String)"Y");
        PurchaseOrderDocumentWithCommodityCodeFixture poFixture = PurchaseOrderDocumentWithCommodityCodeFixture.PO_VALID_ACTIVE_COMMODITY_CODE;
        validation = (CompositeValidation)this.validations.get("PurchaseOrder-newProcessItemValidation");
        PurchaseOrderDocument po = poFixture.createPurchaseOrderDocument();
        event = new AttributedDocumentEventBase("", "", (Document)po);
        valid = true;
        for (PurchaseOrderItem item : po.getItems()) {
            event.setIterationSubject((Object)item);
            valid &= validation.validate((AttributedDocumentEvent)event);
        }
        PurchasingDocumentRuleIntegTest.assertTrue((String)("There should have been no validation errors: " + GlobalVariables.getMessageMap().getErrorMessages()), (boolean)valid);
    }

    public void testInactiveCommodityCodeValidation() throws Exception {
        IntegTestUtils.setSystemParameter(RequisitionDocument.class, (String)"ITEMS_REQUIRE_COMMODITY_CODE_IND", (String)"Y");
        RequisitionDocumentWithCommodityCodeFixture fixture = RequisitionDocumentWithCommodityCodeFixture.REQ_VALID_INACTIVE_COMMODITY_CODE;
        CompositeValidation validation = (CompositeValidation)this.validations.get("Requisition-newProcessItemValidation");
        RequisitionDocument req = fixture.createRequisitionDocument();
        AttributedDocumentEventBase event = new AttributedDocumentEventBase("", "", (Document)req);
        for (RequisitionItem item : req.getItems()) {
            event.setIterationSubject((Object)item);
            validation.validate((AttributedDocumentEvent)event);
        }
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.commodity.code.inactive"));
        GlobalVariables.getMessageMap().clearErrorMessages();
        IntegTestUtils.setSystemParameter(PurchaseOrderDocument.class, (String)"ITEMS_REQUIRE_COMMODITY_CODE_IND", (String)"Y");
        PurchaseOrderDocumentWithCommodityCodeFixture poFixture = PurchaseOrderDocumentWithCommodityCodeFixture.PO_VALID_INACTIVE_COMMODITY_CODE;
        validation = (CompositeValidation)this.validations.get("PurchaseOrder-newProcessItemValidation");
        PurchaseOrderDocument po = poFixture.createPurchaseOrderDocument();
        event = new AttributedDocumentEventBase("", "", (Document)po);
        for (PurchaseOrderItem item : po.getItems()) {
            event.setIterationSubject((Object)item);
            validation.validate((AttributedDocumentEvent)event);
        }
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.commodity.code.inactive"));
    }

    public void testNonExistenceCommodityCodeValidation() throws Exception {
        IntegTestUtils.setSystemParameter(RequisitionDocument.class, (String)"ITEMS_REQUIRE_COMMODITY_CODE_IND", (String)"Y");
        RequisitionDocumentWithCommodityCodeFixture fixture = RequisitionDocumentWithCommodityCodeFixture.REQ_NON_EXISTENCE_COMMODITY_CODE;
        CompositeValidation validation = (CompositeValidation)this.validations.get("Requisition-newProcessItemValidation");
        RequisitionDocument req = fixture.createRequisitionDocument();
        AttributedDocumentEventBase event = new AttributedDocumentEventBase("", "", (Document)req);
        for (RequisitionItem item : req.getItems()) {
            event.setIterationSubject((Object)item);
            validation.validate((AttributedDocumentEvent)event);
        }
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.commodity.code.invalid"));
        GlobalVariables.getMessageMap().clearErrorMessages();
        IntegTestUtils.setSystemParameter(PurchaseOrderDocument.class, (String)"ITEMS_REQUIRE_COMMODITY_CODE_IND", (String)"Y");
        PurchaseOrderDocumentWithCommodityCodeFixture poFixture = PurchaseOrderDocumentWithCommodityCodeFixture.PO_NON_EXISTENCE_COMMODITY_CODE;
        validation = (CompositeValidation)this.validations.get("PurchaseOrder-newProcessItemValidation");
        PurchaseOrderDocument po = poFixture.createPurchaseOrderDocument();
        event = new AttributedDocumentEventBase("", "", (Document)po);
        for (PurchaseOrderItem item : po.getItems()) {
            event.setIterationSubject((Object)item);
            validation.validate((AttributedDocumentEvent)event);
        }
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.commodity.code.invalid"));
    }

    public void testValidateItemUnitPrice_Positive_Above() {
        RequisitionItem item = ItemFieldsFixture.ALL_FIELDS_ABOVE_QUANTITY_BASED.populateRequisitionItem();
        PurchasingItemUnitPriceValidation validation = (PurchasingItemUnitPriceValidation)this.validations.get("Purchasing-itemUnitPriceValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate(null));
    }

    public void testValidateItemUnitPrice_Negative_Above() {
        RequisitionItem item = ItemFieldsFixture.NEGATIVE_UNIT_PRICE_QUANTITY_BASED.populateRequisitionItem();
        PurchasingItemUnitPriceValidation validation = (PurchasingItemUnitPriceValidation)this.validations.get("Purchasing-itemUnitPriceValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertFalse((boolean)validation.validate(null));
    }

    public void testValidateItemUnitPrice_Positive_Discount() {
        RequisitionItem item = ItemFieldsFixture.POSITIVE_UNIT_PRICE_DISCOUNT.populateRequisitionItem();
        PurchasingItemUnitPriceValidation validation = (PurchasingItemUnitPriceValidation)this.validations.get("Purchasing-itemUnitPriceValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertFalse((boolean)validation.validate(null));
    }

    public void testValidateItemUnitPrice_Negative_Discount() {
        RequisitionItem item = ItemFieldsFixture.NEGATIVE_UNIT_PRICE_DISCOUNT.populateRequisitionItem();
        PurchasingItemUnitPriceValidation validation = (PurchasingItemUnitPriceValidation)this.validations.get("Purchasing-itemUnitPriceValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate(null));
    }

    public void testValidateItemUnitPrice_Positive_TradeIn() {
        RequisitionItem item = ItemFieldsFixture.POSITIVE_UNIT_PRICE_TRADEIN.populateRequisitionItem();
        PurchasingItemUnitPriceValidation validation = (PurchasingItemUnitPriceValidation)this.validations.get("Purchasing-itemUnitPriceValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertFalse((boolean)validation.validate(null));
    }

    public void testValidateItemUnitPrice_Negative_TradeIn() {
        RequisitionItem item = ItemFieldsFixture.NEGATIVE_UNIT_PRICE_TRADEIN.populateRequisitionItem();
        PurchasingItemUnitPriceValidation validation = (PurchasingItemUnitPriceValidation)this.validations.get("Purchasing-itemUnitPriceValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate(null));
    }

    public void testValidateBelowTheLineItemNoUnitCost_WithUnitCost() {
        RequisitionItem item = ItemFieldsFixture.ALL_FIELDS_BELOW.populateRequisitionItem();
        ArrayList<RequisitionAccount> accountingLines = new ArrayList<RequisitionAccount>();
        accountingLines.add(new RequisitionAccount());
        item.setSourceAccountingLines(accountingLines);
        PurchasingBelowTheLineItemNoUnitCostValidation validation = (PurchasingBelowTheLineItemNoUnitCostValidation)this.validations.get("Purchasing-belowTheLineItemNoUnitCostValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertTrue((boolean)validation.validate(null));
    }

    public void testValidateBelowTheLineItemNoUnitCost_NoUnitCost() {
        RequisitionItem item = ItemFieldsFixture.NO_UNIT_PRICE_BELOW.populateRequisitionItem();
        ArrayList<RequisitionAccount> accountingLines = new ArrayList<RequisitionAccount>();
        accountingLines.add(new RequisitionAccount());
        item.setSourceAccountingLines(accountingLines);
        PurchasingBelowTheLineItemNoUnitCostValidation validation = (PurchasingBelowTheLineItemNoUnitCostValidation)this.validations.get("Purchasing-belowTheLineItemNoUnitCostValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingDocumentRuleIntegTest.assertFalse((boolean)validation.validate(null));
    }
}

