/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.HashSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.DocumentAuthorizer;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.purap.businessobject.RequisitionAccount;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.validation.impl.RequisitionAccountingLineAccessibleValidation;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.authorization.AccountingLineAuthorizer;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.UpdateAccountingLineEvent;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.util.AutoPopulatingList;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class RequisitionAccountingLineAccessibleValidationTest {
    private TestableRequisitionAccountingLineAccessibleValidation cutSpy;
    @Mock(stubOnly=true)
    private AccountingLineAuthorizer accountingLineAuthorizerMock;
    @Mock(stubOnly=true)
    private AccountService accountSvcMock;
    @Mock(stubOnly=true)
    private DataDictionaryService dataDictionarySvcMock;
    @Mock(stubOnly=true)
    private DocumentDictionaryService documentDictionarySvcMock;
    @Mock(stubOnly=true)
    private DocumentAuthorizer documentAuthorizerMock;
    @Mock(stubOnly=true)
    private DocumentHeader documentHeaderMock;
    @Mock(stubOnly=true)
    private Person personMock;
    @Mock(stubOnly=true)
    private WorkflowDocument workflowDocumentMock;
    private AccountingLine accountingLineForValidationMock;
    private AccountingLine updatedAccountingLineForValidationMock;
    private RequisitionDocument reqsDocumentSpy;
    private UpdateAccountingLineEvent event;

    RequisitionAccountingLineAccessibleValidationTest() {
    }

    @BeforeEach
    void setUp(@Mock(stubOnly=true) DocumentHeaderService documentHeaderServiceMock) throws Exception {
        GlobalVariables.getMessageMap().clearErrorMessages();
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        try (MockedStatic kradServiceLocatorWebMockedStatic = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            kradServiceLocatorWebMockedStatic.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            this.reqsDocumentSpy = (RequisitionDocument)Mockito.spy(RequisitionDocument.class);
        }
        Mockito.when((Object)this.reqsDocumentSpy.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        Mockito.when((Object)this.reqsDocumentSpy.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        this.cutSpy = (TestableRequisitionAccountingLineAccessibleValidation)((Object)Mockito.spy((Object)((Object)new TestableRequisitionAccountingLineAccessibleValidation())));
        this.cutSpy.setAccountingDocumentForValidation((AccountingDocument)this.reqsDocumentSpy);
        this.cutSpy.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cutSpy.setDocumentDictionaryService(this.documentDictionarySvcMock);
        ((TestableRequisitionAccountingLineAccessibleValidation)((Object)Mockito.doReturn((Object)this.accountingLineAuthorizerMock).when((Object)this.cutSpy))).lookupAccountingLineAuthorizer();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private static AccountingLine setupAccountingLine(RequisitionAccount accountingLine, String financialObjectCode) {
        Mockito.when((Object)accountingLine.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)accountingLine.getAccountNumber()).thenReturn((Object)"1031400");
        Mockito.when((Object)accountingLine.getFinancialObjectCode()).thenReturn((Object)financialObjectCode);
        Mockito.when((Object)accountingLine.getValuesMap()).thenCallRealMethod();
        return accountingLine;
    }

    @Test
    void validate_onlyUpdatedObjectCode_VALID(@Mock(stubOnly=true) RequisitionAccount accountingLine1Mock, @Mock(stubOnly=true) RequisitionAccount accountingLine2Mock, @Mock(stubOnly=true) UserSession userSessionMock, @Mock(stubOnly=true) PersistenceStructureService persistenceStructureServiceMock) {
        boolean actual;
        this.accountingLineForValidationMock = RequisitionAccountingLineAccessibleValidationTest.setupAccountingLine(accountingLine1Mock, "5000");
        Mockito.when((Object)this.accountingLineForValidationMock.isLike((AccountingLine)ArgumentMatchers.any())).thenCallRealMethod();
        this.updatedAccountingLineForValidationMock = RequisitionAccountingLineAccessibleValidationTest.setupAccountingLine(accountingLine2Mock, "7000");
        this.event = new UpdateAccountingLineEvent("", (Document)this.reqsDocumentSpy, this.accountingLineForValidationMock, this.updatedAccountingLineForValidationMock);
        this.cutSpy.setAccountingLineForValidation(this.accountingLineForValidationMock);
        Mockito.when((Object)this.accountingLineAuthorizerMock.hasEditPermissionOnField((AccountingDocument)this.reqsDocumentSpy, this.accountingLineForValidationMock, "items.sourceAccountingLines", "accountNumber", false, true, this.personMock, new HashSet())).thenReturn((Object)false);
        Mockito.when((Object)this.accountingLineAuthorizerMock.hasEditPermissionOnField((AccountingDocument)this.reqsDocumentSpy, this.accountingLineForValidationMock, "items.sourceAccountingLines", "financialObjectCode", false, true, this.personMock, new HashSet())).thenReturn((Object)true);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic kradServiceLocatorMockedStatic = Mockito.mockStatic(KRADServiceLocator.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)this.personMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            kradServiceLocatorMockedStatic.when(KRADServiceLocator::getPersistenceStructureService).thenReturn((Object)persistenceStructureServiceMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)this.accountSvcMock);
            actual = this.cutSpy.validate((AttributedDocumentEvent)this.event);
        }
        Assertions.assertTrue((boolean)actual);
    }

    @Test
    void validate_onlyUpdatedPostingYear_VALID(@Mock(stubOnly=true) RequisitionAccount accountingLine1Mock, @Mock(stubOnly=true) RequisitionAccount accountingLine2Mock, @Mock(stubOnly=true) UserSession userSessionMock, @Mock(stubOnly=true) PersistenceStructureService persistenceStructureServiceMock) {
        boolean actual;
        this.accountingLineForValidationMock = RequisitionAccountingLineAccessibleValidationTest.setupAccountingLine(accountingLine1Mock, "5000");
        Mockito.when((Object)this.accountingLineForValidationMock.isLike((AccountingLine)ArgumentMatchers.any())).thenCallRealMethod();
        this.updatedAccountingLineForValidationMock = RequisitionAccountingLineAccessibleValidationTest.setupAccountingLine(accountingLine2Mock, "7000");
        this.event = new UpdateAccountingLineEvent("", (Document)this.reqsDocumentSpy, this.accountingLineForValidationMock, this.updatedAccountingLineForValidationMock);
        this.cutSpy.setAccountingLineForValidation(this.accountingLineForValidationMock);
        Mockito.when((Object)this.accountingLineForValidationMock.getPostingYear()).thenReturn((Object)2022);
        Mockito.when((Object)this.updatedAccountingLineForValidationMock.getPostingYear()).thenReturn((Object)2021);
        Mockito.when((Object)this.updatedAccountingLineForValidationMock.getFinancialObjectCode()).thenReturn((Object)"5000");
        Mockito.when((Object)this.documentDictionarySvcMock.getDocumentAuthorizer((Document)this.reqsDocumentSpy)).thenReturn((Object)this.documentAuthorizerMock);
        Mockito.when((Object)this.personMock.getPrincipalId()).thenReturn((Object)"9999999");
        Mockito.when((Object)this.documentAuthorizerMock.isAuthorized((Object)this.reqsDocumentSpy, "KFS-SYS", "Edit Accounting Period", this.personMock.getPrincipalId())).thenReturn((Object)true);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic kradServiceLocatorMockedStatic = Mockito.mockStatic(KRADServiceLocator.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)this.personMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            kradServiceLocatorMockedStatic.when(KRADServiceLocator::getPersistenceStructureService).thenReturn((Object)persistenceStructureServiceMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)this.accountSvcMock);
            actual = this.cutSpy.validate((AttributedDocumentEvent)this.event);
        }
        Assertions.assertTrue((boolean)actual);
    }

    @Test
    void validate_moreThanObjectCodeChanged_INVALID(@Mock(stubOnly=true) RequisitionAccount accountingLine1Mock, @Mock(stubOnly=true) RequisitionAccount accountingLine2Mock, @Mock(stubOnly=true) UserSession userSessionMock, @Mock(stubOnly=true) PersistenceStructureService persistenceStructureServiceMock) {
        this.accountingLineForValidationMock = RequisitionAccountingLineAccessibleValidationTest.setupAccountingLine(accountingLine1Mock, "5000");
        Mockito.when((Object)this.accountingLineForValidationMock.isLike((AccountingLine)ArgumentMatchers.any())).thenCallRealMethod();
        this.updatedAccountingLineForValidationMock = RequisitionAccountingLineAccessibleValidationTest.setupAccountingLine(accountingLine2Mock, "7000");
        this.event = new UpdateAccountingLineEvent("", (Document)this.reqsDocumentSpy, this.accountingLineForValidationMock, this.updatedAccountingLineForValidationMock);
        this.cutSpy.setAccountingLineForValidation(this.accountingLineForValidationMock);
        Mockito.when((Object)this.updatedAccountingLineForValidationMock.getChartOfAccountsCode()).thenReturn((Object)"BA");
        Mockito.when((Object)this.accountingLineAuthorizerMock.hasEditPermissionOnField((AccountingDocument)this.reqsDocumentSpy, this.accountingLineForValidationMock, "items.sourceAccountingLines", "accountNumber", false, true, this.personMock, new HashSet())).thenReturn((Object)false);
        Mockito.when((Object)this.accountingLineAuthorizerMock.hasEditPermissionOnField((AccountingDocument)this.reqsDocumentSpy, this.accountingLineForValidationMock, "items.sourceAccountingLines", "financialObjectCode", false, true, this.personMock, new HashSet())).thenReturn((Object)true);
        Mockito.when((Object)this.documentDictionarySvcMock.getDocumentAuthorizer((Document)this.reqsDocumentSpy)).thenReturn((Object)this.documentAuthorizerMock);
        Mockito.when((Object)this.personMock.getPrincipalId()).thenReturn((Object)"9999999");
        Mockito.when((Object)this.documentAuthorizerMock.isAuthorized((Object)this.reqsDocumentSpy, "KFS-SYS", "Edit Accounting Period", this.personMock.getPrincipalId())).thenReturn((Object)false);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic kradServiceLocatorMockedStatic = Mockito.mockStatic(KRADServiceLocator.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)this.personMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            MessageMap messageMap = new MessageMap();
            globalVariablesMockedStatic.when(GlobalVariables::getMessageMap).thenReturn((Object)messageMap);
            kradServiceLocatorMockedStatic.when(KRADServiceLocator::getPersistenceStructureService).thenReturn((Object)persistenceStructureServiceMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)this.accountSvcMock);
            boolean actual = this.cutSpy.validate((AttributedDocumentEvent)this.event);
            Assertions.assertFalse((boolean)actual);
            Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
            ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("accountNumber")).get(0);
            Assertions.assertEquals((Object)"error.accountingLine.inaccessibleUpdate", (Object)errorMessage.getErrorKey());
            String[] messageParameters = errorMessage.getMessageParameters();
            Assertions.assertEquals((int)3, (int)messageParameters.length);
            Assertions.assertNull((Object)messageParameters[0]);
            Assertions.assertEquals((Object)"BL-1031400", (Object)messageParameters[1]);
            Assertions.assertNull((Object)messageParameters[2]);
        }
    }

    @Test
    void validate_moreThanPostingYearChanged_INVALID(@Mock(stubOnly=true) RequisitionAccount accountingLine1Mock, @Mock(stubOnly=true) RequisitionAccount accountingLine2Mock, @Mock(stubOnly=true) UserSession userSessionMock, @Mock(stubOnly=true) PersistenceStructureService persistenceStructureServiceMock) {
        this.accountingLineForValidationMock = RequisitionAccountingLineAccessibleValidationTest.setupAccountingLine(accountingLine1Mock, "5000");
        Mockito.when((Object)this.accountingLineForValidationMock.isLike((AccountingLine)ArgumentMatchers.any())).thenCallRealMethod();
        this.updatedAccountingLineForValidationMock = RequisitionAccountingLineAccessibleValidationTest.setupAccountingLine(accountingLine2Mock, "7000");
        this.event = new UpdateAccountingLineEvent("", (Document)this.reqsDocumentSpy, this.accountingLineForValidationMock, this.updatedAccountingLineForValidationMock);
        this.cutSpy.setAccountingLineForValidation(this.accountingLineForValidationMock);
        Mockito.when((Object)this.updatedAccountingLineForValidationMock.getChartOfAccountsCode()).thenReturn((Object)"BA");
        Mockito.when((Object)this.accountingLineForValidationMock.getPostingYear()).thenReturn((Object)2022);
        Mockito.when((Object)this.updatedAccountingLineForValidationMock.getPostingYear()).thenReturn((Object)2021);
        Mockito.when((Object)this.documentDictionarySvcMock.getDocumentAuthorizer((Document)this.reqsDocumentSpy)).thenReturn((Object)this.documentAuthorizerMock);
        Mockito.when((Object)this.personMock.getPrincipalId()).thenReturn((Object)"9999999");
        Mockito.when((Object)this.documentAuthorizerMock.isAuthorized((Object)this.reqsDocumentSpy, "KFS-SYS", "Edit Accounting Period", this.personMock.getPrincipalId())).thenReturn((Object)true);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic kradServiceLocatorMockedStatic = Mockito.mockStatic(KRADServiceLocator.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)this.personMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            MessageMap messageMap = new MessageMap();
            globalVariablesMockedStatic.when(GlobalVariables::getMessageMap).thenReturn((Object)messageMap);
            kradServiceLocatorMockedStatic.when(KRADServiceLocator::getPersistenceStructureService).thenReturn((Object)persistenceStructureServiceMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)this.accountSvcMock);
            boolean actual = this.cutSpy.validate((AttributedDocumentEvent)this.event);
            Assertions.assertFalse((boolean)actual);
            Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
            ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("accountNumber")).get(0);
            Assertions.assertEquals((Object)"error.accountingLine.inaccessibleUpdate", (Object)errorMessage.getErrorKey());
            String[] messageParameters = errorMessage.getMessageParameters();
            Assertions.assertEquals((int)3, (int)messageParameters.length);
            Assertions.assertNull((Object)messageParameters[0]);
            Assertions.assertEquals((Object)"BL-1031400", (Object)messageParameters[1]);
            Assertions.assertNull((Object)messageParameters[2]);
        }
    }

    public static class TestableRequisitionAccountingLineAccessibleValidation
    extends RequisitionAccountingLineAccessibleValidation {
        protected AccountingLineAuthorizer lookupAccountingLineAuthorizer() {
            return null;
        }
    }
}

