/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoItemQuantityValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class VendorCreditMemoItemQuantityValidationTest {
    private VendorCreditMemoItemQuantityValidation cut;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private VendorCreditMemoDocument creditMemoDocMock;

    VendorCreditMemoItemQuantityValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.setupCreditMemoDocMock();
        this.cut = new VendorCreditMemoItemQuantityValidation();
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private void setupCreditMemoDocMock() {
        CreditMemoItem item = new CreditMemoItem();
        item.setItemLineNumber(Integer.valueOf(1));
        item.setItemTypeCode("ITEM");
        ItemType itemType = new ItemType();
        itemType.setItemTypeCode("ITEM");
        itemType.setQuantityBasedGeneralLedgerIndicator(true);
        item.setItemType(itemType);
        item.setExtendedPrice(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(1));
        Mockito.when((Object)this.creditMemoDocMock.getItemByLineNumber(1)).thenReturn((Object)item);
    }

    @Test
    void validate_POType_EquivalentQuantity() {
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPoInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(1));
        this.cut.setItemForValidation(item);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    void validate_PREQType_EquivalentQuantity() {
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(1));
        this.cut.setItemForValidation(item);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    void validate_POType_NullQuantity() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(CreditMemoItem.class, "itemQuantity")).thenReturn((Object)"Quantity");
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPoInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(null);
        this.cut.setItemForValidation(item);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.item[0].itemQuantity", "error.required"));
    }

    @Test
    void validate_PREQType_NullQuantity() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(CreditMemoItem.class, "itemQuantity")).thenReturn((Object)"Quantity");
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(null);
        this.cut.setItemForValidation(item);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.item[0].itemQuantity", "error.required"));
    }

    @Test
    void validate_POType_NegativeQuantity() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(CreditMemoItem.class, "itemQuantity")).thenReturn((Object)"Quantity");
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPoInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(-1));
        this.cut.setItemForValidation(item);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.creditMemo.itemAmount.aboveZero"));
    }

    @Test
    void validate_PREQType_NegativeQuantity() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(CreditMemoItem.class, "itemQuantity")).thenReturn((Object)"Quantity");
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(-1));
        this.cut.setItemForValidation(item);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.creditMemo.itemAmount.aboveZero"));
    }

    @Test
    void validate_POType_GreaterQuantity() {
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPoInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(2));
        this.cut.setItemForValidation(item);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.creditMemo.item.quantity.tooMuch"));
    }

    @Test
    void validate_PREQType_GreaterQuantity() {
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(2));
        this.cut.setItemForValidation(item);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.creditMemo.item.quantity.tooMuch"));
    }
}

