/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoTotalMatchesVendorAmountValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class VendorCreditMemoTotalMatchesVendorAmountValidationTest {
    private static final ErrorMessage EXPECTED_ERROR_MESSAGE = new ErrorMessage("errors.creditMemo.vendorInvoiceAmount.invalid", new String[0]);
    private VendorCreditMemoTotalMatchesVendorAmountValidation cut;

    VendorCreditMemoTotalMatchesVendorAmountValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new VendorCreditMemoTotalMatchesVendorAmountValidation();
        KNSGlobalVariables.getMessageList().clear();
    }

    @AfterEach
    void tearDown() {
        KNSGlobalVariables.getMessageList().clear();
    }

    @Test
    void validate_GrandTotalMatchesAmount_isUseTax(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)creditMemoDocMock.getGrandPreTaxTotal()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)creditMemoDocMock.isUseTaxIndicator()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
    }

    @Test
    void validate_GrandTotalGreaterThanAmount_isUseTax(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)creditMemoDocMock.getGrandPreTaxTotal()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)creditMemoDocMock.isUseTaxIndicator()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
        Assertions.assertTrue((boolean)KNSGlobalVariables.getMessageList().contains((Object)EXPECTED_ERROR_MESSAGE));
    }

    @Test
    void validate_AmountGreaterThanGrandTotal_isUseTax(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)creditMemoDocMock.getGrandPreTaxTotal()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)creditMemoDocMock.isUseTaxIndicator()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
        Assertions.assertTrue((boolean)KNSGlobalVariables.getMessageList().contains((Object)EXPECTED_ERROR_MESSAGE));
    }

    @Test
    void validate_GrandTotalGreaterThanAmount_isUseTax_isUnmatchedOverride(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)creditMemoDocMock.getGrandPreTaxTotal()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)creditMemoDocMock.isUseTaxIndicator()).thenReturn((Object)true);
        Mockito.when((Object)creditMemoDocMock.isUnmatchedOverride()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
    }

    @Test
    void validate_AmountGreaterThanGrandTotal_isUseTax_isUnmatchedOverride(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)creditMemoDocMock.getGrandPreTaxTotal()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)creditMemoDocMock.isUseTaxIndicator()).thenReturn((Object)true);
        Mockito.when((Object)creditMemoDocMock.isUnmatchedOverride()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
    }

    @Test
    void validate_GrandTotalMatchesAmount(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(32));
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
    }

    @Test
    void validate_GrandTotalGreaterThanAmount(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(32));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
        Assertions.assertTrue((boolean)KNSGlobalVariables.getMessageList().contains((Object)EXPECTED_ERROR_MESSAGE));
    }

    @Test
    void validate_AmountGreaterThanGrandTotal(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(16));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
        Assertions.assertTrue((boolean)KNSGlobalVariables.getMessageList().contains((Object)EXPECTED_ERROR_MESSAGE));
    }

    @Test
    void validate_GrandTotalGreaterThanAmount_isUnmatchedOverride(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)creditMemoDocMock.isUnmatchedOverride()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
    }

    @Test
    void validate_AmountGreaterThanGrandTotal_isUnmatchedOverride(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)creditMemoDocMock.isUnmatchedOverride()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
    }
}

