/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import java.math.BigDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;

public enum PaymentRequestTaxTabFixture {
    INCOME_EMPTY(null, null, null, null, null, null, null, null, null, null, null, "Awaiting Tax Approval"),
    INCOME_N_OTHERS_EMPTY("N", null, null, null, null, null, null, null, null, null, null, "Awaiting Tax Approval"),
    INCOME_N_OTHERS_NOTEMPTY("N", new BigDecimal(1), new BigDecimal(1), "US", "1234567890", null, true, null, null, null, null, "Awaiting Tax Approval"),
    INCOME_NOTN_TAX_COUNTRY_EMPTY("O", null, null, null, null, null, null, null, null, null, null, "Awaiting Tax Approval"),
    INCOME_F_TAX_VALID("F", new BigDecimal(14), new BigDecimal("3.4"), "US", "1234567890", null, null, null, null, null, null, "Awaiting Tax Approval"),
    INCOME_F_FED_INVALID("F", new BigDecimal(15), new BigDecimal("3.4"), "US", "1234567890", null, null, null, null, null, null, "Awaiting Tax Approval"),
    INCOME_F_ST_INVALID("F", new BigDecimal(30), new BigDecimal(1), "US", "1234567890", null, null, null, null, null, null, "Awaiting Tax Approval"),
    INCOME_I_TAX_VALID("I", new BigDecimal(30), new BigDecimal(0), "US", "1234567890", null, null, null, null, null, null, "Awaiting Tax Approval"),
    INCOME_I_FED_INVALID("I", new BigDecimal(10), new BigDecimal(0), "US", "1234567890", null, null, null, null, null, null, "Awaiting Tax Approval"),
    INCOME_I_ST_INVALID("I", new BigDecimal(30), new BigDecimal(1), "US", "1234567890", null, null, null, null, null, null, "Awaiting Tax Approval"),
    INCOME_R_TAX_VALID("R", new BigDecimal(10), new BigDecimal(0), "US", "1234567890", null, null, null, null, null, null, "Awaiting Tax Approval"),
    INCOME_R_FED_INVALID("R", new BigDecimal(14), new BigDecimal(0), "US", "1234567890", null, null, null, null, null, null, "Awaiting Tax Approval"),
    INCOME_R_ST_INVALID("R", new BigDecimal(10), new BigDecimal(1), "US", "1234567890", null, null, null, null, null, null, "Awaiting Tax Approval"),
    FED_ZERO_ST_ZERO("F", new BigDecimal(0), new BigDecimal(0), "US", "1234567890", null, null, null, null, null, null, "Awaiting Tax Approval"),
    FFD_ZERO_ST_NOTZERO("F", new BigDecimal(0), new BigDecimal("3.4"), "US", "1234567890", null, null, null, null, null, null, "Awaiting Tax Approval"),
    FED_NOTZERO_ST_ZERO("F", new BigDecimal(30), new BigDecimal(0), "US", "1234567890", null, null, null, null, null, null, "Awaiting Tax Approval"),
    GROSS_TAX_NOTZERO("R", new BigDecimal(30), new BigDecimal(0), "US", "1234567890", null, null, true, null, null, null, "Awaiting Tax Approval"),
    GROSS_TAX_ZERO("R", new BigDecimal(0), new BigDecimal(0), "US", "1234567890", null, null, true, null, null, null, "Awaiting Tax Approval"),
    FOREIGN_TAX_ZERO("F", new BigDecimal(0), new BigDecimal(0), "US", "1234567890", null, null, null, true, null, null, "Awaiting Tax Approval"),
    FOREIGN_TAX_NOTZERO("F", new BigDecimal(30), new BigDecimal("3.4"), "US", "1234567890", null, null, null, true, null, null, "Awaiting Tax Approval"),
    USAID_OTHER_INCOME_F_TAX_ZERO("F", new BigDecimal(0), new BigDecimal(0), "US", "1234567890", null, null, null, null, true, true, "Awaiting Tax Approval"),
    USAID_INCOME_NOTF_TAX_NOTZERO("R", new BigDecimal(10), new BigDecimal(0), "US", "1234567890", null, null, null, null, true, null, "Awaiting Tax Approval"),
    OTHER_TAX_ZERO("I", new BigDecimal(0), new BigDecimal(0), "US", "1234567890", null, null, null, null, null, true, "Awaiting Tax Approval"),
    OTHER_TAX_NOTZERO("I", new BigDecimal(30), new BigDecimal(0), "US", "1234567890", null, null, null, null, null, true, "Awaiting Tax Approval"),
    SW4_INCOME_F_TAX_ZERO("F", new BigDecimal(0), new BigDecimal(0), "US", "1234567890", new KualiDecimal(1), null, null, null, null, null, "Awaiting Tax Approval"),
    SW4_NEG_INCOME_NOTF_TAX_NOTZERO("R", new BigDecimal(10), new BigDecimal(0), "US", "1234567890", new KualiDecimal(-1), null, null, null, null, null, "Awaiting Tax Approval"),
    SW4_TREATY_GROSS_FOREIGN_USAID_OTHER("F", new BigDecimal(0), new BigDecimal(0), "US", "1234567890", new KualiDecimal(1), true, true, true, true, true, "Awaiting Tax Approval");

    private final String taxClassificationCode;
    private final BigDecimal federalTaxPercent;
    private final BigDecimal stateTaxPercent;
    private final String taxCountryCode;
    private final String taxNQIId;
    private final KualiDecimal taxSpecialW4Amount;
    private final Boolean taxExemptTreatyIndicator;
    private final Boolean grossUpIndicator;
    private final Boolean foreignSourceIndicator;
    private final Boolean taxUSAIDPerDiemIndicator;
    private final Boolean otherTaxExemptIndicator;
    private final String statusCode;

    private PaymentRequestTaxTabFixture(String taxClassificationCode, BigDecimal federalTaxPercent, BigDecimal stateTaxPercent, String taxCountryCode, String taxNQIId, KualiDecimal taxSpecialW4Amount, Boolean taxExemptTreatyIndicator, Boolean grossUpIndicator, Boolean foreignSourceIndicator, Boolean taxUSAIDPerDiemIndicator, Boolean otherTaxExemptIndicator, String statusCode) {
        this.taxClassificationCode = taxClassificationCode;
        this.federalTaxPercent = federalTaxPercent;
        this.stateTaxPercent = stateTaxPercent;
        this.taxCountryCode = taxCountryCode;
        this.taxNQIId = taxNQIId;
        this.taxSpecialW4Amount = taxSpecialW4Amount;
        this.taxExemptTreatyIndicator = taxExemptTreatyIndicator;
        this.grossUpIndicator = grossUpIndicator;
        this.foreignSourceIndicator = foreignSourceIndicator;
        this.taxUSAIDPerDiemIndicator = taxUSAIDPerDiemIndicator;
        this.otherTaxExemptIndicator = otherTaxExemptIndicator;
        this.statusCode = statusCode;
    }

    public PaymentRequestDocument populate(PaymentRequestDocument preqDocument) {
        preqDocument.setTaxClassificationCode(this.taxClassificationCode);
        preqDocument.setTaxFederalPercent(this.federalTaxPercent);
        preqDocument.setTaxStatePercent(this.stateTaxPercent);
        preqDocument.setTaxCountryCode(this.taxCountryCode);
        preqDocument.setTaxNQIId(this.taxNQIId);
        preqDocument.setTaxSpecialW4Amount(this.taxSpecialW4Amount);
        preqDocument.setTaxExemptTreatyIndicator(this.taxExemptTreatyIndicator);
        preqDocument.setTaxGrossUpIndicator(this.grossUpIndicator);
        preqDocument.setTaxForeignSourceIndicator(this.foreignSourceIndicator);
        preqDocument.setTaxUSAIDPerDiemIndicator(this.taxUSAIDPerDiemIndicator);
        preqDocument.setTaxOtherExemptIndicator(this.otherTaxExemptIndicator);
        preqDocument.setApplicationDocumentStatus(this.statusCode);
        return preqDocument;
    }
}

