/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.fixture.PurApItemFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionAccountingLineFixture;
import org.kuali.kfs.vnd.businessobject.CommodityCode;
import org.kuali.kfs.vnd.fixture.CommodityCodeFixture;

public enum RequisitionItemFixture {
    REQ_QTY_UNRESTRICTED_ITEM_1(false, PurApItemFixture.BASIC_QTY_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_QTY_UNRESTRICTED_ITEM_2(false, PurApItemFixture.BASIC_QTY_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_2}),
    REQ_QTY_UNRESTRICTED_ITEM_3(false, PurApItemFixture.BASIC_QTY_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.APO_REQ_ACCOUNT_2, RequisitionAccountingLineFixture.APO_REQ_ACCOUNT_3}),
    REQ_QTY_ITEM_NEGATIVE_AMOUNT(false, PurApItemFixture.BASIC_QTY_ITEM_NEGATIVE, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.REQ_ACCOUNT_NEGATIVE_AMOUNT}),
    REQ_QTY_APO_ITEM_1(false, PurApItemFixture.APO_QTY_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.APO_REQ_ACCOUNT_1}),
    REQ_SERVICE_APO_ITEM_1(false, PurApItemFixture.APO_SERVICE_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.APO_REQ_ACCOUNT_2, RequisitionAccountingLineFixture.APO_REQ_ACCOUNT_3}),
    REQ_FREIGHT_ITEM_1(false, PurApItemFixture.APO_FREIGHT_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.APO_REQ_ACCOUNT_4}),
    REQ_MULTI_ITEM_QUANTITY(false, PurApItemFixture.REQ_MULTI_ITEM_QUANTITY, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.REQ_ACCOUNT_MULTI_QUANTITY}),
    REQ_MULTI_ITEM_NON_QUANTITY(false, PurApItemFixture.REQ_MULTI_ITEM_NON_QUANTITY, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.REQ_ACCOUNT_MULTI_NON_QUANTITY}),
    REQ_ITEM_NO_APO(false, PurApItemFixture.BASIC_QTY_ITEM_NO_APO, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_ITEM_NO_APO_2(false, PurApItemFixture.BASIC_QTY_ITEM_NO_APO, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_2}),
    REQ_ITEM_PERFORMANCE(false, PurApItemFixture.BASIC_QTY_ITEM_PERFORMANCE, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.PERFORMANCE_ACCOUNT}),
    REQ_ITEM_NO_APO_TOTAL_NOT_GREATER_THAN_ZERO(false, PurApItemFixture.BASIC_QTY_ITEM_NO_APO_TOTAL_NOT_GREATER_THAN_ZERO, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_ITEM_NO_APO_RESTRICTED_ITEM(true, PurApItemFixture.APO_QTY_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.APO_REQ_ACCOUNT_1}),
    REQ_ITEM_NO_APO_CONTAIN_RESTRICTED_ITEM(true, PurApItemFixture.BASIC_QTY_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_VALID_FREIGHT_ITEM(false, PurApItemFixture.VALID_FREIGHT_ITEM, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_VALID_SHIPPING_AND_HANDLING_ITEM(false, PurApItemFixture.VALID_SHIPPING_AND_HANDLING_ITEM, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_WITH_MISC_CREDIT_ITEM(false, PurApItemFixture.VALID_MISC_CREDIT_ITEM, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_WITH_NEGATIVE_FREIGHT_ITEM(false, PurApItemFixture.NEGATIVE_FREIGHT_ITEM, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_WITH_NEGATIVE_SHIPPING_AND_HANDLING_ITEM(false, PurApItemFixture.NEGATIVE_SHIPPING_AND_HANDLING_ITEM, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_WITH_ZERO_FREIGHT_ITEM(false, PurApItemFixture.ZERO_FREIGHT_ITEM, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_WITH_ZERO_SHIPPING_AND_HANDLING_ITEM(false, PurApItemFixture.ZERO_SHIPPING_AND_HANDLING_ITEM, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_WITH_MISC_ITEM_NO_DESC(false, PurApItemFixture.MISC_ITEM_NO_DESC, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_ITEM_NO_APO_BASIC_ACTIVE_COMMODITY_CODE(false, PurApItemFixture.BASIC_QTY_ITEM_NO_APO, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}, CommodityCodeFixture.COMMODITY_CODE_BASIC_ACTIVE),
    REQ_ITEM_NO_APO_BASIC_INACTIVE_COMMODITY_CODE(false, PurApItemFixture.BASIC_QTY_ITEM_NO_APO, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}, CommodityCodeFixture.COMMODITY_CODE_BASIC_INACTIVE),
    REQ_ITEM_NO_APO_NON_EXISTENCE_COMMODITY_CODE(false, PurApItemFixture.BASIC_QTY_ITEM_NO_APO, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}, CommodityCodeFixture.COMMODITY_CODE_NON_EXISTENCE),
    REQ_ITEM_APO_BASIC_INACTIVE_COMMODITY_CODE(false, PurApItemFixture.APO_QTY_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}, CommodityCodeFixture.COMMODITY_CODE_BASIC_INACTIVE),
    REQ_ITEM_APO_COMMODITY_CODE_WITH_SENSITIVE_DATA(false, PurApItemFixture.APO_QTY_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}, CommodityCodeFixture.COMMODITY_CODE_WITH_SENSITIVE_DATA),
    REQ_ITEM_INVALID_QUANTITY_BASED_NO_QUANTITY(false, PurApItemFixture.INVALID_QTY_ITEM_NULL_QUANTITY, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1}),
    REQ_ITEM_VALID_CAPITAL_ASSET(false, PurApItemFixture.APO_QTY_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.APO_ACCOUNT_VALID_CAPITAL_ASSET_OBJECT_CODE}),
    REQ_ITEM_INVALID_CAPITAL_ASSET(false, PurApItemFixture.APO_QTY_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.APO_ACCOUNT_VALID_CAPITAL_ASSET_OBJECT_CODE_50_PERCENT, RequisitionAccountingLineFixture.APO_ACCOUNT_VALID_EXPENSE_OBJECT_CODE_50_PERCENT}),
    REQ_QTY_B2B_ITEM_1(false, PurApItemFixture.BASIC_B2B_QTY_ITEM_1, new RequisitionAccountingLineFixture[]{RequisitionAccountingLineFixture.BASIC_REQ_ACCOUNT_1});

    private final boolean itemRestrictedIndicator;
    private final PurApItemFixture purApItemFixture;
    private final RequisitionAccountingLineFixture[] requisitionAccountingLineFixtures;
    private CommodityCodeFixture commodityCodeFixture;

    private RequisitionItemFixture(boolean itemRestrictedIndicator, PurApItemFixture purApItemFixture, RequisitionAccountingLineFixture[] requisitionAccountingLineFixtures) {
        this.itemRestrictedIndicator = itemRestrictedIndicator;
        this.purApItemFixture = purApItemFixture;
        this.requisitionAccountingLineFixtures = requisitionAccountingLineFixtures;
    }

    private RequisitionItemFixture(boolean itemRestrictedIndicator, PurApItemFixture purApItemFixture, RequisitionAccountingLineFixture[] requisitionAccountingLineFixtures, CommodityCodeFixture commodityCodeFixture) {
        this.itemRestrictedIndicator = itemRestrictedIndicator;
        this.purApItemFixture = purApItemFixture;
        this.requisitionAccountingLineFixtures = requisitionAccountingLineFixtures;
        this.commodityCodeFixture = commodityCodeFixture;
    }

    public void addTo(RequisitionDocument requisitionDocument) {
        RequisitionItem item = null;
        boolean active = true;
        boolean restrictedItemsIndicator = true;
        item = (RequisitionItem)this.createRequisitionItem();
        if (item.getCommodityCode() != null) {
            active = item.getCommodityCode().isActive();
            restrictedItemsIndicator = item.getCommodityCode().isRestrictedItemsIndicator();
        }
        requisitionDocument.addItem((PurApItem)item);
        if (ObjectUtils.isNotNull((Object)item.getCommodityCode())) {
            item.getCommodityCode().setActive(active);
            item.getCommodityCode().setRestrictedItemsIndicator(restrictedItemsIndicator);
        }
        for (RequisitionAccountingLineFixture requisitionAccountMultiFixture : this.requisitionAccountingLineFixtures) {
            requisitionAccountMultiFixture.addTo(item);
        }
    }

    public PurchasingItem createRequisitionItem() {
        RequisitionItem item = (RequisitionItem)this.purApItemFixture.createPurApItem(RequisitionItem.class);
        item.setItemRestrictedIndicator(this.itemRestrictedIndicator);
        if (this.commodityCodeFixture != null) {
            CommodityCode commodityCode = this.commodityCodeFixture.createCommodityCode();
            item.setCommodityCode(commodityCode);
            item.setPurchasingCommodityCode(commodityCode.getPurchasingCommodityCode());
        }
        return item;
    }

    public PurchasingItem createRequisitionItemForCapitalAsset() {
        RequisitionItem item = (RequisitionItem)this.createRequisitionItem();
        if (this.requisitionAccountingLineFixtures.length > 0) {
            for (RequisitionAccountingLineFixture fixture : this.requisitionAccountingLineFixtures) {
                fixture.addTo(item);
            }
        }
        return item;
    }
}

