/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderSensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignment;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignmentDetail;
import org.kuali.kfs.module.purap.dataaccess.SensitiveDataDao;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.purap.fixture.SensitiveDataFixture;
import org.kuali.kfs.module.purap.service.SensitiveDataService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

public class SensitiveDataServiceIntegTest
extends KualiIntegTestBase {
    private BusinessObjectService boService;
    private SensitiveDataService sdService;
    private PurchaseOrderDocument po;
    private SensitiveData sdNew;

    protected void setUp() throws Exception {
        super.setUp();
        if (this.boService == null) {
            this.boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        }
        if (this.sdService == null) {
            this.sdService = (SensitiveDataService)SpringContext.getBean(SensitiveDataService.class);
        }
        if (this.po == null) {
            this.po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        }
        if (this.po.getPurapDocumentIdentifier() == null) {
            this.po.setPurapDocumentIdentifier(Integer.valueOf(9001));
        }
        if (this.po.getRequisitionIdentifier() == null) {
            this.po.setRequisitionIdentifier(Integer.valueOf(9001));
        }
        if (this.sdNew == null) {
            this.sdNew = SensitiveDataFixture.SENSITIVE_DATA_ACTIVE.getSensitiveDataBO();
        }
        if (this.boService.retrieve((PersistableBusinessObject)this.sdNew) == null) {
            this.boService.save((PersistableBusinessObject)this.sdNew);
        }
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public void testGetSensitiveData() {
        List sds = this.sdService.getAllSensitiveDatas();
        SensitiveDataServiceIntegTest.assertTrue((sds.size() > 0 ? 1 : 0) != 0);
        String code = this.sdNew.getSensitiveDataCode();
        SensitiveData sdRet = this.sdService.getSensitiveDataByCode(code);
        SensitiveDataServiceIntegTest.assertNotNull((Object)sdRet);
        SensitiveDataServiceIntegTest.assertTrue((boolean)sdRet.getSensitiveDataCode().equalsIgnoreCase(code));
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public void testSensitiveDataAssignment() {
        Integer poId = this.po.getPurapDocumentIdentifier();
        String reason = "test";
        String userId = "parke";
        Date date = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
        List sds = this.sdService.getAllSensitiveDatas();
        SensitiveDataAssignment sda = new SensitiveDataAssignment();
        sda.setPurapDocumentIdentifier(poId);
        sda.setSensitiveDataAssignmentReasonText("test");
        sda.setSensitiveDataAssignmentChangeDate((java.util.Date)date);
        sda.setSensitiveDataAssignmentPersonIdentifier("parke");
        this.boService.save((PersistableBusinessObject)sda);
        SensitiveDataAssignment sdaRet = this.sdService.getLastSensitiveDataAssignment(poId);
        SensitiveDataServiceIntegTest.assertEquals((Object)sdaRet.getPurapDocumentIdentifier(), (Object)poId);
        SensitiveDataServiceIntegTest.assertEquals((String)sdaRet.getSensitiveDataAssignmentReasonText(), (String)"test");
        SensitiveDataServiceIntegTest.assertEquals((String)sdaRet.getSensitiveDataAssignmentPersonIdentifier(), (String)"parke");
        Integer sdaId = sdaRet.getSensitiveDataAssignmentIdentifier();
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put("purapDocumentIdentifier", poId);
        Collection sdas = this.boService.findMatching(SensitiveDataAssignment.class, fieldValues);
        for (Object sdaR : sdas) {
            SensitiveDataServiceIntegTest.assertTrue((sdaId >= sdaR.getSensitiveDataAssignmentIdentifier() ? 1 : 0) != 0);
        }
        ArrayList<SensitiveDataAssignmentDetail> sdads = new ArrayList<SensitiveDataAssignmentDetail>();
        for (SensitiveData sd : sds) {
            SensitiveDataAssignmentDetail sdad = new SensitiveDataAssignmentDetail();
            sdad.setSensitiveDataAssignmentIdentifier(sdaId);
            sdad.setSensitiveDataCode(sd.getSensitiveDataCode());
            sdads.add(sdad);
        }
        this.boService.save(sdads);
        Integer lastSdaId = ((SensitiveDataDao)SpringContext.getBean(SensitiveDataDao.class)).getLastSensitiveDataAssignment(poId).getSensitiveDataAssignmentIdentifier();
        fieldValues.clear();
        fieldValues.put("sensitiveDataAssignmentIdentifier", lastSdaId);
        List sdadsRet = (List)this.boService.findMatching(SensitiveDataAssignmentDetail.class, fieldValues);
        SensitiveDataServiceIntegTest.assertEquals((int)sdadsRet.size(), (int)sdads.size());
        for (SensitiveDataAssignmentDetail sdadR : sdadsRet) {
            SensitiveDataServiceIntegTest.assertEquals((Object)sdadR.getSensitiveDataAssignmentIdentifier(), (Object)lastSdaId);
        }
        this.sdService.deletePurchaseOrderSensitiveDatas(poId);
        List sdsRet = this.sdService.getSensitiveDatasAssignedByPoId(poId);
        SensitiveDataServiceIntegTest.assertEquals((int)0, (int)sdsRet.size());
        ArrayList<PurchaseOrderSensitiveData> posds = new ArrayList<PurchaseOrderSensitiveData>();
        for (SensitiveData sd : sds) {
            PurchaseOrderSensitiveData posd = new PurchaseOrderSensitiveData();
            posd.setPurapDocumentIdentifier(poId);
            posd.setRequisitionIdentifier(this.po.getRequisitionIdentifier());
            posd.setSensitiveDataCode(sd.getSensitiveDataCode());
            posds.add(posd);
        }
        this.boService.save(posds);
        sdsRet = this.sdService.getSensitiveDatasAssignedByPoId(poId);
        SensitiveDataServiceIntegTest.assertEquals((int)sdsRet.size(), (int)posds.size());
    }
}

