/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.math.BigDecimal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PurapGeneralLedgerServiceImplTest {
    private final PurapGeneralLedgerServiceImpl cut = new PurapGeneralLedgerServiceImpl();

    PurapGeneralLedgerServiceImplTest() {
    }

    @Test
    void setOutstandingEncumbranceAmt_givenPercentageWithPrecision_properEncumbranceAmtIsSet(@Mock PurchaseOrderItem purchaseOrderItemMock, @Mock PurchaseOrderAccount purchaseOrderAccountMock) {
        Mockito.when((Object)purchaseOrderAccountMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("6.79"));
        Mockito.when((Object)purchaseOrderItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal("2525.25"));
        KualiDecimal result = this.cut.calculateOutstandingEncumbranceAmt(purchaseOrderItemMock, purchaseOrderAccountMock);
        Assertions.assertEquals((Object)new KualiDecimal("171.46"), (Object)result);
    }
}

