/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountRevisionService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.module.purap.util.SummaryAccount;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class GenerateEntriesCancelCreditMemoTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private VendorCreditMemoDocument creditMemoDocMock;
    @Mock(stubOnly=true)
    private PurchaseOrderDocument poMock;
    @Mock(stubOnly=true)
    private PaymentRequestDocument preqMock;
    @Mock(stubOnly=true)
    private PurapAccountingService purapAccountingSvcMock;
    @Mock(stubOnly=true)
    private GeneralLedgerPendingEntryService glPendingEntrySvcMock;
    @Mock(stubOnly=true)
    private BusinessObjectService boServiceMock;
    @Mock(stubOnly=true)
    private PurchaseOrderService purchaseOrderSvcMock;
    @Mock(stubOnly=true)
    private PurapAccountRevisionService purapAccountRevisionSvcMock;
    private List<CreditMemoItem> cmItems;
    private List<PurchaseOrderItem> poItems;

    GenerateEntriesCancelCreditMemoTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setGeneralLedgerPendingEntryService(this.glPendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setPurchaseOrderService(this.purchaseOrderSvcMock);
        this.cut.setPurapAccountRevisionService(this.purapAccountRevisionSvcMock);
        this.cmItems = new ArrayList<CreditMemoItem>();
        this.poItems = new ArrayList<PurchaseOrderItem>();
    }

    private void execute() {
        this.cut.generateEntriesCancelAccountsPayableDocument((AccountsPayableDocument)this.creditMemoDocMock);
    }

    private void prepareBusinessObjectService() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialSystemOriginationCode", "01");
        fieldValues.put("documentNumber", "1");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, fieldValues)).thenReturn((Object)2);
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(null);
    }

    private void preparePO(String status) {
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1234))).thenReturn((Object)this.poMock);
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)this.poMock))).thenReturn((Object)this.poMock);
        Mockito.when((Object)this.poMock.getApplicationDocumentStatus()).thenReturn((Object)status);
        Mockito.when((Object)this.poMock.getItems()).thenReturn(this.poItems);
    }

    private static PurchaseOrderAccount createPoAccountingLine(PurchaseOrderAccount purchaseOrderAccountMock, double percent, double outstandingAmount, double newOutstandingAmount, Double altAmount, String objectCode) {
        SourceAccountingLine acctString = new SourceAccountingLine();
        acctString.setFinancialObjectCode(objectCode);
        Mockito.when((Object)purchaseOrderAccountMock.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)purchaseOrderAccountMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal(percent));
        Mockito.when((Object)purchaseOrderAccountMock.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(outstandingAmount));
        Mockito.when((Object)purchaseOrderAccountMock.generateSourceAccountingLine()).thenReturn((Object)acctString);
        Mockito.when((Object)purchaseOrderAccountMock.compareTo(ArgumentMatchers.isA(PurchaseOrderAccount.class))).thenReturn((Object)0);
        purchaseOrderAccountMock.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(newOutstandingAmount));
        if (altAmount != null) {
            Mockito.when((Object)purchaseOrderAccountMock.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(newOutstandingAmount));
            purchaseOrderAccountMock.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(altAmount.doubleValue()));
        }
        return purchaseOrderAccountMock;
    }

    private static ItemType createItemType(String code, boolean lineItem, boolean quantityBased) {
        ItemType itemType = new ItemType();
        itemType.setItemTypeCode(code);
        itemType.setQuantityBasedGeneralLedgerIndicator(quantityBased);
        itemType.setAdditionalChargeIndicator(!lineItem);
        return itemType;
    }

    @Test
    void baseCase() {
        this.creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.creditMemoDocMock.isSourceVendor()).thenReturn((Object)true);
        Mockito.when((Object)this.creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.creditMemoDocMock)).thenReturn(null);
        this.execute();
    }

    @Test
    void closedPONoItems() {
        this.creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.creditMemoDocMock.isSourceVendor()).thenReturn((Object)false);
        Mockito.when((Object)this.creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.creditMemoDocMock)).thenReturn(null);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1234))).thenReturn((Object)this.poMock);
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)this.poMock))).thenReturn((Object)this.poMock);
        Mockito.when((Object)this.poMock.getApplicationDocumentStatus()).thenReturn((Object)"Closed");
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.execute();
    }

    @Test
    void closedPOFromPreqNoItems() {
        this.creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.creditMemoDocMock.isSourceVendor()).thenReturn((Object)false);
        Mockito.when((Object)this.creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)false);
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPaymentRequest()).thenReturn((Object)true);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.creditMemoDocMock)).thenReturn(null);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1234))).thenReturn((Object)this.poMock);
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)this.poMock))).thenReturn((Object)this.poMock);
        Mockito.when((Object)this.poMock.getApplicationDocumentStatus()).thenReturn((Object)"Closed");
        Mockito.when((Object)this.creditMemoDocMock.getPaymentRequestDocument()).thenReturn((Object)this.preqMock);
        Mockito.when((Object)this.preqMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.execute();
    }

    @Test
    void closedPOWithItemsNoAccountingLines(@Mock(stubOnly=true) CreditMemoItem item, @Mock(stubOnly=true) PurchaseOrderItem item1, @Mock(stubOnly=true) CreditMemoItem item2, @Mock(stubOnly=true) PurchaseOrderItem item3, @Mock(stubOnly=true) CreditMemoItem item4, @Mock(stubOnly=true) PurchaseOrderItem item5, @Mock(stubOnly=true) CreditMemoItem item6, @Mock(stubOnly=true) PurchaseOrderItem item7, @Mock(stubOnly=true) CreditMemoItem item8, @Mock(stubOnly=true) PurchaseOrderItem item9) {
        ItemType lineItemQty = GenerateEntriesCancelCreditMemoTest.createItemType("LINEQ", true, true);
        ItemType lineItemAmt = GenerateEntriesCancelCreditMemoTest.createItemType("LINEA", true, false);
        ItemType addlItem = GenerateEntriesCancelCreditMemoTest.createItemType("ADDL", false, false);
        Mockito.when((Object)item.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)item.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)item.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)item.getItemQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        this.cmItems.add(item);
        ArrayList sourceAccountingLinesCopy = new ArrayList(new ArrayList());
        Mockito.when((Object)item1.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)item1.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)item1.getItemTypeCode()).thenReturn((Object)lineItemQty.getItemTypeCode());
        Mockito.when((Object)item1.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        Mockito.when((Object)item1.getItemOutstandingEncumberedQuantity()).thenReturn((Object)new KualiDecimal(3.0));
        Mockito.when((Object)item1.getItemUnitPrice()).thenReturn((Object)new BigDecimal("2.5"));
        Mockito.when((Object)item1.getItemTaxAmount()).thenReturn((Object)new KualiDecimal(0.0));
        Mockito.when((Object)item1.getItemQuantity()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)item1.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7.5));
        Mockito.when((Object)item1.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)item1.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy);
        item1.setItemInvoicedTotalQuantity(new KualiDecimal(2.0));
        item1.setItemOutstandingEncumberedQuantity(new KualiDecimal(2.0));
        item1.setItemOutstandingEncumberedAmount(new KualiDecimal(5.0));
        item1.setItemInvoicedTotalAmount(new KualiDecimal(5.0));
        this.poItems.add(item1);
        Mockito.when((Object)item2.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)item2.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item2.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.0));
        this.cmItems.add(item2);
        ArrayList sourceAccountingLinesCopy1 = new ArrayList(new ArrayList());
        Mockito.when((Object)item3.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)item3.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item3.getItemTypeCode()).thenReturn((Object)lineItemAmt.getItemTypeCode());
        Mockito.when((Object)item3.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(6.0));
        Mockito.when((Object)item3.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)item3.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy1);
        item3.setItemOutstandingEncumberedAmount(new KualiDecimal(4.0));
        item3.setItemInvoicedTotalAmount(new KualiDecimal(6.0));
        this.poItems.add(item3);
        Mockito.when((Object)item4.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)item4.getItemType()).thenReturn((Object)addlItem);
        Mockito.when((Object)item4.getTotalAmount()).thenReturn((Object)new KualiDecimal(1.0));
        this.cmItems.add(item4);
        ArrayList sourceAccountingLinesCopy2 = new ArrayList(new ArrayList());
        Mockito.when((Object)item5.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)item5.getItemType()).thenReturn((Object)addlItem);
        Mockito.when((Object)item5.getItemTypeCode()).thenReturn((Object)addlItem.getItemTypeCode());
        Mockito.when((Object)item5.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7.0));
        Mockito.when((Object)item5.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3.0));
        Mockito.when((Object)item5.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy2);
        item5.setItemOutstandingEncumberedAmount(new KualiDecimal(6.0));
        item5.setItemInvoicedTotalAmount(new KualiDecimal(4.0));
        this.poItems.add(item5);
        Mockito.when((Object)item6.getItemLineNumber()).thenReturn((Object)4);
        Mockito.when((Object)item6.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item6.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.0));
        this.cmItems.add(item6);
        ArrayList sourceAccountingLinesCopy3 = new ArrayList(new ArrayList());
        Mockito.when((Object)item7.getItemLineNumber()).thenReturn((Object)4);
        Mockito.when((Object)item7.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item7.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(6.0));
        Mockito.when((Object)item7.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)item7.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy3);
        item7.setItemOutstandingEncumberedAmount(new KualiDecimal(4.0));
        item7.setItemInvoicedTotalAmount(new KualiDecimal(6.0));
        this.poItems.add(item7);
        Mockito.when((Object)item8.getItemLineNumber()).thenReturn((Object)5);
        Mockito.when((Object)item8.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)item8.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)item8.getItemQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        this.cmItems.add(item8);
        ArrayList sourceAccountingLinesCopy4 = new ArrayList(new ArrayList());
        Mockito.when((Object)item9.getItemLineNumber()).thenReturn((Object)5);
        Mockito.when((Object)item9.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)item9.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        Mockito.when((Object)item9.getItemOutstandingEncumberedQuantity()).thenReturn((Object)new KualiDecimal(3.0));
        Mockito.when((Object)item9.getItemUnitPrice()).thenReturn((Object)new BigDecimal("2.5"));
        Mockito.when((Object)item9.getItemTaxAmount()).thenReturn((Object)new KualiDecimal(0.4));
        Mockito.when((Object)item9.getItemQuantity()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)item9.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7.8));
        Mockito.when((Object)item9.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)item9.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy4);
        item9.setItemInvoicedTotalQuantity(new KualiDecimal(2.0));
        item9.setItemOutstandingEncumberedQuantity(new KualiDecimal(2.0));
        item9.setItemOutstandingEncumberedAmount(new KualiDecimal(5.2));
        item9.setItemInvoicedTotalAmount(new KualiDecimal(5.0));
        this.poItems.add(item9);
        this.creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.creditMemoDocMock.isSourceVendor()).thenReturn((Object)false);
        Mockito.when((Object)this.creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.creditMemoDocMock)).thenReturn(null);
        this.preparePO("Closed");
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.execute();
    }

    @Test
    void openPOWithItemsNoAccountingLines(@Mock(stubOnly=true) CreditMemoItem item, @Mock(stubOnly=true) PurchaseOrderItem item1, @Mock(stubOnly=true) CreditMemoItem item2, @Mock(stubOnly=true) PurchaseOrderItem item3, @Mock(stubOnly=true) CreditMemoItem item4, @Mock(stubOnly=true) PurchaseOrderItem item5, @Mock(stubOnly=true) CreditMemoItem item6, @Mock(stubOnly=true) PurchaseOrderItem item7, @Mock(stubOnly=true) CreditMemoItem item8, @Mock(stubOnly=true) PurchaseOrderItem item9) {
        ItemType lineItemQty = GenerateEntriesCancelCreditMemoTest.createItemType("LINEQ", true, true);
        ItemType lineItemAmt = GenerateEntriesCancelCreditMemoTest.createItemType("LINEA", true, false);
        ItemType addlItem = GenerateEntriesCancelCreditMemoTest.createItemType("ADDL", false, false);
        Mockito.when((Object)item.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)item.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)item.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)item.getItemQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        this.cmItems.add(item);
        ArrayList sourceAccountingLinesCopy = new ArrayList(new ArrayList());
        Mockito.when((Object)item1.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)item1.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)item1.getItemTypeCode()).thenReturn((Object)lineItemQty.getItemTypeCode());
        Mockito.when((Object)item1.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        Mockito.when((Object)item1.getItemOutstandingEncumberedQuantity()).thenReturn((Object)new KualiDecimal(3.0));
        Mockito.when((Object)item1.getItemUnitPrice()).thenReturn((Object)new BigDecimal("2.5"));
        Mockito.when((Object)item1.getItemTaxAmount()).thenReturn((Object)new KualiDecimal(0.0));
        Mockito.when((Object)item1.getItemQuantity()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)item1.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7.5));
        Mockito.when((Object)item1.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)item1.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy);
        item1.setItemInvoicedTotalQuantity(new KualiDecimal(2.0));
        item1.setItemOutstandingEncumberedQuantity(new KualiDecimal(2.0));
        item1.setItemOutstandingEncumberedAmount(new KualiDecimal(5.0));
        item1.setItemInvoicedTotalAmount(new KualiDecimal(5.0));
        this.poItems.add(item1);
        Mockito.when((Object)item2.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)item2.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item2.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.0));
        this.cmItems.add(item2);
        ArrayList sourceAccountingLinesCopy1 = new ArrayList(new ArrayList());
        Mockito.when((Object)item3.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)item3.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item3.getItemTypeCode()).thenReturn((Object)lineItemAmt.getItemTypeCode());
        Mockito.when((Object)item3.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(6.0));
        Mockito.when((Object)item3.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)item3.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy1);
        item3.setItemOutstandingEncumberedAmount(new KualiDecimal(4.0));
        item3.setItemInvoicedTotalAmount(new KualiDecimal(6.0));
        this.poItems.add(item3);
        Mockito.when((Object)item4.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)item4.getItemType()).thenReturn((Object)addlItem);
        Mockito.when((Object)item4.getTotalAmount()).thenReturn((Object)new KualiDecimal(1.0));
        this.cmItems.add(item4);
        ArrayList sourceAccountingLinesCopy2 = new ArrayList(new ArrayList());
        Mockito.when((Object)item5.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)item5.getItemType()).thenReturn((Object)addlItem);
        Mockito.when((Object)item5.getItemTypeCode()).thenReturn((Object)addlItem.getItemTypeCode());
        Mockito.when((Object)item5.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7.0));
        Mockito.when((Object)item5.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3.0));
        Mockito.when((Object)item5.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy2);
        item5.setItemOutstandingEncumberedAmount(new KualiDecimal(6.0));
        item5.setItemInvoicedTotalAmount(new KualiDecimal(4.0));
        this.poItems.add(item5);
        Mockito.when((Object)item6.getItemLineNumber()).thenReturn((Object)4);
        Mockito.when((Object)item6.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item6.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.0));
        this.cmItems.add(item6);
        ArrayList sourceAccountingLinesCopy3 = new ArrayList(new ArrayList());
        Mockito.when((Object)item7.getItemLineNumber()).thenReturn((Object)4);
        Mockito.when((Object)item7.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item7.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(6.0));
        Mockito.when((Object)item7.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)item7.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy3);
        item7.setItemOutstandingEncumberedAmount(new KualiDecimal(4.0));
        item7.setItemInvoicedTotalAmount(new KualiDecimal(6.0));
        this.poItems.add(item7);
        Mockito.when((Object)item8.getItemLineNumber()).thenReturn((Object)5);
        Mockito.when((Object)item8.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)item8.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)item8.getItemQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        this.cmItems.add(item8);
        ArrayList sourceAccountingLinesCopy4 = new ArrayList(new ArrayList());
        Mockito.when((Object)item9.getItemLineNumber()).thenReturn((Object)5);
        Mockito.when((Object)item9.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)item9.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        Mockito.when((Object)item9.getItemOutstandingEncumberedQuantity()).thenReturn((Object)new KualiDecimal(3.0));
        Mockito.when((Object)item9.getItemUnitPrice()).thenReturn((Object)new BigDecimal("2.5"));
        Mockito.when((Object)item9.getItemTaxAmount()).thenReturn((Object)new KualiDecimal(0.4));
        Mockito.when((Object)item9.getItemQuantity()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)item9.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7.8));
        Mockito.when((Object)item9.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)item9.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy4);
        item9.setItemInvoicedTotalQuantity(new KualiDecimal(2.0));
        item9.setItemOutstandingEncumberedQuantity(new KualiDecimal(2.0));
        item9.setItemOutstandingEncumberedAmount(new KualiDecimal(5.2));
        item9.setItemInvoicedTotalAmount(new KualiDecimal(5.0));
        this.poItems.add(item9);
        this.creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.creditMemoDocMock.isSourceVendor()).thenReturn((Object)false);
        Mockito.when((Object)this.creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.creditMemoDocMock)).thenReturn(null);
        this.preparePO("Open");
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.creditMemoDocMock.setGenerateEncumbranceEntries(true);
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setGenerateEncumbranceEntries(ArgumentMatchers.anyBoolean());
        this.creditMemoDocMock.setDebitCreditCodeForGLEntries("D");
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setDebitCreditCodeForGLEntries(ArgumentMatchers.anyString());
        this.execute();
    }

    @Test
    void closedPOAccountingLines(@Mock(stubOnly=true) PurchaseOrderAccount account, @Mock(stubOnly=true) CreditMemoItem item, @Mock(stubOnly=true) PurchaseOrderItem item1, @Mock(stubOnly=true) PurchaseOrderAccount account1, @Mock(stubOnly=true) CreditMemoItem item2, @Mock(stubOnly=true) PurchaseOrderItem item3, @Mock(stubOnly=true) PurchaseOrderAccount account2, @Mock(stubOnly=true) CreditMemoItem item4, @Mock(stubOnly=true) PurchaseOrderItem item5, @Mock(stubOnly=true) PurchaseOrderAccount purchaseOrderAccount1Mock, @Mock(stubOnly=true) PurchaseOrderAccount purchaseOrderAccount2Mock) {
        ItemType lineItemAmt = GenerateEntriesCancelCreditMemoTest.createItemType("LINEA", true, false);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        SourceAccountingLine acctString = new SourceAccountingLine();
        acctString.setFinancialObjectCode("A");
        Mockito.when((Object)account.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)account.getAccountLinePercent()).thenReturn((Object)new BigDecimal("100"));
        Mockito.when((Object)account.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)account.generateSourceAccountingLine()).thenReturn((Object)acctString);
        account.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(6000.0));
        Mockito.when((Object)account.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(6000.0));
        account.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(6000.0));
        sourceAccountingLines.add(account);
        Mockito.when((Object)item.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)item.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item.getTotalAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        this.cmItems.add(item);
        ArrayList sourceAccountingLinesCopy = new ArrayList(sourceAccountingLines);
        Mockito.when((Object)item1.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)item1.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item1.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)item1.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)item1.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy);
        item1.setItemOutstandingEncumberedAmount(new KualiDecimal(6000.0));
        item1.setItemInvoicedTotalAmount(new KualiDecimal(4000.0));
        this.poItems.add(item1);
        sourceAccountingLines = new ArrayList();
        SourceAccountingLine acctString1 = new SourceAccountingLine();
        acctString1.setFinancialObjectCode("B");
        Mockito.when((Object)account1.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)account1.getAccountLinePercent()).thenReturn((Object)new BigDecimal("50"));
        Mockito.when((Object)account1.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(3500.0));
        Mockito.when((Object)account1.generateSourceAccountingLine()).thenReturn((Object)acctString1);
        account1.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(3000.0));
        sourceAccountingLines.add(account1);
        sourceAccountingLines.add(GenerateEntriesCancelCreditMemoTest.createPoAccountingLine(purchaseOrderAccount1Mock, 50.0, 3500.0, 3000.0, 3000.0, "C"));
        Mockito.when((Object)item2.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)item2.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item2.getTotalAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        this.cmItems.add(item2);
        ArrayList sourceAccountingLinesCopy1 = new ArrayList(sourceAccountingLines);
        Mockito.when((Object)item3.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)item3.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item3.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)item3.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)item3.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy1);
        item3.setItemOutstandingEncumberedAmount(new KualiDecimal(6000.0));
        item3.setItemInvoicedTotalAmount(new KualiDecimal(4000.0));
        this.poItems.add(item3);
        sourceAccountingLines = new ArrayList();
        SourceAccountingLine acctString2 = new SourceAccountingLine();
        acctString2.setFinancialObjectCode("C");
        Mockito.when((Object)account2.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)account2.getAccountLinePercent()).thenReturn((Object)new BigDecimal("66.66"));
        Mockito.when((Object)account2.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(4666.2));
        Mockito.when((Object)account2.generateSourceAccountingLine()).thenReturn((Object)acctString2);
        account2.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(3999.6));
        sourceAccountingLines.add(account2);
        sourceAccountingLines.add(GenerateEntriesCancelCreditMemoTest.createPoAccountingLine(purchaseOrderAccount2Mock, 33.33, 2333.8, 2000.5, 2000.4, "D"));
        Mockito.when((Object)item4.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)item4.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item4.getTotalAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        this.cmItems.add(item4);
        ArrayList sourceAccountingLinesCopy2 = new ArrayList(sourceAccountingLines);
        Mockito.when((Object)item5.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)item5.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item5.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)item5.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)item5.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy2);
        item5.setItemOutstandingEncumberedAmount(new KualiDecimal(6000.0));
        item5.setItemInvoicedTotalAmount(new KualiDecimal(4000.0));
        this.poItems.add(item5);
        this.creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.creditMemoDocMock.isSourceVendor()).thenReturn((Object)false);
        Mockito.when((Object)this.creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.creditMemoDocMock)).thenReturn(null);
        this.preparePO("Closed");
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.execute();
    }

    @Test
    void openPOAccountingLines(@Mock(stubOnly=true) PurchaseOrderAccount account, @Mock(stubOnly=true) CreditMemoItem item, @Mock(stubOnly=true) PurchaseOrderItem item1, @Mock(stubOnly=true) PurchaseOrderAccount account1, @Mock(stubOnly=true) CreditMemoItem item2, @Mock(stubOnly=true) PurchaseOrderItem item3, @Mock(stubOnly=true) PurchaseOrderAccount account2, @Mock(stubOnly=true) CreditMemoItem item4, @Mock(stubOnly=true) PurchaseOrderItem item5, @Mock(stubOnly=true) PurchaseOrderAccount purchaseOrderAccount1Mock, @Mock(stubOnly=true) PurchaseOrderAccount purchaseOrderAccount2Mock) {
        ItemType lineItemAmt = GenerateEntriesCancelCreditMemoTest.createItemType("LINEA", true, false);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        SourceAccountingLine acctString = new SourceAccountingLine();
        acctString.setFinancialObjectCode("A");
        Mockito.when((Object)account.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)account.getAccountLinePercent()).thenReturn((Object)new BigDecimal("100"));
        Mockito.when((Object)account.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)account.generateSourceAccountingLine()).thenReturn((Object)acctString);
        account.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(6000.0));
        Mockito.when((Object)account.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(6000.0));
        account.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(6000.0));
        sourceAccountingLines.add(account);
        Mockito.when((Object)item.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)item.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item.getTotalAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        this.cmItems.add(item);
        ArrayList sourceAccountingLinesCopy = new ArrayList(sourceAccountingLines);
        Mockito.when((Object)item1.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)item1.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item1.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)item1.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)item1.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy);
        item1.setItemOutstandingEncumberedAmount(new KualiDecimal(6000.0));
        item1.setItemInvoicedTotalAmount(new KualiDecimal(4000.0));
        this.poItems.add(item1);
        sourceAccountingLines = new ArrayList();
        SourceAccountingLine acctString5 = new SourceAccountingLine();
        acctString5.setFinancialObjectCode("B");
        Mockito.when((Object)account1.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)account1.getAccountLinePercent()).thenReturn((Object)new BigDecimal("50"));
        Mockito.when((Object)account1.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(3500.0));
        Mockito.when((Object)account1.generateSourceAccountingLine()).thenReturn((Object)acctString5);
        account1.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(3000.0));
        sourceAccountingLines.add(account1);
        sourceAccountingLines.add(GenerateEntriesCancelCreditMemoTest.createPoAccountingLine(purchaseOrderAccount1Mock, 50.0, 3500.0, 3000.0, 3000.0, "C"));
        Mockito.when((Object)item2.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)item2.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item2.getTotalAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        this.cmItems.add(item2);
        ArrayList sourceAccountingLinesCopy1 = new ArrayList(sourceAccountingLines);
        Mockito.when((Object)item3.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)item3.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item3.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)item3.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)item3.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy1);
        item3.setItemOutstandingEncumberedAmount(new KualiDecimal(6000.0));
        item3.setItemInvoicedTotalAmount(new KualiDecimal(4000.0));
        this.poItems.add(item3);
        sourceAccountingLines = new ArrayList();
        SourceAccountingLine acctString6 = new SourceAccountingLine();
        acctString6.setFinancialObjectCode("C");
        Mockito.when((Object)account2.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)account2.getAccountLinePercent()).thenReturn((Object)new BigDecimal("66.66"));
        Mockito.when((Object)account2.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(4666.2));
        Mockito.when((Object)account2.generateSourceAccountingLine()).thenReturn((Object)acctString6);
        account2.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(3999.6));
        sourceAccountingLines.add(account2);
        sourceAccountingLines.add(GenerateEntriesCancelCreditMemoTest.createPoAccountingLine(purchaseOrderAccount2Mock, 33.33, 2333.8, 2000.5, 2000.4, "D"));
        Mockito.when((Object)item4.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)item4.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item4.getTotalAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        this.cmItems.add(item4);
        ArrayList sourceAccountingLinesCopy2 = new ArrayList(sourceAccountingLines);
        Mockito.when((Object)item5.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)item5.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)item5.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)item5.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)item5.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy2);
        item5.setItemOutstandingEncumberedAmount(new KualiDecimal(6000.0));
        item5.setItemInvoicedTotalAmount(new KualiDecimal(4000.0));
        this.poItems.add(item5);
        SourceAccountingLine acctString1 = new SourceAccountingLine();
        acctString1.setFinancialObjectCode("A");
        acctString1.setAmount(new KualiDecimal(1000));
        SourceAccountingLine acctString2 = new SourceAccountingLine();
        acctString2.setFinancialObjectCode("B");
        acctString2.setAmount(new KualiDecimal(500));
        SourceAccountingLine acctString3 = new SourceAccountingLine();
        acctString3.setFinancialObjectCode("C");
        acctString3.setAmount(new KualiDecimal(1166.6));
        SourceAccountingLine acctString4 = new SourceAccountingLine();
        acctString4.setFinancialObjectCode("D");
        acctString4.setAmount(new KualiDecimal(333.4));
        Mockito.when((Object)this.creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)acctString1), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)acctString2), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)acctString3), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)acctString4), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        this.creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.creditMemoDocMock.isSourceVendor()).thenReturn((Object)false);
        Mockito.when((Object)this.creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.creditMemoDocMock)).thenReturn(null);
        this.preparePO("Open");
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.creditMemoDocMock.setGenerateEncumbranceEntries(true);
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setGenerateEncumbranceEntries(ArgumentMatchers.anyBoolean());
        this.creditMemoDocMock.setDebitCreditCodeForGLEntries("D");
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setDebitCreditCodeForGLEntries(ArgumentMatchers.anyString());
        this.execute();
    }

    @Test
    void summaryAccountHandling(@Mock(stubOnly=true) SummaryAccount summaryAccount) {
        ArrayList<SummaryAccount> summaryAccounts = new ArrayList<SummaryAccount>();
        SourceAccountingLine account = new SourceAccountingLine();
        Mockito.when((Object)summaryAccount.getAccount()).thenReturn((Object)account);
        summaryAccounts.add(summaryAccount);
        this.creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.creditMemoDocMock.isSourceVendor()).thenReturn((Object)true);
        Mockito.when((Object)this.creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)this.creditMemoDocMock.getPostingYearFromPendingGLEntries()).thenReturn((Object)2015);
        Mockito.when((Object)this.creditMemoDocMock.getPostingPeriodCodeFromPendingGLEntries()).thenReturn((Object)"01");
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.creditMemoDocMock)).thenReturn(summaryAccounts);
        this.creditMemoDocMock.setGenerateEncumbranceEntries(false);
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setGenerateEncumbranceEntries(ArgumentMatchers.anyBoolean());
        this.creditMemoDocMock.setDebitCreditCodeForGLEntries("D");
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setDebitCreditCodeForGLEntries(ArgumentMatchers.anyString());
        Mockito.when((Object)this.creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)account), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.purapAccountingSvcMock.generateUseTaxAccount((PurchasingAccountsPayableDocument)this.creditMemoDocMock)).thenReturn(new ArrayList());
        this.purapAccountRevisionSvcMock.cancelCreditMemoAccountRevisions(new ArrayList(), Integer.valueOf(2015), "01");
        this.execute();
    }
}

