/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderCloseDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class GenerateEntriesClosePurchaseOrderTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private GeneralLedgerPendingEntryService glPendingEntrySvcMock;
    @Mock
    private BusinessObjectService boServiceMock;

    GenerateEntriesClosePurchaseOrderTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setGeneralLedgerPendingEntryService(this.glPendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
    }

    private void setUpBaseExpectations(PurchaseOrderCloseDocument poCloseMock, List<PurchaseOrderItem> purchaseOrderItems, List<PurApItem> activePurchaseOrderItems, List<SourceAccountingLine> accountingLines, List<? extends GeneralLedgerPendingEntry> pendingEntries) {
        Mockito.when((Object)poCloseMock.getItems()).thenReturn(purchaseOrderItems);
        Mockito.when((Object)poCloseMock.getItemsActiveOnly()).thenReturn(activePurchaseOrderItems);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsUsingAlternateAmount(activePurchaseOrderItems)).thenReturn(accountingLines);
        poCloseMock.setGlOnlySourceAccountingLines(accountingLines);
        ((PurchaseOrderCloseDocument)Mockito.verify((Object)poCloseMock)).setGlOnlySourceAccountingLines(ArgumentMatchers.anyList());
        Mockito.when((Object)poCloseMock.getGlOnlySourceAccountingLines()).thenReturn(accountingLines);
        Mockito.when((Object)this.glPendingEntrySvcMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)poCloseMock)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.boServiceMock.save(pendingEntries)).thenReturn(null);
    }

    private static PurchaseOrderItem buildBasePurchaseOrderItem() {
        PurchaseOrderItem purchaseOrderItem = new PurchaseOrderItem();
        purchaseOrderItem.setItemLineNumber(Integer.valueOf(1));
        purchaseOrderItem.setItemDescription("Stuff");
        purchaseOrderItem.setItemActiveIndicator(true);
        purchaseOrderItem.setDocumentNumber("1");
        purchaseOrderItem.setItemIdentifier(Integer.valueOf(1));
        purchaseOrderItem.setSourceAccountingLines(new ArrayList());
        return purchaseOrderItem;
    }

    private static PurchaseOrderItem buildQuantityPurchaseOrderItem(KualiDecimal itemQuantity, BigDecimal itemUnitPrice) {
        PurchaseOrderItem purchaseOrderItem = GenerateEntriesClosePurchaseOrderTest.buildBasePurchaseOrderItem();
        purchaseOrderItem.setItemQuantity(itemQuantity);
        purchaseOrderItem.setItemUnitPrice(itemUnitPrice);
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(true);
        itemType.setItemTypeCode("ITEM");
        purchaseOrderItem.setItemType(itemType);
        return purchaseOrderItem;
    }

    private static PurchaseOrderItem buildNonQuantityPurchaseOrderItem(KualiDecimal invoicedAmount) {
        PurchaseOrderItem purchaseOrderItem = GenerateEntriesClosePurchaseOrderTest.buildBasePurchaseOrderItem();
        purchaseOrderItem.setItemInvoicedTotalAmount(invoicedAmount);
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(false);
        itemType.setItemTypeCode("ITEM");
        purchaseOrderItem.setItemType(itemType);
        return purchaseOrderItem;
    }

    private static PurchaseOrderAccount buildAccountingLine(BigDecimal accountingLinePercent, KualiDecimal amount) {
        PurchaseOrderAccount accountingLine = new PurchaseOrderAccount();
        accountingLine.setAccountLinePercent(accountingLinePercent);
        accountingLine.setAmount(amount);
        return accountingLine;
    }

    @Test
    void purchaseOrderCloseWithNoItems(@Mock PurchaseOrderCloseDocument poCloseMock) {
        ArrayList purchaseOrderItems = new ArrayList();
        ArrayList activePurchaseOrderItems = new ArrayList();
        ArrayList accountingLines = new ArrayList();
        Mockito.when((Object)poCloseMock.getItems()).thenReturn(purchaseOrderItems);
        Mockito.when((Object)poCloseMock.getItemsActiveOnly()).thenReturn(activePurchaseOrderItems);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsUsingAlternateAmount(activePurchaseOrderItems)).thenReturn(accountingLines);
        poCloseMock.setGlOnlySourceAccountingLines(accountingLines);
        ((PurchaseOrderCloseDocument)Mockito.verify((Object)poCloseMock)).setGlOnlySourceAccountingLines(ArgumentMatchers.anyList());
        Mockito.when((Object)poCloseMock.getGlOnlySourceAccountingLines()).thenReturn(accountingLines);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)poCloseMock);
    }

    @Test
    void purchaseOrderCloseWithOneQuantityItemOneAccountingLine(@Mock PurchaseOrderCloseDocument poCloseMock) {
        PurchaseOrderItem purchaseOrderItem = GenerateEntriesClosePurchaseOrderTest.buildQuantityPurchaseOrderItem(new KualiDecimal(20), new BigDecimal("5.0"));
        PurchaseOrderAccount accountingLine = GenerateEntriesClosePurchaseOrderTest.buildAccountingLine(new BigDecimal("100.0"), new KualiDecimal(100.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList pendingEntries = new ArrayList();
        purchaseOrderItem.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine);
        purchaseOrderItems.add(purchaseOrderItem);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem);
        accountingLines.add((SourceAccountingLine)accountingLine);
        this.setUpBaseExpectations(poCloseMock, purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        Mockito.when((Object)poCloseMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)poCloseMock);
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedQuantity());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedAmount());
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)accountingLine.getAlternateAmountForGLEntryCreation());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)accountingLine.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    void purchaseOrderCloseWithOneQuantityItemTwoAccountingLines(@Mock PurchaseOrderCloseDocument poCloseMock) {
        PurchaseOrderItem purchaseOrderItem = GenerateEntriesClosePurchaseOrderTest.buildQuantityPurchaseOrderItem(new KualiDecimal(20), new BigDecimal("5"));
        PurchaseOrderAccount accountingLine1 = GenerateEntriesClosePurchaseOrderTest.buildAccountingLine(new BigDecimal("50.0"), new KualiDecimal(50.0));
        PurchaseOrderAccount accountingLine2 = GenerateEntriesClosePurchaseOrderTest.buildAccountingLine(new BigDecimal("50.0"), new KualiDecimal(50.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList pendingEntries = new ArrayList();
        purchaseOrderItem.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine1);
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine2);
        purchaseOrderItems.add(purchaseOrderItem);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem);
        accountingLines.add((SourceAccountingLine)accountingLine1);
        accountingLines.add((SourceAccountingLine)accountingLine2);
        this.setUpBaseExpectations(poCloseMock, purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        Mockito.when((Object)poCloseMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)poCloseMock);
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedQuantity());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedAmount());
        Assertions.assertEquals((Object)new KualiDecimal(50), (Object)accountingLine1.getAlternateAmountForGLEntryCreation());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)accountingLine1.getItemAccountOutstandingEncumbranceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(50), (Object)accountingLine2.getAlternateAmountForGLEntryCreation());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)accountingLine2.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    void purchaseOrderCloseWithTwoItems(@Mock PurchaseOrderCloseDocument poCloseMock) {
        PurchaseOrderItem purchaseOrderItem1 = GenerateEntriesClosePurchaseOrderTest.buildQuantityPurchaseOrderItem(new KualiDecimal(20), new BigDecimal("5.0"));
        PurchaseOrderAccount accountingLine1 = GenerateEntriesClosePurchaseOrderTest.buildAccountingLine(new BigDecimal("100.0"), new KualiDecimal(100.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList pendingEntries = new ArrayList();
        purchaseOrderItem1.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem1.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem1.getSourceAccountingLines().add(accountingLine1);
        purchaseOrderItems.add(purchaseOrderItem1);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem1);
        accountingLines.add((SourceAccountingLine)accountingLine1);
        PurchaseOrderItem purchaseOrderItem2 = GenerateEntriesClosePurchaseOrderTest.buildQuantityPurchaseOrderItem(new KualiDecimal(5), new BigDecimal("5"));
        PurchaseOrderAccount accountingLine2 = GenerateEntriesClosePurchaseOrderTest.buildAccountingLine(new BigDecimal("100"), new KualiDecimal(25));
        purchaseOrderItem2.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem2.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem2.getSourceAccountingLines().add(accountingLine2);
        purchaseOrderItems.add(purchaseOrderItem2);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem2);
        accountingLines.add((SourceAccountingLine)accountingLine2);
        this.setUpBaseExpectations(poCloseMock, purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        Mockito.when((Object)poCloseMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)poCloseMock);
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem1.getItemOutstandingEncumberedQuantity());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem1.getItemOutstandingEncumberedAmount());
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)accountingLine1.getAlternateAmountForGLEntryCreation());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)accountingLine1.getItemAccountOutstandingEncumbranceAmount());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem2.getItemOutstandingEncumberedQuantity());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem2.getItemOutstandingEncumberedAmount());
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)accountingLine2.getAlternateAmountForGLEntryCreation());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)accountingLine2.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    void purchaseOrderCloseWithOneActiveOneInactiveItem(@Mock PurchaseOrderCloseDocument poCloseMock) {
        PurchaseOrderItem purchaseOrderItem1 = GenerateEntriesClosePurchaseOrderTest.buildQuantityPurchaseOrderItem(new KualiDecimal(20), new BigDecimal("5.0"));
        PurchaseOrderAccount accountingLine1 = GenerateEntriesClosePurchaseOrderTest.buildAccountingLine(new BigDecimal("100.0"), new KualiDecimal(100.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList pendingEntries = new ArrayList();
        purchaseOrderItem1.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem1.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem1.getSourceAccountingLines().add(accountingLine1);
        purchaseOrderItems.add(purchaseOrderItem1);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem1);
        accountingLines.add((SourceAccountingLine)accountingLine1);
        PurchaseOrderItem purchaseOrderItem2 = GenerateEntriesClosePurchaseOrderTest.buildQuantityPurchaseOrderItem(new KualiDecimal(5), new BigDecimal("5"));
        PurchaseOrderAccount accountingLine2 = GenerateEntriesClosePurchaseOrderTest.buildAccountingLine(new BigDecimal("100"), new KualiDecimal(25));
        purchaseOrderItem2.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem2.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem2.getSourceAccountingLines().add(accountingLine2);
        purchaseOrderItems.add(purchaseOrderItem2);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem2);
        accountingLines.add((SourceAccountingLine)accountingLine2);
        purchaseOrderItem2.setItemActiveIndicator(false);
        this.setUpBaseExpectations(poCloseMock, purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        Mockito.when((Object)poCloseMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)poCloseMock);
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem1.getItemOutstandingEncumberedQuantity());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem1.getItemOutstandingEncumberedAmount());
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)accountingLine1.getAlternateAmountForGLEntryCreation());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)accountingLine1.getItemAccountOutstandingEncumbranceAmount());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem2.getItemOutstandingEncumberedQuantity());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem2.getItemOutstandingEncumberedAmount());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)accountingLine2.getAlternateAmountForGLEntryCreation());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)accountingLine2.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    void purchaseOrderCloseWithOneNonQuantityItemOneAccountingLine(@Mock PurchaseOrderCloseDocument poCloseMock) {
        PurchaseOrderItem purchaseOrderItem = GenerateEntriesClosePurchaseOrderTest.buildNonQuantityPurchaseOrderItem(new KualiDecimal(105.0));
        PurchaseOrderAccount accountingLine = GenerateEntriesClosePurchaseOrderTest.buildAccountingLine(new BigDecimal("100.0"), new KualiDecimal(105.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList pendingEntries = new ArrayList();
        purchaseOrderItem.setItemOutstandingEncumberedAmount(new KualiDecimal(105.0));
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine);
        purchaseOrderItems.add(purchaseOrderItem);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem);
        accountingLines.add((SourceAccountingLine)accountingLine);
        this.setUpBaseExpectations(poCloseMock, purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        Mockito.when((Object)poCloseMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)poCloseMock);
        Assertions.assertNull((Object)purchaseOrderItem.getItemOutstandingEncumberedQuantity());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedAmount());
        Assertions.assertEquals((Object)new KualiDecimal(105.0), (Object)accountingLine.getAlternateAmountForGLEntryCreation());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)accountingLine.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    void purchaseOrderCloseWithOneNonQuantityItemTwoAccountingLines(@Mock PurchaseOrderCloseDocument poCloseMock) {
        PurchaseOrderItem purchaseOrderItem = GenerateEntriesClosePurchaseOrderTest.buildNonQuantityPurchaseOrderItem(new KualiDecimal(200.07));
        PurchaseOrderAccount accountingLine1 = GenerateEntriesClosePurchaseOrderTest.buildAccountingLine(new BigDecimal("50.0"), new KualiDecimal(100.03));
        PurchaseOrderAccount accountingLine2 = GenerateEntriesClosePurchaseOrderTest.buildAccountingLine(new BigDecimal("50.0"), new KualiDecimal(100.03));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList pendingEntries = new ArrayList();
        purchaseOrderItem.setItemOutstandingEncumberedAmount(new KualiDecimal(200.07));
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine1);
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine2);
        purchaseOrderItems.add(purchaseOrderItem);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem);
        accountingLines.add((SourceAccountingLine)accountingLine1);
        accountingLines.add((SourceAccountingLine)accountingLine2);
        this.setUpBaseExpectations(poCloseMock, purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        Mockito.when((Object)poCloseMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)poCloseMock);
        Assertions.assertNull((Object)purchaseOrderItem.getItemOutstandingEncumberedQuantity());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedAmount());
        Assertions.assertEquals((Object)new KualiDecimal(100.04), (Object)accountingLine1.getAlternateAmountForGLEntryCreation());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)accountingLine1.getItemAccountOutstandingEncumbranceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(100.03), (Object)accountingLine2.getAlternateAmountForGLEntryCreation());
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)accountingLine2.getItemAccountOutstandingEncumbranceAmount());
    }
}

