/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountRevisionService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.module.purap.util.SummaryAccount;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class GenerateEntriesCreateCreditMemoTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private GeneralLedgerPendingEntryService glPendingEntrySvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private PurchaseOrderService purchaseOrderSvcMock;
    @Mock
    private PurapAccountRevisionService purapAccountRevisionSvcMock;
    private List<CreditMemoItem> cmItems;
    private List<PurchaseOrderItem> poItems;

    GenerateEntriesCreateCreditMemoTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setGeneralLedgerPendingEntryService(this.glPendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setPurchaseOrderService(this.purchaseOrderSvcMock);
        this.cut.setPurapAccountRevisionService(this.purapAccountRevisionSvcMock);
        this.cmItems = new ArrayList<CreditMemoItem>();
        this.poItems = new ArrayList<PurchaseOrderItem>();
    }

    private void execute(VendorCreditMemoDocument creditMemoDocMock) {
        this.cut.generateEntriesCreateCreditMemo(creditMemoDocMock);
    }

    private void prepareBusinessObjectService() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialSystemOriginationCode", "01");
        fieldValues.put("documentNumber", "1");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, fieldValues)).thenReturn((Object)2);
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(null);
    }

    private void preparePO(PurchaseOrderDocument poMock, String status) {
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1234))).thenReturn((Object)poMock);
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)poMock))).thenReturn((Object)poMock);
        Mockito.when((Object)poMock.getApplicationDocumentStatus()).thenReturn((Object)status);
        Mockito.when((Object)poMock.getItems()).thenReturn(this.poItems);
    }

    private static PurchaseOrderAccount createPoAccountingLine(PurchaseOrderAccount accountMock, double percent, double outstandingAmount, double newOutstandingAmount, Double altAmount, String objectCode) {
        SourceAccountingLine acctString = new SourceAccountingLine();
        acctString.setFinancialObjectCode(objectCode);
        Mockito.when((Object)accountMock.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)accountMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal(percent));
        Mockito.when((Object)accountMock.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(outstandingAmount));
        Mockito.when((Object)accountMock.generateSourceAccountingLine()).thenReturn((Object)acctString);
        Mockito.when((Object)accountMock.compareTo(ArgumentMatchers.isA(PurchaseOrderAccount.class))).thenReturn((Object)0);
        accountMock.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(newOutstandingAmount));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock)).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)accountMock.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(newOutstandingAmount));
        accountMock.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(altAmount.doubleValue()));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock, (VerificationMode)Mockito.atLeastOnce())).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        return accountMock;
    }

    private static ItemType createItemType(String code, boolean lineItem, boolean quantityBased) {
        ItemType itemType = new ItemType();
        itemType.setItemTypeCode(code);
        itemType.setQuantityBasedGeneralLedgerIndicator(quantityBased);
        itemType.setAdditionalChargeIndicator(!lineItem);
        return itemType;
    }

    @Test
    void baseCase(@Mock VendorCreditMemoDocument creditMemoDocMock) {
        creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setGeneralLedgerPendingEntries(ArgumentMatchers.anyList());
        Mockito.when((Object)creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)creditMemoDocMock.isSourceVendor()).thenReturn((Object)true);
        Mockito.when((Object)creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)creditMemoDocMock)).thenReturn(null);
        this.execute(creditMemoDocMock);
    }

    @Test
    void closedPONoItems(@Mock VendorCreditMemoDocument creditMemoDocMock, @Mock PurchaseOrderDocument poMock) {
        creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setGeneralLedgerPendingEntries(ArgumentMatchers.anyList());
        Mockito.when((Object)creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)creditMemoDocMock.isSourceVendor()).thenReturn((Object)false);
        Mockito.when((Object)creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)creditMemoDocMock)).thenReturn(null);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1234))).thenReturn((Object)poMock);
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)poMock))).thenReturn((Object)poMock);
        Mockito.when((Object)poMock.getApplicationDocumentStatus()).thenReturn((Object)"Closed");
        Mockito.when((Object)creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.execute(creditMemoDocMock);
    }

    @Test
    void closedPOFromPreqNoItems(@Mock VendorCreditMemoDocument creditMemoDocMock, @Mock PurchaseOrderDocument poMock, @Mock PaymentRequestDocument preqMock) {
        creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setGeneralLedgerPendingEntries(ArgumentMatchers.anyList());
        Mockito.when((Object)creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)creditMemoDocMock.isSourceVendor()).thenReturn((Object)false);
        Mockito.when((Object)creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)false);
        Mockito.when((Object)creditMemoDocMock.isSourceDocumentPaymentRequest()).thenReturn((Object)true);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)creditMemoDocMock)).thenReturn(null);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1234))).thenReturn((Object)poMock);
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)poMock))).thenReturn((Object)poMock);
        Mockito.when((Object)poMock.getApplicationDocumentStatus()).thenReturn((Object)"Closed");
        Mockito.when((Object)creditMemoDocMock.getPaymentRequestDocument()).thenReturn((Object)preqMock);
        Mockito.when((Object)preqMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.execute(creditMemoDocMock);
    }

    @Test
    void closedPOWithItemsNoAccountingLines(@Mock VendorCreditMemoDocument creditMemoDocMock, @Mock PurchaseOrderDocument poMock, @Mock CreditMemoItem itemMock, @Mock CreditMemoItem itemMock2, @Mock CreditMemoItem itemMock4, @Mock CreditMemoItem itemMock6, @Mock CreditMemoItem itemMock8, @Mock PurchaseOrderItem itemMock1, @Mock PurchaseOrderItem itemMock3, @Mock PurchaseOrderItem itemMock5, @Mock PurchaseOrderItem itemMock7, @Mock PurchaseOrderItem itemMock9) {
        ItemType lineItemQty = GenerateEntriesCreateCreditMemoTest.createItemType("LINEQ", true, true);
        ItemType lineItemAmt = GenerateEntriesCreateCreditMemoTest.createItemType("LINEA", true, false);
        ItemType addlItem = GenerateEntriesCreateCreditMemoTest.createItemType("ADDL", false, false);
        Mockito.when((Object)itemMock.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)itemMock.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)itemMock.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)itemMock.getItemQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        this.cmItems.add(itemMock);
        ArrayList sourceAccountingLinesCopy = new ArrayList(new ArrayList());
        Mockito.when((Object)itemMock1.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)itemMock1.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)itemMock1.getItemTypeCode()).thenReturn((Object)lineItemQty.getItemTypeCode());
        Mockito.when((Object)itemMock1.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        Mockito.when((Object)itemMock1.getItemOutstandingEncumberedQuantity()).thenReturn((Object)new KualiDecimal(3.0));
        Mockito.when((Object)itemMock1.getItemUnitPrice()).thenReturn((Object)new BigDecimal("2.5"));
        Mockito.when((Object)itemMock1.getItemTaxAmount()).thenReturn((Object)new KualiDecimal(0.0));
        Mockito.when((Object)itemMock1.getItemQuantity()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)itemMock1.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7.5));
        Mockito.when((Object)itemMock1.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)itemMock1.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy);
        itemMock1.setItemOutstandingEncumberedAmount(new KualiDecimal(10.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock1)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock1.setItemInvoicedTotalAmount(new KualiDecimal(0.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock1)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock1);
        Mockito.when((Object)itemMock2.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)itemMock2.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock2.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.0));
        this.cmItems.add(itemMock2);
        ArrayList sourceAccountingLinesCopy1 = new ArrayList(new ArrayList());
        Mockito.when((Object)itemMock3.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)itemMock3.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock3.getItemTypeCode()).thenReturn((Object)lineItemAmt.getItemTypeCode());
        Mockito.when((Object)itemMock3.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(6.0));
        Mockito.when((Object)itemMock3.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)itemMock3.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy1);
        Mockito.when((Object)itemMock3.getTotalAmount()).thenReturn((Object)new KualiDecimal(10.0));
        itemMock3.setItemOutstandingEncumberedAmount(new KualiDecimal(8.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock3)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock3.setItemInvoicedTotalAmount(new KualiDecimal(2.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock3)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock3);
        Mockito.when((Object)itemMock4.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)itemMock4.getItemType()).thenReturn((Object)addlItem);
        Mockito.when((Object)itemMock4.getTotalAmount()).thenReturn((Object)new KualiDecimal(1.0));
        this.cmItems.add(itemMock4);
        ArrayList sourceAccountingLinesCopy2 = new ArrayList(new ArrayList());
        Mockito.when((Object)itemMock5.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)itemMock5.getItemType()).thenReturn((Object)addlItem);
        Mockito.when((Object)itemMock5.getItemTypeCode()).thenReturn((Object)addlItem.getItemTypeCode());
        Mockito.when((Object)itemMock5.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7.0));
        Mockito.when((Object)itemMock5.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3.0));
        Mockito.when((Object)itemMock5.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy2);
        Mockito.when((Object)itemMock5.getTotalAmount()).thenReturn((Object)new KualiDecimal(10.0));
        itemMock5.setItemOutstandingEncumberedAmount(new KualiDecimal(8.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock5)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock5.setItemInvoicedTotalAmount(new KualiDecimal(2.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock5)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock5);
        Mockito.when((Object)itemMock6.getItemLineNumber()).thenReturn((Object)4);
        Mockito.when((Object)itemMock6.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock6.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.0));
        this.cmItems.add(itemMock6);
        ArrayList sourceAccountingLinesCopy3 = new ArrayList(new ArrayList());
        Mockito.when((Object)itemMock7.getItemLineNumber()).thenReturn((Object)4);
        Mockito.when((Object)itemMock7.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock7.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(6.0));
        Mockito.when((Object)itemMock7.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)itemMock7.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy3);
        Mockito.when((Object)itemMock7.getTotalAmount()).thenReturn((Object)new KualiDecimal(10.0));
        itemMock7.setItemOutstandingEncumberedAmount(new KualiDecimal(8.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock7)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock7.setItemInvoicedTotalAmount(new KualiDecimal(2.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock7)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock7);
        Mockito.when((Object)itemMock8.getItemLineNumber()).thenReturn((Object)5);
        Mockito.when((Object)itemMock8.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)itemMock8.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)itemMock8.getItemQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        this.cmItems.add(itemMock8);
        ArrayList sourceAccountingLinesCopy4 = new ArrayList(new ArrayList());
        Mockito.when((Object)itemMock9.getItemLineNumber()).thenReturn((Object)5);
        Mockito.when((Object)itemMock9.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)itemMock9.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        Mockito.when((Object)itemMock9.getItemOutstandingEncumberedQuantity()).thenReturn((Object)new KualiDecimal(3.0));
        Mockito.when((Object)itemMock9.getItemUnitPrice()).thenReturn((Object)new BigDecimal("2.5"));
        Mockito.when((Object)itemMock9.getItemTaxAmount()).thenReturn((Object)new KualiDecimal(0.4));
        Mockito.when((Object)itemMock9.getItemQuantity()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)itemMock9.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7.8));
        Mockito.when((Object)itemMock9.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)itemMock9.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy4);
        itemMock9.setItemInvoicedTotalQuantity(new KualiDecimal(0.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock9)).setItemInvoicedTotalQuantity((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock9.setItemOutstandingEncumberedQuantity(new KualiDecimal(4.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock9)).setItemOutstandingEncumberedQuantity((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock9.setItemOutstandingEncumberedAmount(new KualiDecimal(10.4));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock9)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock9.setItemInvoicedTotalAmount(new KualiDecimal(0.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock9)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock9);
        creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setGeneralLedgerPendingEntries(ArgumentMatchers.anyList());
        Mockito.when((Object)creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)creditMemoDocMock.isSourceVendor()).thenReturn((Object)false);
        Mockito.when((Object)creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)creditMemoDocMock)).thenReturn(null);
        this.preparePO(poMock, "Closed");
        Mockito.when((Object)creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.execute(creditMemoDocMock);
    }

    @Test
    void openPOWithItemsNoAccountingLines(@Mock VendorCreditMemoDocument creditMemoDocMock, @Mock PurchaseOrderDocument poMock, @Mock CreditMemoItem itemMock, @Mock CreditMemoItem itemMock2, @Mock CreditMemoItem itemMock4, @Mock CreditMemoItem itemMock6, @Mock CreditMemoItem itemMock8, @Mock PurchaseOrderItem itemMock1, @Mock PurchaseOrderItem itemMock3, @Mock PurchaseOrderItem itemMock5, @Mock PurchaseOrderItem itemMock7, @Mock PurchaseOrderItem itemMock9) {
        ItemType lineItemQty = GenerateEntriesCreateCreditMemoTest.createItemType("LINEQ", true, true);
        ItemType lineItemAmt = GenerateEntriesCreateCreditMemoTest.createItemType("LINEA", true, false);
        ItemType addlItem = GenerateEntriesCreateCreditMemoTest.createItemType("ADDL", false, false);
        Mockito.when((Object)itemMock.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)itemMock.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)itemMock.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)itemMock.getItemQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        this.cmItems.add(itemMock);
        ArrayList sourceAccountingLinesCopy = new ArrayList(new ArrayList());
        Mockito.when((Object)itemMock1.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)itemMock1.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)itemMock1.getItemTypeCode()).thenReturn((Object)lineItemQty.getItemTypeCode());
        Mockito.when((Object)itemMock1.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        Mockito.when((Object)itemMock1.getItemOutstandingEncumberedQuantity()).thenReturn((Object)new KualiDecimal(3.0));
        Mockito.when((Object)itemMock1.getItemUnitPrice()).thenReturn((Object)new BigDecimal("2.5"));
        Mockito.when((Object)itemMock1.getItemTaxAmount()).thenReturn((Object)new KualiDecimal(0.0));
        Mockito.when((Object)itemMock1.getItemQuantity()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)itemMock1.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7.5));
        Mockito.when((Object)itemMock1.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)itemMock1.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy);
        itemMock1.setItemInvoicedTotalQuantity(new KualiDecimal(0.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock1)).setItemInvoicedTotalQuantity((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock1.setItemOutstandingEncumberedQuantity(new KualiDecimal(4.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock1)).setItemOutstandingEncumberedQuantity((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock1.setItemOutstandingEncumberedAmount(new KualiDecimal(10.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock1)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock1.setItemInvoicedTotalAmount(new KualiDecimal(0.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock1)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock1);
        Mockito.when((Object)itemMock2.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)itemMock2.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock2.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.0));
        this.cmItems.add(itemMock2);
        ArrayList sourceAccountingLinesCopy1 = new ArrayList(new ArrayList());
        Mockito.when((Object)itemMock3.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)itemMock3.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock3.getItemTypeCode()).thenReturn((Object)lineItemAmt.getItemTypeCode());
        Mockito.when((Object)itemMock3.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(6.0));
        Mockito.when((Object)itemMock3.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)itemMock3.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy1);
        Mockito.when((Object)itemMock3.getTotalAmount()).thenReturn((Object)new KualiDecimal(10.0));
        itemMock3.setItemOutstandingEncumberedAmount(new KualiDecimal(8.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock3)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock3.setItemInvoicedTotalAmount(new KualiDecimal(2.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock3)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock3);
        Mockito.when((Object)itemMock4.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)itemMock4.getItemType()).thenReturn((Object)addlItem);
        Mockito.when((Object)itemMock4.getTotalAmount()).thenReturn((Object)new KualiDecimal(1.0));
        this.cmItems.add(itemMock4);
        ArrayList sourceAccountingLinesCopy2 = new ArrayList(new ArrayList());
        Mockito.when((Object)itemMock5.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)itemMock5.getItemType()).thenReturn((Object)addlItem);
        Mockito.when((Object)itemMock5.getItemTypeCode()).thenReturn((Object)addlItem.getItemTypeCode());
        Mockito.when((Object)itemMock5.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7.0));
        Mockito.when((Object)itemMock5.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3.0));
        Mockito.when((Object)itemMock5.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy2);
        Mockito.when((Object)itemMock5.getTotalAmount()).thenReturn((Object)new KualiDecimal(10.0));
        itemMock5.setItemOutstandingEncumberedAmount(new KualiDecimal(8.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock5)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock5.setItemInvoicedTotalAmount(new KualiDecimal(2.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock5)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock5);
        Mockito.when((Object)itemMock6.getItemLineNumber()).thenReturn((Object)4);
        Mockito.when((Object)itemMock6.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock6.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.0));
        this.cmItems.add(itemMock6);
        ArrayList sourceAccountingLinesCopy3 = new ArrayList(new ArrayList());
        Mockito.when((Object)itemMock7.getItemLineNumber()).thenReturn((Object)4);
        Mockito.when((Object)itemMock7.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock7.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(6.0));
        Mockito.when((Object)itemMock7.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)itemMock7.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy3);
        Mockito.when((Object)itemMock7.getTotalAmount()).thenReturn((Object)new KualiDecimal(10.0));
        itemMock7.setItemOutstandingEncumberedAmount(new KualiDecimal(8.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock7)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock7.setItemInvoicedTotalAmount(new KualiDecimal(2.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock7)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock7);
        Mockito.when((Object)itemMock8.getItemLineNumber()).thenReturn((Object)5);
        Mockito.when((Object)itemMock8.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)itemMock8.getTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)itemMock8.getItemQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        this.cmItems.add(itemMock8);
        ArrayList sourceAccountingLinesCopy4 = new ArrayList(new ArrayList());
        Mockito.when((Object)itemMock9.getItemLineNumber()).thenReturn((Object)5);
        Mockito.when((Object)itemMock9.getItemType()).thenReturn((Object)lineItemQty);
        Mockito.when((Object)itemMock9.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(1.0));
        Mockito.when((Object)itemMock9.getItemOutstandingEncumberedQuantity()).thenReturn((Object)new KualiDecimal(3.0));
        Mockito.when((Object)itemMock9.getItemUnitPrice()).thenReturn((Object)new BigDecimal("2.5"));
        Mockito.when((Object)itemMock9.getItemTaxAmount()).thenReturn((Object)new KualiDecimal(0.4));
        Mockito.when((Object)itemMock9.getItemQuantity()).thenReturn((Object)new KualiDecimal(4.0));
        Mockito.when((Object)itemMock9.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7.8));
        Mockito.when((Object)itemMock9.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(2.5));
        Mockito.when((Object)itemMock9.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy4);
        itemMock9.setItemInvoicedTotalQuantity(new KualiDecimal(0.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock9)).setItemInvoicedTotalQuantity((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock9.setItemOutstandingEncumberedQuantity(new KualiDecimal(4.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock9)).setItemOutstandingEncumberedQuantity((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock9.setItemOutstandingEncumberedAmount(new KualiDecimal(10.4));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock9)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock9.setItemInvoicedTotalAmount(new KualiDecimal(0.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock9)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock9);
        creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setGeneralLedgerPendingEntries(ArgumentMatchers.anyList());
        Mockito.when((Object)creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)creditMemoDocMock.isSourceVendor()).thenReturn((Object)false);
        Mockito.when((Object)creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)creditMemoDocMock)).thenReturn(null);
        this.preparePO(poMock, "Open");
        Mockito.when((Object)creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        creditMemoDocMock.setGenerateEncumbranceEntries(true);
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setGenerateEncumbranceEntries(ArgumentMatchers.anyBoolean());
        creditMemoDocMock.setDebitCreditCodeForGLEntries("D");
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setDebitCreditCodeForGLEntries(ArgumentMatchers.anyString());
        this.execute(creditMemoDocMock);
    }

    @Test
    void closedPOAccountingLines(@Mock VendorCreditMemoDocument creditMemoDocMock, @Mock PurchaseOrderDocument poMock, @Mock PurchaseOrderAccount accountMock, @Mock PurchaseOrderAccount accountMock1, @Mock PurchaseOrderAccount accountMock2, @Mock PurchaseOrderAccount accountAMock, @Mock PurchaseOrderAccount accountBMock, @Mock CreditMemoItem itemMock, @Mock CreditMemoItem itemMock2, @Mock CreditMemoItem itemMock4, @Mock PurchaseOrderItem itemMock1, @Mock PurchaseOrderItem itemMock3, @Mock PurchaseOrderItem itemMock5) {
        ItemType lineItemAmt = GenerateEntriesCreateCreditMemoTest.createItemType("LINEA", true, false);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        SourceAccountingLine acctString = new SourceAccountingLine();
        acctString.setFinancialObjectCode("A");
        Mockito.when((Object)accountMock.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)accountMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("100"));
        Mockito.when((Object)accountMock.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)accountMock.generateSourceAccountingLine()).thenReturn((Object)acctString);
        accountMock.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(8000.0));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock)).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)accountMock.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(8000.0));
        accountMock.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(8000.0));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock, (VerificationMode)Mockito.atLeastOnce())).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        sourceAccountingLines.add(accountMock);
        Mockito.when((Object)itemMock.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)itemMock.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock.getTotalAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        this.cmItems.add(itemMock);
        ArrayList sourceAccountingLinesCopy = new ArrayList(sourceAccountingLines);
        Mockito.when((Object)itemMock1.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)itemMock1.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock1.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)itemMock1.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)itemMock1.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy);
        Mockito.when((Object)itemMock1.getTotalAmount()).thenReturn((Object)new KualiDecimal(10000.0));
        itemMock1.setItemOutstandingEncumberedAmount(new KualiDecimal(8000.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock1)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock1.setItemInvoicedTotalAmount(new KualiDecimal(2000.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock1)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock1);
        sourceAccountingLines = new ArrayList();
        SourceAccountingLine acctString1 = new SourceAccountingLine();
        acctString1.setFinancialObjectCode("B");
        Mockito.when((Object)accountMock1.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)accountMock1.getAccountLinePercent()).thenReturn((Object)new BigDecimal("50"));
        Mockito.when((Object)accountMock1.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(3500.0));
        Mockito.when((Object)accountMock1.generateSourceAccountingLine()).thenReturn((Object)acctString1);
        accountMock1.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(4000.0));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock1)).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        sourceAccountingLines.add(accountMock1);
        sourceAccountingLines.add(GenerateEntriesCreateCreditMemoTest.createPoAccountingLine(accountAMock, 50.0, 3500.0, 4000.0, 4000.0, "C"));
        Mockito.when((Object)itemMock2.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)itemMock2.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock2.getTotalAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        this.cmItems.add(itemMock2);
        ArrayList sourceAccountingLinesCopy1 = new ArrayList(sourceAccountingLines);
        Mockito.when((Object)itemMock3.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)itemMock3.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock3.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)itemMock3.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)itemMock3.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy1);
        Mockito.when((Object)itemMock3.getTotalAmount()).thenReturn((Object)new KualiDecimal(10000.0));
        itemMock3.setItemOutstandingEncumberedAmount(new KualiDecimal(8000.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock3)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock3.setItemInvoicedTotalAmount(new KualiDecimal(2000.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock3)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock3);
        sourceAccountingLines = new ArrayList();
        SourceAccountingLine acctString2 = new SourceAccountingLine();
        acctString2.setFinancialObjectCode("C");
        Mockito.when((Object)accountMock2.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)accountMock2.getAccountLinePercent()).thenReturn((Object)new BigDecimal("66.66"));
        Mockito.when((Object)accountMock2.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(4666.2));
        Mockito.when((Object)accountMock2.generateSourceAccountingLine()).thenReturn((Object)acctString2);
        accountMock2.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(5332.8));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock2)).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        sourceAccountingLines.add(accountMock2);
        sourceAccountingLines.add(GenerateEntriesCreateCreditMemoTest.createPoAccountingLine(accountBMock, 33.33, 2333.8, 2667.1, 2667.2, "D"));
        Mockito.when((Object)itemMock4.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)itemMock4.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock4.getTotalAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        this.cmItems.add(itemMock4);
        ArrayList sourceAccountingLinesCopy2 = new ArrayList(sourceAccountingLines);
        Mockito.when((Object)itemMock5.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)itemMock5.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock5.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)itemMock5.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)itemMock5.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy2);
        Mockito.when((Object)itemMock5.getTotalAmount()).thenReturn((Object)new KualiDecimal(10000.0));
        itemMock5.setItemOutstandingEncumberedAmount(new KualiDecimal(8000.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock5)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock5.setItemInvoicedTotalAmount(new KualiDecimal(2000.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock5)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock5);
        creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setGeneralLedgerPendingEntries(ArgumentMatchers.anyList());
        Mockito.when((Object)creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)creditMemoDocMock.isSourceVendor()).thenReturn((Object)false);
        Mockito.when((Object)creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)creditMemoDocMock)).thenReturn(null);
        this.preparePO(poMock, "Closed");
        Mockito.when((Object)creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.execute(creditMemoDocMock);
    }

    @Test
    void openPOAccountingLines(@Mock VendorCreditMemoDocument creditMemoDocMock, @Mock PurchaseOrderDocument poMock, @Mock PurchaseOrderAccount accountMock, @Mock PurchaseOrderAccount accountMock1, @Mock PurchaseOrderAccount accountMock2, @Mock PurchaseOrderAccount accountAMock, @Mock PurchaseOrderAccount accountBMock, @Mock CreditMemoItem itemMock, @Mock CreditMemoItem itemMock2, @Mock CreditMemoItem itemMock4, @Mock PurchaseOrderItem itemMock1, @Mock PurchaseOrderItem itemMock3, @Mock PurchaseOrderItem itemMock5) {
        ItemType lineItemAmt = GenerateEntriesCreateCreditMemoTest.createItemType("LINEA", true, false);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        SourceAccountingLine acctString = new SourceAccountingLine();
        acctString.setFinancialObjectCode("A");
        Mockito.when((Object)accountMock.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)accountMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("100"));
        Mockito.when((Object)accountMock.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)accountMock.generateSourceAccountingLine()).thenReturn((Object)acctString);
        accountMock.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(8000.0));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock)).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)accountMock.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(8000.0));
        accountMock.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(8000.0));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock, (VerificationMode)Mockito.atLeastOnce())).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        sourceAccountingLines.add(accountMock);
        Mockito.when((Object)itemMock.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)itemMock.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock.getTotalAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        this.cmItems.add(itemMock);
        ArrayList sourceAccountingLinesCopy = new ArrayList(sourceAccountingLines);
        Mockito.when((Object)itemMock1.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)itemMock1.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock1.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)itemMock1.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)itemMock1.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy);
        Mockito.when((Object)itemMock1.getTotalAmount()).thenReturn((Object)new KualiDecimal(10000.0));
        itemMock1.setItemOutstandingEncumberedAmount(new KualiDecimal(8000.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock1)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock1.setItemInvoicedTotalAmount(new KualiDecimal(2000.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock1)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock1);
        sourceAccountingLines = new ArrayList();
        SourceAccountingLine acctString5 = new SourceAccountingLine();
        acctString5.setFinancialObjectCode("B");
        Mockito.when((Object)accountMock1.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)accountMock1.getAccountLinePercent()).thenReturn((Object)new BigDecimal("50"));
        Mockito.when((Object)accountMock1.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(3500.0));
        Mockito.when((Object)accountMock1.generateSourceAccountingLine()).thenReturn((Object)acctString5);
        accountMock1.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(4000.0));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock1)).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        sourceAccountingLines.add(accountMock1);
        sourceAccountingLines.add(GenerateEntriesCreateCreditMemoTest.createPoAccountingLine(accountAMock, 50.0, 3500.0, 4000.0, 4000.0, "C"));
        Mockito.when((Object)itemMock2.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)itemMock2.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock2.getTotalAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        this.cmItems.add(itemMock2);
        ArrayList sourceAccountingLinesCopy1 = new ArrayList(sourceAccountingLines);
        Mockito.when((Object)itemMock3.getItemLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)itemMock3.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock3.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)itemMock3.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)itemMock3.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy1);
        Mockito.when((Object)itemMock3.getTotalAmount()).thenReturn((Object)new KualiDecimal(10000.0));
        itemMock3.setItemOutstandingEncumberedAmount(new KualiDecimal(8000.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock3)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock3.setItemInvoicedTotalAmount(new KualiDecimal(2000.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock3)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock3);
        sourceAccountingLines = new ArrayList();
        SourceAccountingLine acctString6 = new SourceAccountingLine();
        acctString6.setFinancialObjectCode("C");
        Mockito.when((Object)accountMock2.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)accountMock2.getAccountLinePercent()).thenReturn((Object)new BigDecimal("66.66"));
        Mockito.when((Object)accountMock2.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(4666.2));
        Mockito.when((Object)accountMock2.generateSourceAccountingLine()).thenReturn((Object)acctString6);
        accountMock2.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(5332.8));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock2)).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        sourceAccountingLines.add(accountMock2);
        sourceAccountingLines.add(GenerateEntriesCreateCreditMemoTest.createPoAccountingLine(accountBMock, 33.33, 2333.8, 2667.1, 2667.2, "D"));
        Mockito.when((Object)itemMock4.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)itemMock4.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock4.getTotalAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        this.cmItems.add(itemMock4);
        ArrayList sourceAccountingLinesCopy2 = new ArrayList(sourceAccountingLines);
        Mockito.when((Object)itemMock5.getItemLineNumber()).thenReturn((Object)3);
        Mockito.when((Object)itemMock5.getItemType()).thenReturn((Object)lineItemAmt);
        Mockito.when((Object)itemMock5.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(7000.0));
        Mockito.when((Object)itemMock5.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)itemMock5.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy2);
        Mockito.when((Object)itemMock5.getTotalAmount()).thenReturn((Object)new KualiDecimal(10000.0));
        itemMock5.setItemOutstandingEncumberedAmount(new KualiDecimal(8000.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock5)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock5.setItemInvoicedTotalAmount(new KualiDecimal(2000.0));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock5)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.poItems.add(itemMock5);
        SourceAccountingLine acctString1 = new SourceAccountingLine();
        acctString1.setFinancialObjectCode("A");
        acctString1.setAmount(new KualiDecimal(1000));
        SourceAccountingLine acctString2 = new SourceAccountingLine();
        acctString2.setFinancialObjectCode("B");
        acctString2.setAmount(new KualiDecimal(500));
        SourceAccountingLine acctString3 = new SourceAccountingLine();
        acctString3.setFinancialObjectCode("C");
        acctString3.setAmount(new KualiDecimal(1166.6));
        SourceAccountingLine acctString4 = new SourceAccountingLine();
        acctString4.setFinancialObjectCode("D");
        acctString4.setAmount(new KualiDecimal(333.4));
        Mockito.when((Object)creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)acctString1), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)acctString2), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)acctString3), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)acctString4), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setGeneralLedgerPendingEntries(ArgumentMatchers.anyList());
        Mockito.when((Object)creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)creditMemoDocMock.isSourceVendor()).thenReturn((Object)false);
        Mockito.when((Object)creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)creditMemoDocMock)).thenReturn(null);
        this.preparePO(poMock, "Open");
        Mockito.when((Object)creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        creditMemoDocMock.setGenerateEncumbranceEntries(true);
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setGenerateEncumbranceEntries(ArgumentMatchers.anyBoolean());
        creditMemoDocMock.setDebitCreditCodeForGLEntries("D");
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setDebitCreditCodeForGLEntries(ArgumentMatchers.anyString());
        this.execute(creditMemoDocMock);
    }

    @Test
    void summaryAccountHandling(@Mock VendorCreditMemoDocument creditMemoDocMock, @Mock SummaryAccount summaryAccountMock) {
        ArrayList<SummaryAccount> summaryAccounts = new ArrayList<SummaryAccount>();
        SourceAccountingLine account = new SourceAccountingLine();
        Mockito.when((Object)summaryAccountMock.getAccount()).thenReturn((Object)account);
        summaryAccounts.add(summaryAccountMock);
        creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setGeneralLedgerPendingEntries(ArgumentMatchers.anyList());
        Mockito.when((Object)creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)creditMemoDocMock.isSourceVendor()).thenReturn((Object)true);
        Mockito.when((Object)creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)creditMemoDocMock.getPostingYearFromPendingGLEntries()).thenReturn((Object)2015);
        Mockito.when((Object)creditMemoDocMock.getPostingPeriodCodeFromPendingGLEntries()).thenReturn((Object)"01");
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)creditMemoDocMock)).thenReturn(summaryAccounts);
        creditMemoDocMock.setGenerateEncumbranceEntries(false);
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setGenerateEncumbranceEntries(ArgumentMatchers.anyBoolean());
        creditMemoDocMock.setDebitCreditCodeForGLEntries("C");
        ((VendorCreditMemoDocument)Mockito.verify((Object)creditMemoDocMock)).setDebitCreditCodeForGLEntries(ArgumentMatchers.anyString());
        Mockito.when((Object)creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)account), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.purapAccountingSvcMock.generateUseTaxAccount((PurchasingAccountsPayableDocument)creditMemoDocMock)).thenReturn(new ArrayList());
        this.purapAccountRevisionSvcMock.saveCreditMemoAccountRevisions(new ArrayList(), Integer.valueOf(2015), "01");
        ((PurapAccountRevisionService)Mockito.verify((Object)this.purapAccountRevisionSvcMock)).saveCreditMemoAccountRevisions(ArgumentMatchers.anyList(), Integer.valueOf(ArgumentMatchers.anyInt()), ArgumentMatchers.anyString());
        this.execute(creditMemoDocMock);
    }
}

