/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class GenerateEntriesReopenPurchaseOrderTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private GeneralLedgerPendingEntryService glPendingEntrySvcMock;
    @Mock
    private BusinessObjectService boServiceMock;

    GenerateEntriesReopenPurchaseOrderTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setGeneralLedgerPendingEntryService(this.glPendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
    }

    private void execute(PurchaseOrderDocument poMock) {
        this.cut.generateEntriesReopenPurchaseOrder(poMock);
        ((PurchaseOrderDocument)Mockito.verify((Object)poMock, (VerificationMode)Mockito.times((int)2))).getItems();
        ((PurchaseOrderDocument)Mockito.verify((Object)poMock)).getItemsActiveOnly();
        ((PurchaseOrderDocument)Mockito.verify((Object)poMock, (VerificationMode)Mockito.times((int)2))).setGlOnlySourceAccountingLines(ArgumentMatchers.anyList());
        ((PurchaseOrderDocument)Mockito.verify((Object)poMock)).getGlOnlySourceAccountingLines();
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).generateSummaryWithNoZeroTotalsUsingAlternateAmount(ArgumentMatchers.anyList());
    }

    private void baseExpectations(PurchaseOrderDocument poMock, List<PurApItem> items, List<PurApItem> activeItems, List<SourceAccountingLine> sourceAccountingLines) {
        Mockito.when((Object)poMock.getItems()).thenReturn(items);
        Mockito.when((Object)poMock.getItemsActiveOnly()).thenReturn(activeItems);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsUsingAlternateAmount(activeItems)).thenReturn(sourceAccountingLines);
        poMock.setGlOnlySourceAccountingLines(sourceAccountingLines);
        Mockito.when((Object)poMock.getGlOnlySourceAccountingLines()).thenReturn(sourceAccountingLines);
    }

    private static void mockQuantityBasedItem(PurchaseOrderItem item, int original, int invoiced, double unitPrice) {
        int remaining = original - invoiced;
        double outstandingAmount = unitPrice * (double)remaining;
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(true);
        Mockito.when((Object)item.getItemType()).thenReturn((Object)itemType);
        Mockito.when((Object)item.getItemQuantity()).thenReturn((Object)new KualiDecimal(original));
        Mockito.when((Object)item.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(invoiced));
        item.setItemOutstandingEncumberedQuantity(new KualiDecimal(remaining));
        ((PurchaseOrderItem)Mockito.verify((Object)item)).setItemOutstandingEncumberedQuantity((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)item.getItemOutstandingEncumberedQuantity()).thenReturn((Object)new KualiDecimal(remaining));
        Mockito.when((Object)item.getItemUnitPrice()).thenReturn((Object)new BigDecimal(unitPrice));
        item.setItemOutstandingEncumberedAmount(new KualiDecimal(outstandingAmount));
        ((PurchaseOrderItem)Mockito.verify((Object)item)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)item.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(outstandingAmount));
        Mockito.when((Object)item.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)item.isItemActiveIndicator()).thenReturn((Object)true);
    }

    private static void mockAmountBasedItem(PurchaseOrderItem item, double total, double invoiced) {
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(false);
        Mockito.when((Object)item.getItemType()).thenReturn((Object)itemType);
        Mockito.when((Object)item.getTotalAmount()).thenReturn((Object)new KualiDecimal(total));
        Mockito.when((Object)item.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(invoiced));
        item.setItemOutstandingEncumberedAmount(new KualiDecimal(total - invoiced));
        ((PurchaseOrderItem)Mockito.verify((Object)item)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)item.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(total - invoiced));
        Mockito.when((Object)item.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)item.isItemActiveIndicator()).thenReturn((Object)true);
    }

    private static PurchaseOrderAccount mockAccountingLine(PurchaseOrderAccount accountingLine, double percent, double amount, Double altAmount) {
        Mockito.when((Object)accountingLine.getAccountLinePercent()).thenReturn((Object)new BigDecimal(percent));
        accountingLine.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(amount));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountingLine)).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)accountingLine.isEmpty()).thenReturn((Object)false);
        accountingLine.setAlternateAmountForGLEntryCreation(new KualiDecimal(amount));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountingLine)).setAlternateAmountForGLEntryCreation((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        if (altAmount != null) {
            Mockito.when((Object)accountingLine.getAlternateAmountForGLEntryCreation()).thenReturn((Object)new KualiDecimal(amount));
            accountingLine.setAlternateAmountForGLEntryCreation(new KualiDecimal(altAmount.doubleValue()));
            ((PurchaseOrderAccount)Mockito.verify((Object)accountingLine, (VerificationMode)Mockito.times((int)2))).setAlternateAmountForGLEntryCreation((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
            Mockito.when((Object)accountingLine.getAlternateAmountForGLEntryCreation()).thenReturn((Object)new KualiDecimal(altAmount.doubleValue()));
        }
        return accountingLine;
    }

    @Test
    void noItems(@Mock PurchaseOrderDocument poMock) {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> sourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.baseExpectations(poMock, items, items, sourceAccountingLines);
        this.execute(poMock);
    }

    @Test
    void quantityBasedItem(@Mock PurchaseOrderDocument poMock, @Mock PurchaseOrderItem itemMock, @Mock PurchaseOrderAccount accountingLineMock1) {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        GenerateEntriesReopenPurchaseOrderTest.mockQuantityBasedItem(itemMock, 7, 4, 10.0);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        sourceAccountingLines.add(GenerateEntriesReopenPurchaseOrderTest.mockAccountingLine(accountingLineMock1, 100.0, 30.0, 30.0));
        Mockito.when((Object)itemMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        items.add((PurApItem)itemMock);
        ArrayList<SourceAccountingLine> glOnlySourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.baseExpectations(poMock, items, items, glOnlySourceAccountingLines);
        this.execute(poMock);
    }

    @Test
    void amountBasedItem(@Mock PurchaseOrderDocument poMock, @Mock PurchaseOrderItem itemMock, @Mock PurchaseOrderAccount accountingLineMock1) {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        GenerateEntriesReopenPurchaseOrderTest.mockAmountBasedItem(itemMock, 70.0, 40.0);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        sourceAccountingLines.add(GenerateEntriesReopenPurchaseOrderTest.mockAccountingLine(accountingLineMock1, 100.0, 30.0, 30.0));
        Mockito.when((Object)itemMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        items.add((PurApItem)itemMock);
        ArrayList<SourceAccountingLine> glOnlySourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.baseExpectations(poMock, items, items, glOnlySourceAccountingLines);
        this.execute(poMock);
    }

    @Test
    void multipleAccountingLines(@Mock PurchaseOrderDocument poMock, @Mock PurchaseOrderItem itemMock, @Mock PurchaseOrderAccount accountingLineMock1, @Mock PurchaseOrderAccount accountingLineMock2) {
        GenerateEntriesReopenPurchaseOrderTest.mockAmountBasedItem(itemMock, 70.0, 30.0);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        sourceAccountingLines.add(GenerateEntriesReopenPurchaseOrderTest.mockAccountingLine(accountingLineMock1, 66.66, 26.66, null));
        sourceAccountingLines.add(GenerateEntriesReopenPurchaseOrderTest.mockAccountingLine(accountingLineMock2, 33.33, 13.33, 13.34));
        Mockito.when((Object)accountingLineMock2.compareTo(ArgumentMatchers.isA(PurchaseOrderAccount.class))).thenReturn((Object)0);
        Mockito.when((Object)itemMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        items.add((PurApItem)itemMock);
        ArrayList<SourceAccountingLine> glOnlySourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.baseExpectations(poMock, items, items, glOnlySourceAccountingLines);
        this.execute(poMock);
    }

    @Test
    void shouldNotCreateGlPEs(@Mock PurchaseOrderDocument poMock, @Mock PurchaseOrderAccount accountingLineMock1) {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> sourceAccountingLines = new ArrayList<SourceAccountingLine>();
        Mockito.when((Object)accountingLineMock1.getAmount()).thenReturn((Object)KualiDecimal.ZERO);
        sourceAccountingLines.add((SourceAccountingLine)accountingLineMock1);
        this.baseExpectations(poMock, items, items, sourceAccountingLines);
        this.execute(poMock);
    }

    @Test
    void shouldCreateGLPEs(@Mock PurchaseOrderDocument poMock, @Mock PurchaseOrderAccount accountingLineMock1) {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> sourceAccountingLines = new ArrayList<SourceAccountingLine>();
        Mockito.when((Object)accountingLineMock1.getAmount()).thenReturn((Object)new KualiDecimal(100.0));
        sourceAccountingLines.add((SourceAccountingLine)accountingLineMock1);
        this.baseExpectations(poMock, items, items, sourceAccountingLines);
        Mockito.when((Object)this.glPendingEntrySvcMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)poMock)).thenReturn((Object)true);
        ArrayList glpes = new ArrayList();
        Mockito.when((Object)poMock.getGeneralLedgerPendingEntries()).thenReturn(glpes);
        Mockito.when((Object)this.boServiceMock.save(glpes)).thenReturn(null);
        this.execute(poMock);
    }
}

