/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util.cxml;

import java.math.BigDecimal;
import java.util.List;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCart;
import org.kuali.kfs.module.purap.util.cxml.Classification;
import org.kuali.kfs.module.purap.util.cxml.CxmlExtrinsic;
import org.kuali.kfs.module.purap.util.cxml.CxmlHeader;
import org.kuali.kfs.module.purap.util.cxml.Description;
import org.kuali.kfs.module.purap.util.cxml.ItemDetail;
import org.kuali.kfs.module.purap.util.cxml.ItemIn;
import org.kuali.kfs.module.purap.util.cxml.Message;
import org.kuali.kfs.module.purap.util.cxml.PunchOutOrderMessage;
import org.kuali.kfs.module.purap.util.cxml.PunchOutOrderMessageHeader;
import org.kuali.kfs.module.purap.util.cxml.Sender;
import org.kuali.kfs.module.purap.util.cxml.UnitPrice;
import org.springframework.test.util.ReflectionTestUtils;

public final class B2BShoppingCartTestHelper {
    static final String B2B_XML_FILE_PATH = "org/kuali/kfs/module/purap/fixture/b2bShoppingCartSample.xml";
    static final String B2B_PUNCH_OUT_ORDER_XSD = "classpath:org/kuali/kfs/module/purap/util/cxml/b2bPunchOutOrder.xsd";
    static final String CLASSPATH_URL_PREFIX = "classpath:";

    private B2BShoppingCartTestHelper() {
    }

    static B2BShoppingCart getExpectedShoppingCart() {
        B2BShoppingCart expectedShoppingCart = new B2BShoppingCart();
        CxmlHeader cxmlHeader = new CxmlHeader();
        cxmlHeader.setFrom("DUNS", "15996366-t");
        cxmlHeader.setTo("NetworkId", "");
        cxmlHeader.setSender(new Sender("DUNS", "15996367-t", "SciQuest"));
        expectedShoppingCart.setCxmlHeader(cxmlHeader);
        Message expectedMessage = new Message();
        expectedMessage.setStatus(new Message.Status("200", "Success", "Success"));
        PunchOutOrderMessage punchOutOrderMessage = new PunchOutOrderMessage();
        punchOutOrderMessage.setBuyerCookie("KHUNTLEY");
        PunchOutOrderMessageHeader punchOutOrderMessageHeader = new PunchOutOrderMessageHeader();
        punchOutOrderMessageHeader.setTotal(new PunchOutOrderMessageHeader.Total("USD", new BigDecimal("1462.70")));
        punchOutOrderMessageHeader.setOperationAllowed("edit");
        punchOutOrderMessageHeader.setQuoteStatus("final");
        punchOutOrderMessage.setPunchOutOrderMessageHeader(punchOutOrderMessageHeader);
        punchOutOrderMessage.getItemInList().add(B2BShoppingCartTestHelper.getExpectedItemIn());
        expectedMessage.setPunchOutOrderMessage(punchOutOrderMessage);
        expectedShoppingCart.setMessage(expectedMessage);
        return expectedShoppingCart;
    }

    private static ItemIn getExpectedItemIn() {
        ItemIn expectedItemIn = new ItemIn();
        expectedItemIn.setQuantity(Long.valueOf(1L));
        expectedItemIn.setItemID(new ItemIn.ItemID("30734195", "032734ed-bdcb-4539-b2b9-a5a7b6dd221a"));
        ItemDetail expectedItemDetail = new ItemDetail();
        expectedItemDetail.setUnitPrice(new UnitPrice("USD", new BigDecimal("1462.70")));
        expectedItemDetail.setDescription(new Description("en", "Microsoft Surface Book Core i7 32GB 1TB"));
        expectedItemDetail.setUnitOfMeasure("EA");
        ReflectionTestUtils.setField((Object)expectedItemDetail, (String)"extrinsic", B2BShoppingCartTestHelper.getExpectedExtrinsics());
        ReflectionTestUtils.setField((Object)expectedItemDetail, (String)"classification", B2BShoppingCartTestHelper.getExpectedClassifications());
        expectedItemIn.setItemDetail(expectedItemDetail);
        expectedItemIn.getSupplierID().add(new ItemIn.SupplierID("DUNS", "4005-0"));
        expectedItemIn.getSupplierID().add(new ItemIn.SupplierID("SystemSupplierID", "4059703"));
        return expectedItemIn;
    }

    private static List<CxmlExtrinsic> getExpectedExtrinsics() {
        return List.of(new CxmlExtrinsic("ExternalSupplierId", "4005-0"), new CxmlExtrinsic("Product Source", "Punchout"), new CxmlExtrinsic("CartName", "Super Shopping Cart"), new CxmlExtrinsic("SystemInfo", "Req1641090-5151628"), new CxmlExtrinsic("CartID", "1641090"), new CxmlExtrinsic("CartLineId", "5151628"), new CxmlExtrinsic("SystemProductID"), new CxmlExtrinsic("Shipping", "0.00"));
    }

    private static List<Classification> getExpectedClassifications() {
        return List.of(new Classification("SPSC", "43211503"), new Classification("UNSPSC", "43211503"), new Classification("CommodityCode"), new Classification("Controlled", "false"), new Classification("Green", "false"), new Classification("Hazardous", "false"), new Classification("Radioactive", "false"), new Classification("RadioactiveMinor", "false"), new Classification("SelectAgent", "false"), new Classification("Toxin", "false"), new Classification("EnergyStar", "false"), new Classification("GreenProduct", "false"));
    }
}

