/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.document;

import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.module.purap.PurchaseOrderStatuses;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.context.SpringContext;

public class PurchaseOrderPaymentHoldDocument extends PurchaseOrderDocument {

    /**
     * General Ledger pending entries are not created for this document. Overriding this method so that entries are
     * not created.
     */
    @Override
    public void customPrepareForSave(KualiDocumentEvent event) {
        // do not set the accounts in sourceAccountingLines; this document should not create GL entries
    }

    /**
     * When Purchase Order Payment Hold document has been Processed through Workflow, the PO status changes to
     * "Payment Hold".
     */
    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);

        // DOCUMENT PROCESSED
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            SpringContext.getBean(PurchaseOrderService.class)
                    .setCurrentAndPendingIndicatorsForApprovedPODocuments(this);

            // for app doc status
            updateAndSaveAppDocStatus(PurchaseOrderStatuses.APPDOC_PAYMENT_HOLD);
        } else if (this.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
            // DOCUMENT DISAPPROVED
            SpringContext.getBean(PurchaseOrderService.class)
                    .setCurrentAndPendingIndicatorsForDisapprovedChangePODocuments(this);

            // for app doc status
            String nodeName = SpringContext.getBean(WorkflowDocumentService.class).getCurrentRouteLevelName(
                    this.getDocumentHeader().getWorkflowDocument());
            String reqStatus = PurchaseOrderStatuses.getPurchaseOrderAppDocDisapproveStatuses()
                    .get(nodeName);
            updateAndSaveAppDocStatus(PurchaseOrderStatuses
                    .getPurchaseOrderAppDocDisapproveStatuses().get(reqStatus));

        } else if (this.getDocumentHeader().getWorkflowDocument().isCanceled()) {
            // DOCUMENT CANCELED
            SpringContext.getBean(PurchaseOrderService.class)
                    .setCurrentAndPendingIndicatorsForCancelledChangePODocuments(this);
            // for app doc status
            updateAndSaveAppDocStatus(PurchaseOrderStatuses.APPDOC_CANCELLED);
        }
    }

    @Override
    protected boolean shouldAdhocFyi() {
        return false;
    }
}
