/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.document;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.module.purap.businessobject.BillingAddress;
import org.kuali.kfs.module.purap.businessobject.CapitalAssetSystemState;
import org.kuali.kfs.module.purap.businessobject.CapitalAssetSystemType;
import org.kuali.kfs.module.purap.businessobject.DeliveryRequiredDateReason;
import org.kuali.kfs.module.purap.businessobject.FundingSource;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderTransmissionMethod;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItem;
import org.kuali.kfs.module.purap.businessobject.ReceivingAddress;
import org.kuali.kfs.module.purap.businessobject.RecurringPaymentType;
import org.kuali.kfs.module.purap.businessobject.RequisitionSource;
import org.kuali.kfs.module.purap.document.service.PurchasingDocumentSpecificService;
import org.kuali.kfs.module.purap.util.ItemParser;
import org.kuali.kfs.vnd.businessobject.CampusParameter;
import org.kuali.kfs.vnd.businessobject.PurchaseOrderCostSource;
import org.kuali.kfs.vnd.businessobject.VendorContract;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.sql.Date;
import java.util.List;

/**
 * Interface for Purchasing Documents.
 */
public interface PurchasingDocument extends PurchasingAccountsPayableDocument {

    /**
     * @return appropriate ItemParser instance for this {@code PurchasingDocument}.
     */
    ItemParser getItemParser();

    String getDocumentFundingSourceCode();

    void setDocumentFundingSourceCode(String fundingSourceCode);

    String getRequisitionSourceCode();

    void setRequisitionSourceCode(String requisitionSourceCode);

    String getPurchaseOrderTransmissionMethodCode();

    void setPurchaseOrderTransmissionMethodCode(String purchaseOrderTransmissionMethodCode);

    String getPurchaseOrderCostSourceCode();

    void setPurchaseOrderCostSourceCode(String purchaseOrderCostSourceCode);

    String getDeliveryRequiredDateReasonCode();

    void setDeliveryRequiredDateReasonCode(String deliveryRequiredDateReasonCode);

    String getRecurringPaymentTypeCode();

    void setRecurringPaymentTypeCode(String recurringPaymentTypeCode);

    String getChartOfAccountsCode();

    void setChartOfAccountsCode(String chartOfAccountsCode);

    String getOrganizationCode();

    void setOrganizationCode(String organizationCode);

    String getDeliveryCampusCode();

    void setDeliveryCampusCode(String deliveryCampusCode);

    KualiDecimal getPurchaseOrderTotalLimit();

    void setPurchaseOrderTotalLimit(KualiDecimal purchaseOrderTotalLimit);

    String getVendorName();

    void setVendorName(String vendorName);

    String getVendorLine1Address();

    void setVendorLine1Address(String vendorLine1Address);

    String getVendorLine2Address();

    void setVendorLine2Address(String vendorLine2Address);

    String getVendorCityName();

    void setVendorCityName(String vendorCityName);

    String getVendorStateCode();

    void setVendorStateCode(String vendorStateCode);

    String getVendorPostalCode();

    void setVendorPostalCode(String vendorPostalCode);

    String getVendorCountryCode();

    void setVendorCountryCode(String vendorCountryCode);

    Boolean getVendorRestrictedIndicator();

    void setVendorRestrictedIndicator(Boolean vendorRestrictedIndicator);

    String getVendorPhoneNumber();

    void setVendorPhoneNumber(String vendorPhoneNumber);

    String getVendorFaxNumber();

    void setVendorFaxNumber(String vendorFaxNumber);

    Integer getVendorContractGeneratedIdentifier();

    void setVendorContractGeneratedIdentifier(Integer vendorContractGeneratedIdentifier);

    String getVendorNoteText();

    void setVendorNoteText(String vendorNoteText);

    String getRequestorPersonName();

    void setRequestorPersonName(String requestorPersonName);

    String getRequestorPersonEmailAddress();

    void setRequestorPersonEmailAddress(String requestorPersonEmailAddress);

    String getRequestorPersonPhoneNumber();

    void setRequestorPersonPhoneNumber(String requestorPersonPhoneNumber);

    String getNonInstitutionFundOrgChartOfAccountsCode();

    void setNonInstitutionFundOrgChartOfAccountsCode(String nonInstitutionFundOrgChartOfAccountsCode);

    String getNonInstitutionFundOrganizationCode();

    void setNonInstitutionFundOrganizationCode(String nonInstitutionFundOrganizationCode);

    String getNonInstitutionFundChartOfAccountsCode();

    void setNonInstitutionFundChartOfAccountsCode(String nonInstitutionFundChartOfAccountsCode);

    String getNonInstitutionFundAccountNumber();

    void setNonInstitutionFundAccountNumber(String nonInstitutionFundAccountNumber);

    String getDeliveryBuildingCode();

    void setDeliveryBuildingCode(String deliveryBuildingCode);

    String getDeliveryBuildingName();

    void setDeliveryBuildingName(String deliveryBuildingName);

    String getDeliveryBuildingRoomNumber();

    void setDeliveryBuildingRoomNumber(String deliveryBuildingRoomNumber);

    String getDeliveryBuildingLine1Address();

    void setDeliveryBuildingLine1Address(String deliveryBuildingLine1Address);

    String getDeliveryBuildingLine2Address();

    void setDeliveryBuildingLine2Address(String deliveryBuildingLine2Address);

    String getDeliveryCityName();

    void setDeliveryCityName(String deliveryCityName);

    String getDeliveryStateCode();

    void setDeliveryStateCode(String deliveryStateCode);

    String getDeliveryPostalCode();

    void setDeliveryPostalCode(String deliveryPostalCode);

    String getDeliveryCountryCode();

    String getDeliveryCountryName();

    void setDeliveryCountryCode(String deliveryCountryCode);

    String getDeliveryToName();

    void setDeliveryToName(String deliveryToName);

    String getDeliveryToEmailAddress();

    void setDeliveryToEmailAddress(String deliveryToEmailAddress);

    String getDeliveryToPhoneNumber();

    void setDeliveryToPhoneNumber(String deliveryToPhoneNumber);

    Date getDeliveryRequiredDate();

    void setDeliveryRequiredDate(Date deliveryRequiredDate);

    String getDeliveryInstructionText();

    void setDeliveryInstructionText(String deliveryInstructionText);

    Date getPurchaseOrderBeginDate();

    void setPurchaseOrderBeginDate(Date purchaseOrderBeginDate);

    Date getPurchaseOrderEndDate();

    void setPurchaseOrderEndDate(Date purchaseOrderEndDate);

    String getInstitutionContactName();

    void setInstitutionContactName(String institutionContactName);

    String getInstitutionContactPhoneNumber();

    void setInstitutionContactPhoneNumber(String institutionContactPhoneNumber);

    String getInstitutionContactEmailAddress();

    void setInstitutionContactEmailAddress(String institutionContactEmailAddress);

    String getBillingName();

    void setBillingName(String billingName);

    String getBillingLine1Address();

    void setBillingLine1Address(String billingLine1Address);

    String getBillingLine2Address();

    void setBillingLine2Address(String billingLine2Address);

    String getBillingCityName();

    void setBillingCityName(String billingCityName);

    String getBillingStateCode();

    void setBillingStateCode(String billingStateCode);

    String getBillingPostalCode();

    void setBillingPostalCode(String billingPostalCode);

    String getBillingCountryCode();

    void setBillingCountryCode(String billingCountryCode);

    String getBillingCountryName();

    String getBillingPhoneNumber();

    void setBillingPhoneNumber(String receivingPhoneNumber);

    String getReceivingName();

    void setReceivingName(String receivingName);

    String getReceivingLine1Address();

    void setReceivingLine1Address(String receivingLine1Address);

    String getReceivingLine2Address();

    void setReceivingLine2Address(String receivingLine2Address);

    String getReceivingCityName();

    void setReceivingCityName(String receivingCityName);

    String getReceivingStateCode();

    void setReceivingStateCode(String receivingStateCode);

    String getReceivingPostalCode();

    void setReceivingPostalCode(String receivingPostalCode);

    String getReceivingCountryCode();

    String getReceivingCountryName();

    void setReceivingCountryCode(String receivingCountryCode);

    boolean getAddressToVendorIndicator();

    void setAddressToVendorIndicator(boolean addressToVendorIndicator);

    String getExternalOrganizationB2bSupplierIdentifier();

    void setExternalOrganizationB2bSupplierIdentifier(String externalOrganizationB2bSupplierIdentifier);

    boolean getPurchaseOrderAutomaticIndicator();

    void setPurchaseOrderAutomaticIndicator(boolean purchaseOrderAutomaticIndicator);

    FundingSource getFundingSource();

    void setFundingSource(FundingSource fundingSource);

    RequisitionSource getRequisitionSource();

    void setRequisitionSource(RequisitionSource requisitionSource);

    PurchaseOrderTransmissionMethod getPurchaseOrderTransmissionMethod();

    void setPurchaseOrderTransmissionMethod(PurchaseOrderTransmissionMethod purchaseOrderTransmissionMethod);

    PurchaseOrderCostSource getPurchaseOrderCostSource();

    void setPurchaseOrderCostSource(PurchaseOrderCostSource purchaseOrderCostSource);

    DeliveryRequiredDateReason getDeliveryRequiredDateReason();

    void setDeliveryRequiredDateReason(DeliveryRequiredDateReason deliveryRequiredDateReason);

    RecurringPaymentType getRecurringPaymentType();

    void setRecurringPaymentType(RecurringPaymentType recurringPaymentType);

    Organization getOrganization();

    void setOrganization(Organization organization);

    Chart getChartOfAccounts();

    void setChartOfAccounts(Chart chartOfAccounts);

    CampusParameter getDeliveryCampus();

    void setDeliveryCampus(CampusParameter deliveryCampus);

    Chart getNonInstitutionFundOrgChartOfAccounts();

    void setNonInstitutionFundOrgChartOfAccounts(Chart nonInstitutionFundOrgChartOfAccounts);

    Organization getNonInstitutionFundOrganization();

    void setNonInstitutionFundOrganization(Organization nonInstitutionFundOrganization);

    Account getNonInstitutionFundAccount();

    void setNonInstitutionFundAccount(Account nonInstitutionFundAccount);

    Chart getNonInstitutionFundChartOfAccounts();

    void setNonInstitutionFundChartOfAccounts(Chart nonInstitutionFundChartOfAccounts);

    String getVendorPaymentTermsCode();

    void setVendorPaymentTermsCode(String vendorPaymentTermsCode);

    String getVendorShippingPaymentTermsCode();

    void setVendorShippingPaymentTermsCode(String vendorShippingPaymentTermsCode);

    String getVendorShippingTitleCode();

    void setVendorShippingTitleCode(String vendorShippingTitleCode);

    boolean isDeliveryBuildingOtherIndicator();

    void setDeliveryBuildingOtherIndicator(boolean deliveryBuildingOtherIndicator);

    List<PurApItem> getItems();

    void setItems(List items);

    PurApItem getItem(int pos);

    void addItem(PurApItem item);

    void deleteItem(int lineNum);

    KualiDecimal getTotalDollarAmount();

    /**
     * @param vendorDetail the Vendor Detail to use to set vendor detail fields.
     */
    void templateVendorDetail(VendorDetail vendorDetail);

    /**
     * @param vendorContract the Vendor Contract to use to set vendor contract fields.
     */
    void templateVendorContract(VendorContract vendorContract);

    /**
     * @param billingAddress the Billing Address to use to set the billing address fields.
     */
    void templateBillingAddress(BillingAddress billingAddress);

    /**
     * @param receivingAddress the Receiving Address to use to set the receiving address fields.
     */
    void templateReceivingAddress(ReceivingAddress receivingAddress);

    /**
     * Loads the default receiving address from database corresponding to the chart/org of this document.
     */
    void loadReceivingAddress();

    boolean isReceivingDocumentRequiredIndicator();

    void setReceivingDocumentRequiredIndicator(boolean receivingDocumentRequiredIndicator);

    boolean isPaymentRequestPositiveApprovalIndicator();

    void setPaymentRequestPositiveApprovalIndicator(boolean paymentRequestPositiveApprovalIndicator);

    String getCapitalAssetSystemTypeCode();

    void setCapitalAssetSystemTypeCode(String capitalAssetSystemTypeCode);

    String getCapitalAssetSystemStateCode();

    void setCapitalAssetSystemStateCode(String capitalAssetSystemStateCode);

    CapitalAssetSystemType getCapitalAssetSystemType();

    void setCapitalAssetSystemType(CapitalAssetSystemType capitalAssetSystemType);

    CapitalAssetSystemState getCapitalAssetSystemState();

    void setCapitalAssetSystemState(CapitalAssetSystemState capitalAssetSystemState);

    List<CapitalAssetSystem> getPurchasingCapitalAssetSystems();

    void setPurchasingCapitalAssetSystems(List<CapitalAssetSystem> purchasingCapitalAssetSystems);

    List<PurchasingCapitalAssetItem> getPurchasingCapitalAssetItems();

    void setPurchasingCapitalAssetItems(List<PurchasingCapitalAssetItem> purchasingCapitalAssetItems);

    Class getPurchasingCapitalAssetItemClass();

    Class getPurchasingCapitalAssetSystemClass();

    PurchasingItem getPurchasingItem(Integer itemIdentifier);

    PurchasingCapitalAssetItem getPurchasingCapitalAssetItem(Integer itemIdentifier);

    PurchasingDocumentSpecificService getDocumentSpecificService();

    void clearCapitalAssetFields();

    boolean shouldGiveErrorForEmptyAccountsProration();
}
