/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceContact;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestHeader;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestSummary;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoicePostalAddress;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReason;
import org.kuali.kfs.module.purap.businessobject.jaxb.Header;
import org.kuali.kfs.module.purap.businessobject.jaxb.Request;
import org.kuali.kfs.module.purap.service.ElectronicInvoiceMappingService;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"header", "request"})
@XmlRootElement(name="cXML", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
public class ElectronicInvoice {
    private static final BigDecimal zero = new BigDecimal(0.0);
    public static String INVOICE_AMOUNT_TYPE_CODE_ITEM = "ITEM";
    public static String INVOICE_AMOUNT_TYPE_CODE_TAX = "TAX";
    public static String INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING = "SPHD";
    public static String INVOICE_AMOUNT_TYPE_CODE_SHIPPING = "SHIP";
    public static String INVOICE_AMOUNT_TYPE_CODE_DISCOUNT = "DISC";
    public static String INVOICE_AMOUNT_TYPE_CODE_DEPOSIT = "DPST";
    public static String INVOICE_AMOUNT_TYPE_CODE_DUE = "DUE";
    public static String INVOICE_AMOUNT_TYPE_CODE_EXMT = "EXMT";
    public static boolean FILE_REJECTED = true;
    public static boolean FILE_NOT_REJECTED;
    public static boolean FILE_DOES_CONTAIN_REJECTS;
    public static boolean FILE_DOES_NOT_CONTAIN_REJECTS;
    @XmlElement(name="Header", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", required=true)
    private Header header;
    @XmlElement(name="Request", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", required=true)
    private Request request;
    @XmlAttribute(name="lang", namespace="http://www.w3.org/XML/1998/namespace", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="language")
    private String lang;
    @XmlTransient
    private String customerNumber;
    @XmlTransient
    private String fileName;
    @XmlTransient
    private String dunsNumber;
    @XmlTransient
    private Integer vendorHeaderID;
    @XmlTransient
    private Integer vendorDetailID;
    @XmlTransient
    private String vendorName;
    @XmlTransient
    private boolean fileRejected = FILE_NOT_REJECTED;
    @XmlTransient
    private boolean containsRejects = FILE_DOES_NOT_CONTAIN_REJECTS;
    @XmlTransient
    private List fileRejectReasons = new ArrayList();
    @XmlTransient
    private ElectronicInvoiceDetailRequestHeader invoiceDetailRequestHeader;
    @XmlTransient
    private List<ElectronicInvoiceOrder> invoiceDetailOrders;
    @XmlTransient
    private ElectronicInvoiceDetailRequestSummary invoiceDetailRequestSummary;
    @XmlAttribute(name="version")
    private String version = "1.2.019";
    @XmlAttribute(name="timestamp", required=true)
    private String timestamp;
    @XmlAttribute(name="payloadID", required=true)
    private String payloadID;
    @XmlTransient
    private String deploymentMode = "production";

    private boolean containsLineLevelAmounts() {
        return this.getInvoiceDetailRequestHeader().isShippingInLine() || this.getInvoiceDetailRequestHeader().isSpecialHandlingInLine() || this.getInvoiceDetailRequestHeader().isTaxInLine() || this.getInvoiceDetailRequestHeader().isDiscountInLine();
    }

    public void addFileRejectReasonToList(ElectronicInvoiceRejectReason reason) {
        this.fileRejectReasons.add(reason);
    }

    public ElectronicInvoicePostalAddress getCxmlPostalAddress(ElectronicInvoiceOrder eio, String roleID, String addressName) {
        if (this.getInvoiceDetailRequestHeader().isShippingInLine()) {
            return eio.getCxmlPostalAddressByRoleID(roleID, addressName);
        }
        return this.getInvoiceDetailRequestHeader().getCxmlPostalAddressByRoleID(roleID, addressName);
    }

    public ElectronicInvoiceContact getCxmlContact(ElectronicInvoiceOrder eio, String roleID) {
        if (this.getInvoiceDetailRequestHeader().isShippingInLine()) {
            return eio.getCxmlContactByRoleID(roleID);
        }
        return this.getInvoiceDetailRequestHeader().getCxmlContactByRoleID(roleID);
    }

    public String getShippingDateDisplayText(ElectronicInvoiceOrder eio) {
        String dateString;
        java.util.Date date;
        if (this.getInvoiceDetailRequestHeader().isShippingInLine()) {
            date = eio.getInvoiceShippingDate();
            dateString = eio.getInvoiceShippingDateString();
        } else {
            date = this.getInvoiceDetailRequestHeader().getShippingDate();
            dateString = this.getInvoiceDetailRequestHeader().getShippingDateString();
        }
        if (date != null) {
            return ElectronicInvoiceUtils.getDateDisplayText(date);
        }
        return dateString;
    }

    public String getMasterAgreementIDInfoDateDisplayText(ElectronicInvoiceOrder eio) {
        java.util.Date date = eio.getMasterAgreementIDInfoDate();
        if (date != null) {
            return ElectronicInvoiceUtils.getDateDisplayText(date);
        }
        return eio.getMasterAgreementIDInfoDateString();
    }

    public String getMasterAgreementReferenceDateDisplayText(ElectronicInvoiceOrder eio) {
        java.util.Date date = eio.getMasterAgreementReferenceDate();
        if (date != null) {
            return ElectronicInvoiceUtils.getDateDisplayText(date);
        }
        return eio.getMasterAgreementReferenceDateString();
    }

    public String getOrderIDInfoDateDisplayText(ElectronicInvoiceOrder eio) {
        java.util.Date date = eio.getOrderIDInfoDate();
        if (date != null) {
            return ElectronicInvoiceUtils.getDateDisplayText(date);
        }
        return eio.getOrderIDInfoDateString();
    }

    public String getInvoiceDateDisplayText() {
        Date date = this.getInvoiceDetailRequestHeader().getInvoiceDate();
        if (date != null) {
            return ElectronicInvoiceUtils.getDateDisplayText(date);
        }
        return this.getInvoiceDetailRequestHeader().getInvoiceDateString();
    }

    public String getInvoiceShippingDescription(ElectronicInvoiceOrder eio) {
        if (this.getInvoiceDetailRequestHeader().isShippingInLine()) {
            return eio.getInvoiceShippingDescription();
        }
        return this.getInvoiceDetailRequestSummary().getShippingDescription();
    }

    public String getInvoiceTaxDescription(ElectronicInvoiceOrder eio) {
        if (this.getInvoiceDetailRequestHeader().isTaxInLine()) {
            return eio.getInvoiceTaxDescription();
        }
        return this.getInvoiceDetailRequestSummary().getTaxDescription();
    }

    public String getInvoiceSpecialHandlingDescription(ElectronicInvoiceOrder eio) {
        if (this.getInvoiceDetailRequestHeader().isSpecialHandlingInLine()) {
            return eio.getInvoiceSpecialHandlingDescription();
        }
        return this.getInvoiceDetailRequestSummary().getSpecialHandlingAmountDescription();
    }

    public BigDecimal getFileTotalAmountForInLineItems(String invoiceLineItemType) {
        BigDecimal total = zero;
        for (ElectronicInvoiceOrder invoiceDetailOrder : this.invoiceDetailOrders) {
            if (INVOICE_AMOUNT_TYPE_CODE_TAX.equalsIgnoreCase(invoiceLineItemType)) {
                total = total.add(invoiceDetailOrder.getInvoiceTaxAmount());
                continue;
            }
            if (INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING.equalsIgnoreCase(invoiceLineItemType)) {
                total = total.add(invoiceDetailOrder.getInvoiceSpecialHandlingAmount());
                continue;
            }
            if (INVOICE_AMOUNT_TYPE_CODE_SHIPPING.equalsIgnoreCase(invoiceLineItemType)) {
                total = total.add(invoiceDetailOrder.getInvoiceShippingAmount());
                continue;
            }
            if (!INVOICE_AMOUNT_TYPE_CODE_DISCOUNT.equalsIgnoreCase(invoiceLineItemType)) continue;
            total = total.add(invoiceDetailOrder.getInvoiceDiscountAmount());
        }
        return total;
    }

    public BigDecimal getInvoiceSubTotalAmount(ElectronicInvoiceOrder eio) {
        if (this.containsLineLevelAmounts()) {
            return eio.getInvoiceSubTotalAmount();
        }
        return this.getInvoiceDetailRequestSummary().getInvoiceSubTotalAmount();
    }

    public BigDecimal getInvoiceTaxAmount(ElectronicInvoiceOrder eio) {
        if (this.getInvoiceDetailRequestHeader().isTaxInLine()) {
            return eio.getInvoiceTaxAmount();
        }
        return this.getInvoiceDetailRequestSummary().getInvoiceTaxAmount();
    }

    public BigDecimal getInvoiceSpecialHandlingAmount(ElectronicInvoiceOrder eio) {
        if (this.getInvoiceDetailRequestHeader().isSpecialHandlingInLine()) {
            return eio.getInvoiceSpecialHandlingAmount();
        }
        return this.getInvoiceDetailRequestSummary().getInvoiceSpecialHandlingAmount();
    }

    public BigDecimal getInvoiceShippingAmount(ElectronicInvoiceOrder eio) {
        if (this.getInvoiceDetailRequestHeader().isShippingInLine()) {
            return eio.getInvoiceShippingAmount();
        }
        return this.getInvoiceDetailRequestSummary().getInvoiceShippingAmount();
    }

    public BigDecimal getInvoiceGrossAmount(ElectronicInvoiceOrder eio) {
        if (this.containsLineLevelAmounts()) {
            return eio.getInvoiceGrossAmount();
        }
        return this.getInvoiceDetailRequestSummary().getInvoiceGrossAmount();
    }

    public BigDecimal getInvoiceDiscountAmount(ElectronicInvoiceOrder eio) {
        if (this.getInvoiceDetailRequestHeader().isDiscountInLine()) {
            return eio.getInvoiceDiscountAmount();
        }
        return this.getInvoiceDetailRequestSummary().getInvoiceDiscountAmount();
    }

    public BigDecimal getInvoiceNetAmount(ElectronicInvoiceOrder eio) {
        if (this.containsLineLevelAmounts()) {
            return eio.getInvoiceNetAmount();
        }
        return this.getInvoiceDetailRequestSummary().getInvoiceNetAmount();
    }

    public BigDecimal getInvoiceDepositAmount() {
        return this.getInvoiceDetailRequestSummary().getInvoiceDepositAmount();
    }

    public BigDecimal getInvoiceDueAmount() {
        return this.getInvoiceDetailRequestSummary().getInvoiceDueAmount();
    }

    public String getCodeOfLineItemThatContainsInvalidCurrency(String invoiceLineItemType) {
        for (ElectronicInvoiceOrder invoiceDetailOrder : this.invoiceDetailOrders) {
            for (ElectronicInvoiceItem invoiceItem : invoiceDetailOrder.getInvoiceItems()) {
                if (INVOICE_AMOUNT_TYPE_CODE_TAX.equalsIgnoreCase(invoiceLineItemType)) {
                    if (this.isCodeValidCurrency(invoiceItem.getTaxAmountCurrency())) continue;
                    return invoiceItem.getTaxAmountCurrency();
                }
                if (INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING.equalsIgnoreCase(invoiceLineItemType)) {
                    if (this.isCodeValidCurrency(invoiceItem.getInvoiceLineSpecialHandlingAmountCurrency())) continue;
                    return invoiceItem.getInvoiceLineSpecialHandlingAmountCurrency();
                }
                if (INVOICE_AMOUNT_TYPE_CODE_SHIPPING.equalsIgnoreCase(invoiceLineItemType)) {
                    if (this.isCodeValidCurrency(invoiceItem.getInvoiceLineShippingAmountCurrency())) continue;
                    return invoiceItem.getInvoiceLineShippingAmountCurrency();
                }
                if (!INVOICE_AMOUNT_TYPE_CODE_DISCOUNT.equalsIgnoreCase(invoiceLineItemType) || this.isCodeValidCurrency(invoiceItem.getInvoiceLineDiscountAmountCurrency())) continue;
                return invoiceItem.getInvoiceLineDiscountAmountCurrency();
            }
        }
        return null;
    }

    public String checkCodeForValidCurrency(String code) {
        if (!this.isCodeValidCurrency(code)) {
            return code;
        }
        return null;
    }

    public boolean isCodeValidCurrency(String code) {
        if (code != null) {
            for (int i = 0; i < ElectronicInvoiceMappingService.CXML_VALID_CURRENCY_CODES.length; ++i) {
                String validCode = ElectronicInvoiceMappingService.CXML_VALID_CURRENCY_CODES[i];
                if (!code.equalsIgnoreCase(validCode)) continue;
                return true;
            }
        }
        return false;
    }

    public String getInvoiceSubTotalCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.containsLineLevelAmounts()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getSubTotalAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.getInvoiceDetailRequestSummary().getSubTotalAmountCurrency());
    }

    public String getInvoiceTaxCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.getInvoiceDetailRequestHeader().isTaxInLine()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getTaxAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.getInvoiceDetailRequestSummary().getTaxAmountCurrency());
    }

    public String getInvoiceSpecialHandlingCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.getInvoiceDetailRequestHeader().isSpecialHandlingInLine()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getInvoiceLineSpecialHandlingAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.getInvoiceDetailRequestSummary().getSpecialHandlingAmountCurrency());
    }

    public String getInvoiceShippingCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.getInvoiceDetailRequestHeader().isShippingInLine()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getInvoiceLineShippingAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.getInvoiceDetailRequestSummary().getShippingAmountCurrency());
    }

    public String getInvoiceGrossCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.containsLineLevelAmounts()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getInvoiceLineGrossAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.getInvoiceDetailRequestSummary().getGrossAmountCurrency());
    }

    public String getInvoiceDiscountCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.getInvoiceDetailRequestHeader().isDiscountInLine()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getInvoiceLineDiscountAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.getInvoiceDetailRequestSummary().getDiscountAmountCurrency());
    }

    public String getInvoiceNetCurrencyIfNotValid(ElectronicInvoiceOrder eio) {
        if (this.containsLineLevelAmounts()) {
            for (ElectronicInvoiceItem eii : eio.getInvoiceItems()) {
                String currentCode = this.checkCodeForValidCurrency(eii.getInvoiceLineNetAmountCurrency());
                if (currentCode == null) continue;
                return currentCode;
            }
            return null;
        }
        return this.checkCodeForValidCurrency(this.getInvoiceDetailRequestSummary().getNetAmountCurrency());
    }

    public String getInvoiceDepositCurrencyIfNotValid() {
        return this.checkCodeForValidCurrency(this.getInvoiceDetailRequestSummary().getDepositAmountCurrency());
    }

    public String getInvoiceDueCurrencyIfNotValid() {
        return this.checkCodeForValidCurrency(this.getInvoiceDetailRequestSummary().getDueAmountCurrency());
    }

    public boolean isContainsRejects() {
        return this.containsRejects;
    }

    public void setContainsRejects(boolean containsRejects) {
        this.containsRejects = containsRejects;
    }

    public String getCustomerNumber() {
        return this.customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public String getDunsNumber() {
        return this.dunsNumber;
    }

    public void setDunsNumber(String dunsNumber) {
        this.dunsNumber = dunsNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isFileRejected() {
        return this.fileRejected;
    }

    public void setFileRejected(boolean fileRejected) {
        this.fileRejected = fileRejected;
    }

    public List<ElectronicInvoiceRejectReason> getFileRejectReasons() {
        return this.fileRejectReasons;
    }

    public void setFileRejectReasons(List<ElectronicInvoiceRejectReason> fileRejectReasons) {
        this.fileRejectReasons = fileRejectReasons;
    }

    public List<ElectronicInvoiceOrder> getInvoiceDetailOrders() {
        if (this.invoiceDetailOrders == null) {
            this.invoiceDetailOrders = this.request.getInvoiceDetailRequest().getElectronicInvoiceOrders();
        }
        return this.invoiceDetailOrders;
    }

    public void setInvoiceDetailOrders(List<ElectronicInvoiceOrder> invoiceDetailOrders) {
        this.invoiceDetailOrders = invoiceDetailOrders;
    }

    public ElectronicInvoiceDetailRequestHeader getInvoiceDetailRequestHeader() {
        if (this.invoiceDetailRequestHeader == null) {
            this.invoiceDetailRequestHeader = this.request.getInvoiceDetailRequest().getInvoiceDetailRequestHeader().toElectronicInvoiceDetailRequestHeader();
        }
        return this.invoiceDetailRequestHeader;
    }

    public ElectronicInvoiceDetailRequestSummary getInvoiceDetailRequestSummary() {
        if (this.invoiceDetailRequestSummary == null) {
            this.invoiceDetailRequestSummary = this.request.getInvoiceDetailRequest().getInvoiceDetailSummary().toElectronicInvoiceDetailRequestSummary();
        }
        return this.invoiceDetailRequestSummary;
    }

    public void setInvoiceDetailRequestSummary(ElectronicInvoiceDetailRequestSummary invoiceDetailRequestSummary) {
        this.invoiceDetailRequestSummary = invoiceDetailRequestSummary;
    }

    public Integer getVendorDetailID() {
        return this.vendorDetailID;
    }

    public void setVendorDetailID(Integer vendorDetailID) {
        this.vendorDetailID = vendorDetailID;
    }

    public Integer getVendorHeaderID() {
        return this.vendorHeaderID;
    }

    public void setVendorHeaderID(Integer vendorHeaderID) {
        this.vendorHeaderID = vendorHeaderID;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getPayloadID() {
        return this.payloadID;
    }

    public void setPayloadID(String payloadID) {
        this.payloadID = payloadID;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void addInvoiceDetailOrder(ElectronicInvoiceOrder electronicInvoiceOrder) {
        this.getInvoiceDetailOrders().add(electronicInvoiceOrder);
    }

    public ElectronicInvoiceOrder[] getInvoiceDetailOrdersAsArray() {
        if (this.getInvoiceDetailOrders().size() > 0) {
            ElectronicInvoiceOrder[] tempOrders = new ElectronicInvoiceOrder[this.getInvoiceDetailOrders().size()];
            this.getInvoiceDetailOrders().toArray(tempOrders);
            return tempOrders;
        }
        return null;
    }

    public String getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(String deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    public String toString() {
        ToStringBuilder toString = new ToStringBuilder((Object)this);
        toString.append("version", (Object)this.version);
        toString.append("timestamp", (Object)this.timestamp);
        toString.append("payloadID", (Object)this.payloadID);
        toString.append("locale", (Object)this.lang);
        toString.append("customerNumber", (Object)this.customerNumber);
        toString.append("fileName", (Object)this.fileName);
        toString.append("deploymentMode", (Object)this.deploymentMode);
        toString.append("dunsNumber", (Object)this.dunsNumber);
        toString.append("vendorHeaderID", (Object)this.vendorHeaderID);
        toString.append("vendorDetailID", (Object)this.vendorDetailID);
        toString.append("vendorName", (Object)this.vendorName);
        toString.append("header", (Object)this.header);
        toString.append("invoiceDetailRequestHeader", (Object)this.getInvoiceDetailRequestHeader());
        toString.append("invoiceDetailOrders", this.getInvoiceDetailOrders());
        toString.append("invoiceDetailRequestSummary", (Object)this.getInvoiceDetailRequestSummary());
        return toString.toString();
    }

    static {
        FILE_DOES_CONTAIN_REJECTS = true;
    }
}

