/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.sql.Timestamp;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoice;
import org.kuali.kfs.sys.context.SpringContext;

public class ElectronicInvoiceLoadSummary
extends PersistableBusinessObjectBase {
    private Integer invoiceLoadSummaryIdentifier;
    private String vendorDunsNumber;
    private Integer vendorHeaderGeneratedIdentifier;
    private Integer vendorDetailAssignedIdentifier;
    private String vendorName;
    private Integer invoiceLoadSuccessCount = 0;
    private KualiDecimal invoiceLoadSuccessAmount = new KualiDecimal(0.0);
    private Integer invoiceLoadFailCount = 0;
    private KualiDecimal invoiceLoadFailAmount = new KualiDecimal(0.0);
    private Boolean isEmpty = Boolean.TRUE;
    private Timestamp fileProcessTimestamp;

    public ElectronicInvoiceLoadSummary() {
    }

    public ElectronicInvoiceLoadSummary(String vendorDunsNumber) {
        this.vendorDunsNumber = vendorDunsNumber;
    }

    public void addSuccessfulInvoiceOrder(KualiDecimal amount, ElectronicInvoice eInvoice) {
        this.isEmpty = Boolean.FALSE;
        this.invoiceLoadSuccessCount = this.invoiceLoadSuccessCount + 1;
        this.fileProcessTimestamp = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp();
        if (amount != null) {
            this.invoiceLoadSuccessAmount = (KualiDecimal)this.invoiceLoadSuccessAmount.add((AbstractKualiDecimal)amount);
        }
        this.setupVendorInformation(eInvoice);
    }

    public void addFailedInvoiceOrder(KualiDecimal amount, ElectronicInvoice eInvoice) {
        this.isEmpty = Boolean.FALSE;
        this.invoiceLoadFailCount = this.invoiceLoadFailCount + 1;
        this.fileProcessTimestamp = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp();
        if (amount != null) {
            this.invoiceLoadFailAmount = (KualiDecimal)this.invoiceLoadFailAmount.add((AbstractKualiDecimal)amount);
        }
        this.setupVendorInformation(eInvoice);
    }

    public void addFailedInvoiceOrder(ElectronicInvoice ei) {
        this.addFailedInvoiceOrder(new KualiDecimal(0), ei);
    }

    public void addFailedInvoiceOrder() {
        this.addFailedInvoiceOrder(new KualiDecimal(0), null);
    }

    private void setupVendorInformation(ElectronicInvoice eInvoice) {
        if (eInvoice != null && this.getVendorHeaderGeneratedIdentifier() == null && this.getVendorDetailAssignedIdentifier() == null) {
            this.setVendorHeaderGeneratedIdentifier(eInvoice.getVendorHeaderID());
            this.setVendorDetailAssignedIdentifier(eInvoice.getVendorDetailID());
            this.setVendorName(eInvoice.getVendorName());
        }
    }

    public String getVendorDescriptor() {
        String kualiDescriptor = null;
        if (this.vendorName != null && this.vendorHeaderGeneratedIdentifier != null && this.vendorDetailAssignedIdentifier != null) {
            kualiDescriptor = "  (Kuali Match:  " + this.vendorName + "  ~  " + this.vendorHeaderGeneratedIdentifier + "-" + this.vendorDetailAssignedIdentifier + ")";
        } else if (this.vendorHeaderGeneratedIdentifier != null && this.vendorDetailAssignedIdentifier != null) {
            kualiDescriptor = "  (Kuali Match:  " + this.vendorHeaderGeneratedIdentifier + "-" + this.vendorDetailAssignedIdentifier + ")";
        } else if (this.vendorName != null) {
            kualiDescriptor = "  (Kuali Match:  " + this.vendorName + ")";
        }
        return this.getVendorDunsNumber() + (String)(kualiDescriptor != null ? kualiDescriptor : "");
    }

    public Integer getVendorDetailAssignedIdentifier() {
        return this.vendorDetailAssignedIdentifier;
    }

    public void setVendorDetailAssignedIdentifier(Integer kualiVendorDetailId) {
        this.vendorDetailAssignedIdentifier = kualiVendorDetailId;
    }

    public Integer getVendorHeaderGeneratedIdentifier() {
        return this.vendorHeaderGeneratedIdentifier;
    }

    public void setVendorHeaderGeneratedIdentifier(Integer kualiVendorHeaderId) {
        this.vendorHeaderGeneratedIdentifier = kualiVendorHeaderId;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String kualiVendorName) {
        this.vendorName = kualiVendorName;
    }

    public KualiDecimal getInvoiceLoadFailAmount() {
        return this.invoiceLoadFailAmount;
    }

    public void setInvoiceLoadFailAmount(KualiDecimal failAmount) {
        this.invoiceLoadFailAmount = failAmount;
    }

    public Integer getInvoiceLoadFailCount() {
        return this.invoiceLoadFailCount;
    }

    public void setInvoiceLoadFailCount(Integer failCount) {
        this.invoiceLoadFailCount = failCount;
    }

    public Integer getInvoiceLoadSummaryIdentifier() {
        return this.invoiceLoadSummaryIdentifier;
    }

    public void setInvoiceLoadSummaryIdentifier(Integer id) {
        this.invoiceLoadSummaryIdentifier = id;
    }

    public Boolean isEmpty() {
        return this.isEmpty;
    }

    public void setIsEmpty(Boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public KualiDecimal getInvoiceLoadSuccessAmount() {
        return this.invoiceLoadSuccessAmount;
    }

    public void setInvoiceLoadSuccessAmount(KualiDecimal successAmount) {
        this.invoiceLoadSuccessAmount = successAmount;
    }

    public Integer getInvoiceLoadSuccessCount() {
        return this.invoiceLoadSuccessCount;
    }

    public void setInvoiceLoadSuccessCount(Integer successCount) {
        this.invoiceLoadSuccessCount = successCount;
    }

    public String getVendorDunsNumber() {
        return this.vendorDunsNumber;
    }

    public void setVendorDunsNumber(String vendorDunsNumber) {
        this.vendorDunsNumber = vendorDunsNumber;
    }

    public Timestamp getFileProcessTimestamp() {
        return this.fileProcessTimestamp;
    }

    public void setFileProcessTimestamp(Timestamp fileProcessTimestamp) {
        this.fileProcessTimestamp = fileProcessTimestamp;
    }
}

