/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceContact;
import org.kuali.kfs.module.purap.businessobject.jaxb.Email;
import org.kuali.kfs.module.purap.businessobject.jaxb.Fax;
import org.kuali.kfs.module.purap.businessobject.jaxb.Name;
import org.kuali.kfs.module.purap.businessobject.jaxb.Phone;
import org.kuali.kfs.module.purap.businessobject.jaxb.PostalAddress;
import org.kuali.kfs.module.purap.businessobject.jaxb.URL;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"name", "postalAddress", "email", "phone", "fax", "url"})
@XmlRootElement(name="Contact", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
public class Contact {
    @XmlElement(name="Name", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", required=true)
    protected Name name;
    @XmlElement(name="PostalAddress", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected List<PostalAddress> postalAddress;
    @XmlElement(name="Email", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected List<Email> email;
    @XmlElement(name="Phone", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected List<Phone> phone;
    @XmlElement(name="Fax", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected List<Fax> fax;
    @XmlElement(name="URL", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected List<URL> url;
    @XmlAttribute(name="role", required=true)
    protected String role;
    @XmlAttribute(name="addressID")
    protected String addressID;

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public List<PostalAddress> getPostalAddress() {
        if (this.postalAddress == null) {
            this.postalAddress = new ArrayList<PostalAddress>();
        }
        return this.postalAddress;
    }

    public List<Email> getEmail() {
        if (this.email == null) {
            this.email = new ArrayList<Email>();
        }
        return this.email;
    }

    public List<Phone> getPhone() {
        if (this.phone == null) {
            this.phone = new ArrayList<Phone>();
        }
        return this.phone;
    }

    public List<Fax> getFax() {
        if (this.fax == null) {
            this.fax = new ArrayList<Fax>();
        }
        return this.fax;
    }

    public List<URL> getURL() {
        if (this.url == null) {
            this.url = new ArrayList<URL>();
        }
        return this.url;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getAddressID() {
        return this.addressID;
    }

    public void setAddressID(String addressID) {
        this.addressID = addressID;
    }

    ElectronicInvoiceContact toElectronicInvoiceContact() {
        ElectronicInvoiceContact contact = new ElectronicInvoiceContact();
        contact.setAddressID(this.addressID);
        if (CollectionUtils.isNotEmpty(this.email)) {
            contact.setEmailAddresses(this.email.stream().collect(Collectors.toMap(Email::getName, Email::getValue)));
        }
        if (CollectionUtils.isNotEmpty(this.fax)) {
            contact.setFaxNumbers(this.fax.stream().collect(Collectors.toMap(Fax::getName, fx -> fx.getTelephoneNumber().getCombinedNumber())));
        }
        contact.setName(this.name.getValue());
        if (CollectionUtils.isNotEmpty(this.phone)) {
            contact.setPhoneNumbers(this.phone.stream().collect(Collectors.toMap(Phone::getName, ph -> ph.getTelephoneNumber().getCombinedNumber())));
        }
        if (CollectionUtils.isNotEmpty(this.postalAddress)) {
            contact.setPostalAddresses(this.postalAddress.stream().map(PostalAddress::toElectronicInvoicePostalAddress).collect(Collectors.toList()));
        }
        contact.setRole(this.role);
        if (CollectionUtils.isNotEmpty(this.url)) {
            contact.setWebAddresses(this.url.stream().map(URL::getValue).collect(Collectors.toList()));
        }
        return contact;
    }
}

