/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailItem;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailOrderInfo;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailServiceItem;
import org.kuali.kfs.module.purap.businessobject.jaxb.MasterAgreementIDInfo;
import org.kuali.kfs.module.purap.businessobject.jaxb.MasterAgreementReference;
import org.kuali.kfs.module.purap.businessobject.jaxb.OrderIDInfo;
import org.kuali.kfs.module.purap.businessobject.jaxb.OrderReference;
import org.kuali.kfs.module.purap.businessobject.jaxb.SupplierOrderInfo;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"invoiceDetailOrderInfo", "invoiceDetailItem", "invoiceDetailServiceItem"})
public class InvoiceDetailOrder {
    @XmlElement(name="InvoiceDetailOrderInfo", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", required=true)
    protected InvoiceDetailOrderInfo invoiceDetailOrderInfo;
    @XmlElement(name="InvoiceDetailItem", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected List<InvoiceDetailItem> invoiceDetailItem;
    @XmlElement(name="InvoiceDetailServiceItem", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected List<InvoiceDetailServiceItem> invoiceDetailServiceItem;

    public InvoiceDetailOrderInfo getInvoiceDetailOrderInfo() {
        return this.invoiceDetailOrderInfo;
    }

    public void setInvoiceDetailOrderInfo(InvoiceDetailOrderInfo invoiceDetailOrderInfo) {
        this.invoiceDetailOrderInfo = invoiceDetailOrderInfo;
    }

    public List<InvoiceDetailItem> getInvoiceDetailItem() {
        if (this.invoiceDetailItem == null) {
            this.invoiceDetailItem = new ArrayList<InvoiceDetailItem>();
        }
        return this.invoiceDetailItem;
    }

    public List<InvoiceDetailServiceItem> getInvoiceDetailServiceItem() {
        if (this.invoiceDetailServiceItem == null) {
            this.invoiceDetailServiceItem = new ArrayList<InvoiceDetailServiceItem>();
        }
        return this.invoiceDetailServiceItem;
    }

    ElectronicInvoiceOrder toElectronicInvoiceOrder() {
        ElectronicInvoiceOrder order = new ElectronicInvoiceOrder();
        for (Object orderInfo : this.invoiceDetailOrderInfo.getContent()) {
            Object instance;
            if (orderInfo instanceof OrderReference) {
                instance = (OrderReference)orderInfo;
                order.setOrderReferenceOrderID(((OrderReference)instance).getOrderID());
                order.setOrderReferenceOrderDateString(((OrderReference)instance).getOrderDate());
                if (((OrderReference)instance).getDocumentReference() == null) continue;
                order.setOrderReferenceDocumentRefPayloadID(((OrderReference)instance).getDocumentReference().getPayloadID());
                order.setOrderReferenceDocumentRef(((OrderReference)instance).getDocumentReference().getValue());
                continue;
            }
            if (orderInfo instanceof MasterAgreementReference) {
                instance = (MasterAgreementReference)orderInfo;
                order.setMasterAgreementReferenceID(((MasterAgreementReference)instance).getAgreementID());
                order.setMasterAgreementReferenceDateString(((MasterAgreementReference)instance).getAgreementDate());
                continue;
            }
            if (orderInfo instanceof MasterAgreementIDInfo) {
                instance = (MasterAgreementIDInfo)orderInfo;
                order.setMasterAgreementIDInfoID(((MasterAgreementIDInfo)instance).getAgreementID());
                order.setMasterAgreementIDInfoDateString(((MasterAgreementIDInfo)instance).getAgreementDate());
                continue;
            }
            if (orderInfo instanceof OrderIDInfo) {
                instance = (OrderIDInfo)orderInfo;
                order.setOrderIDInfoID(((OrderIDInfo)instance).getOrderID());
                order.setOrderIDInfoDateString(((OrderIDInfo)instance).getOrderDate());
                continue;
            }
            if (!(orderInfo instanceof SupplierOrderInfo)) continue;
            instance = (SupplierOrderInfo)orderInfo;
            order.setSupplierOrderInfoID(((SupplierOrderInfo)instance).getOrderID());
        }
        if (CollectionUtils.isNotEmpty(this.invoiceDetailItem)) {
            this.invoiceDetailItem.forEach(item -> order.addInvoiceItem(item.toElectronicInvoiceItem()));
        }
        if (CollectionUtils.isNotEmpty(this.invoiceDetailServiceItem)) {
            this.invoiceDetailServiceItem.forEach(item -> order.addInvoiceItem(item.toElectronicInvoiceItem()));
        }
        return order;
    }
}

