/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestHeader;
import org.kuali.kfs.module.purap.businessobject.jaxb.Comments;
import org.kuali.kfs.module.purap.businessobject.jaxb.Contact;
import org.kuali.kfs.module.purap.businessobject.jaxb.Extrinsic;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailHeaderIndicator;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailLineIndicator;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailPaymentTerm;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailShipping;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoicePartner;
import org.kuali.kfs.module.purap.businessobject.jaxb.PaymentTerm;
import org.kuali.kfs.module.purap.util.cxml.CxmlExtrinsic;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"invoiceDetailHeaderIndicator", "invoiceDetailLineIndicator", "invoicePartner", "invoiceDetailShipping", "invoiceDetailPaymentTermOrPaymentTerm", "comments", "extrinsic"})
public class InvoiceDetailRequestHeader {
    @XmlElement(name="InvoiceDetailHeaderIndicator", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", required=true)
    protected InvoiceDetailHeaderIndicator invoiceDetailHeaderIndicator;
    @XmlElement(name="InvoiceDetailLineIndicator", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", required=true)
    protected InvoiceDetailLineIndicator invoiceDetailLineIndicator;
    @XmlElement(name="InvoicePartner", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected List<InvoicePartner> invoicePartner;
    @XmlElement(name="InvoiceDetailShipping", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected InvoiceDetailShipping invoiceDetailShipping;
    @XmlElements(value={@XmlElement(name="InvoiceDetailPaymentTerm", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", type=InvoiceDetailPaymentTerm.class), @XmlElement(name="PaymentTerm", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", type=PaymentTerm.class)})
    protected List<Object> invoiceDetailPaymentTermOrPaymentTerm;
    @XmlElement(name="Comments", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected Comments comments;
    @XmlElement(name="Extrinsic", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected List<Extrinsic> extrinsic;
    @XmlAttribute(name="purpose")
    protected String purpose;
    @XmlAttribute(name="operation")
    protected String operation;
    @XmlAttribute(name="invoiceDate", required=true)
    protected String invoiceDate;
    @XmlAttribute(name="invoiceID", required=true)
    protected String invoiceID;
    @XmlAttribute(name="isInformationOnly")
    protected String isInformationOnly;

    public InvoiceDetailHeaderIndicator getInvoiceDetailHeaderIndicator() {
        return this.invoiceDetailHeaderIndicator;
    }

    public void setInvoiceDetailHeaderIndicator(InvoiceDetailHeaderIndicator invoiceDetailHeaderIndicator) {
        this.invoiceDetailHeaderIndicator = invoiceDetailHeaderIndicator;
    }

    public InvoiceDetailLineIndicator getInvoiceDetailLineIndicator() {
        return this.invoiceDetailLineIndicator;
    }

    public void setInvoiceDetailLineIndicator(InvoiceDetailLineIndicator invoiceDetailLineIndicator) {
        this.invoiceDetailLineIndicator = invoiceDetailLineIndicator;
    }

    public List<InvoicePartner> getInvoicePartner() {
        if (this.invoicePartner == null) {
            this.invoicePartner = new ArrayList<InvoicePartner>();
        }
        return this.invoicePartner;
    }

    public InvoiceDetailShipping getInvoiceDetailShipping() {
        return this.invoiceDetailShipping;
    }

    public void setInvoiceDetailShipping(InvoiceDetailShipping invoiceDetailShipping) {
        this.invoiceDetailShipping = invoiceDetailShipping;
    }

    public List<Object> getInvoiceDetailPaymentTermOrPaymentTerm() {
        if (this.invoiceDetailPaymentTermOrPaymentTerm == null) {
            this.invoiceDetailPaymentTermOrPaymentTerm = new ArrayList<Object>();
        }
        return this.invoiceDetailPaymentTermOrPaymentTerm;
    }

    public Comments getComments() {
        return this.comments;
    }

    public void setComments(Comments comments) {
        this.comments = comments;
    }

    public List<Extrinsic> getExtrinsic() {
        if (this.extrinsic == null) {
            this.extrinsic = new ArrayList<Extrinsic>();
        }
        return this.extrinsic;
    }

    public String getPurpose() {
        if (this.purpose == null) {
            return "standard";
        }
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getOperation() {
        if (this.operation == null) {
            return "new";
        }
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(String invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getInvoiceID() {
        return this.invoiceID;
    }

    public void setInvoiceID(String invoiceID) {
        this.invoiceID = invoiceID;
    }

    public String getIsInformationOnly() {
        return this.isInformationOnly;
    }

    public void setIsInformationOnly(String isInformationOnly) {
        this.isInformationOnly = isInformationOnly;
    }

    public ElectronicInvoiceDetailRequestHeader toElectronicInvoiceDetailRequestHeader() {
        ElectronicInvoiceDetailRequestHeader header = new ElectronicInvoiceDetailRequestHeader();
        header.setInvoiceDateString(this.invoiceDate);
        if (this.invoiceDetailShipping != null) {
            header.setShippingDateString(this.invoiceDetailShipping.getShippingDate());
            header.setInvoiceShippingContacts(this.invoiceDetailShipping.getContact().stream().map(Contact::toElectronicInvoiceContact).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(this.extrinsic)) {
            header.setExtrinsics(this.extrinsic.stream().map(ex -> new CxmlExtrinsic(ex.getName(), ex.getValue())).collect(Collectors.toList()));
        }
        header.setInvoiceId(this.invoiceID);
        header.setDiscountInfoProvidedIndicator(this.invoiceDetailLineIndicator.getIsDiscountInLine());
        header.setHeaderInvoiceInd(this.invoiceDetailHeaderIndicator.getIsHeaderInvoice());
        header.setbuyerInformationOnlyIndicator(this.isInformationOnly);
        header.setShippingInfoProvidedIndicator(this.invoiceDetailLineIndicator.getIsShippingInLine());
        header.setSpecialHandlingInfoProvidedIndicator(this.invoiceDetailLineIndicator.getIsSpecialHandlingInLine());
        header.setTaxInfoProvidedIndicator(this.invoiceDetailLineIndicator.getIsTaxInLine());
        header.setOperation(this.operation);
        header.setPurpose(this.purpose);
        header.setAccountingInfoProvidedIndicator(this.invoiceDetailLineIndicator.getIsAccountingInLine());
        if (CollectionUtils.isNotEmpty(this.invoicePartner)) {
            header.setInvoicePartnerContacts(this.invoicePartner.stream().map(InvoicePartner::getContact).flatMap(Collection::stream).map(Contact::toElectronicInvoiceContact).collect(Collectors.toList()));
            InvoicePartner lastPartner = this.invoicePartner.get(this.invoicePartner.size() - 1);
            if (lastPartner.getIdReference() != null) {
                header.setIdReferenceCreator(lastPartner.getIdReference().getCreator());
                header.setIdReferenceDescription(lastPartner.getIdReference().getDescription().getValue());
                header.setIdReferenceDomain(lastPartner.getIdReference().getDomain());
                header.setIdReferenceIdentifier(lastPartner.getIdReference().getIdentifier());
            }
        }
        if (CollectionUtils.isNotEmpty(this.invoiceDetailPaymentTermOrPaymentTerm)) {
            Object lastTerm = this.invoiceDetailPaymentTermOrPaymentTerm.get(this.invoiceDetailPaymentTermOrPaymentTerm.size() - 1);
            if (lastTerm instanceof InvoiceDetailPaymentTerm) {
                header.setPayInNumberOfDays((int)((InvoiceDetailPaymentTerm)lastTerm).getPayInNumberOfDays());
                header.setPercentageRate(((InvoiceDetailPaymentTerm)lastTerm).getPercentageRate().toPlainString());
            } else if (lastTerm instanceof PaymentTerm) {
                header.setPayInNumberOfDays((int)((PaymentTerm)lastTerm).getPayInNumberOfDays());
            }
        }
        return header;
    }
}

