/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.authorization.PurchasingAccountsPayableDocumentPresentationController;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class PurchaseOrderDocumentPresentationController
extends PurchasingAccountsPayableDocumentPresentationController {
    private PurapService purapService;

    @Override
    public boolean canEdit(Document document) {
        PurchaseOrderDocument poDocument = (PurchaseOrderDocument)document;
        if (!("In Process".equals(poDocument.getApplicationDocumentStatus()) || "Waiting for Department".equals(poDocument.getApplicationDocumentStatus()) || "Waiting for Vendor".equals(poDocument.getApplicationDocumentStatus()) || "Out for Quote".equals(poDocument.getApplicationDocumentStatus()) || "Awaiting Purchasing Approval".equals(poDocument.getApplicationDocumentStatus()) || "Awaiting New Unordered Item Review".equals(poDocument.getApplicationDocumentStatus()) || "Change in Process".equals(poDocument.getApplicationDocumentStatus()))) {
            return false;
        }
        return super.canEdit(document);
    }

    public boolean canFyi(Document document) {
        PurchaseOrderDocument poDocument = (PurchaseOrderDocument)document;
        if ("Pending Print".equals(poDocument.getApplicationDocumentStatus())) {
            return false;
        }
        return super.canFyi(document);
    }

    public boolean canCancel(Document document) {
        PurchaseOrderDocument poDocument = (PurchaseOrderDocument)document;
        if (poDocument.isPendingSplit() || poDocument.getAssigningSensitiveData()) {
            return false;
        }
        return super.canCancel(document);
    }

    public boolean canClose(Document document) {
        PurchaseOrderDocument poDocument = (PurchaseOrderDocument)document;
        if (poDocument.isPendingSplit() || poDocument.getAssigningSensitiveData()) {
            return false;
        }
        return super.canClose(document);
    }

    public boolean canReload(Document document) {
        PurchaseOrderDocument poDocument = (PurchaseOrderDocument)document;
        if (poDocument.isPendingSplit() || poDocument.getAssigningSensitiveData()) {
            return false;
        }
        return super.canReload(document);
    }

    public boolean canSave(Document document) {
        PurchaseOrderDocument poDocument = (PurchaseOrderDocument)document;
        if (poDocument.isPendingSplit() || poDocument.getAssigningSensitiveData()) {
            return false;
        }
        return super.canSave(document);
    }

    public boolean canRoute(Document document) {
        PurchaseOrderDocument poDocument = (PurchaseOrderDocument)document;
        String statusCode = poDocument.getApplicationDocumentStatus();
        if (StringUtils.equals((CharSequence)statusCode, (CharSequence)"Waiting for Department") || StringUtils.equals((CharSequence)statusCode, (CharSequence)"Waiting for Vendor") || StringUtils.equals((CharSequence)statusCode, (CharSequence)"Out for Quote")) {
            return false;
        }
        if (poDocument.isPendingSplit()) {
            return false;
        }
        return super.canRoute(document);
    }

    public Set<String> getEditModes(Document document) {
        boolean displayReceivingAddress;
        boolean salesTaxInd;
        Set editModes = super.getEditModes(document);
        PurchaseOrderDocument poDocument = (PurchaseOrderDocument)document;
        String statusCode = poDocument.getApplicationDocumentStatus();
        editModes.add("assignSensitiveData");
        boolean enableCommodityCode = this.getParameterService().getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_COMMODITY_CODE_IND");
        if (enableCommodityCode) {
            editModes.add("enableCommodityCode");
        }
        if (this.canFirstTransmitPrintPo(poDocument)) {
            editModes.add("printPurchaseOrder");
        }
        if (this.canPreviewPrintPo(poDocument)) {
            editModes.add("previewPrintPurchaseOrder");
        }
        if (this.canResendCxml(poDocument)) {
            editModes.add("resendPurchaseOrder");
        }
        if (ObjectUtils.isNotNull((Object)poDocument.getVendorHeaderGeneratedIdentifier())) {
            editModes.add("lockVendorEntry");
        }
        if ("B2B".equals(poDocument.getRequisitionSourceCode())) {
            editModes.add("lockB2BEntry");
        }
        if (this.getPurapService().requisitionSourceAllowsEditingPostingYear(poDocument) && this.getPurapService().allowEncumberNextFiscalYear() && ("In Process".equals(statusCode) || "Waiting for Vendor".equals(statusCode) || "Waiting for Department".equals(statusCode) || "Out for Quote".equals(statusCode) || "Awaiting Purchasing Approval".equals(statusCode))) {
            editModes.add("allowPostingYearEntry");
        }
        if (salesTaxInd = this.getParameterService().getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND").booleanValue()) {
            editModes.add("purapTaxEnabled");
            if (poDocument.isUseTaxIndicator()) {
                editModes.add("lockTaxAmountEntry");
            } else {
                editModes.add("clearAllTaxes");
            }
        }
        if (displayReceivingAddress = this.getParameterService().getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_RECEIVING_ADDRESS_IND").booleanValue()) {
            editModes.add("displayReceivingAddress");
        }
        if ("In Process".equals(statusCode) || "Waiting for Vendor".equals(statusCode) || "Waiting for Department".equals(statusCode) || "Out for Quote".equals(statusCode)) {
            editModes.add("preRoute");
        }
        if (poDocument.isDocumentStoppedInRouteNode("ContractManagement")) {
            editModes.add("lockInternalPurchasingEntry");
        }
        if (poDocument.isPendingSplit()) {
            editModes.add("splittingItemSelection");
        }
        return editModes;
    }

    protected boolean canFirstTransmitPrintPo(PurchaseOrderDocument poDocument) {
        boolean can = "Pending Print".equals(poDocument.getApplicationDocumentStatus());
        if (!can) {
            can = "Open".equals(poDocument.getApplicationDocumentStatus());
            can = can && poDocument.getDocumentHeader().getWorkflowDocument().isFinal();
            can = can && poDocument.getPurchaseOrderLastTransmitTimestamp() == null;
            can = can && "PRIN".equals(poDocument.getPurchaseOrderTransmissionMethodCode());
        }
        return can;
    }

    protected boolean canPreviewPrintPo(PurchaseOrderDocument poDocument) {
        boolean can;
        boolean bl = can = poDocument.getDocumentHeader().getWorkflowDocument().isSaved() || poDocument.getDocumentHeader().getWorkflowDocument().isEnroute();
        if (can) {
            ArrayList methods = new ArrayList(this.getParameterService().getParameterValuesAsString(PurchaseOrderDocument.class, "PRINT_PREVIEW_TRANSMISSION_METHOD_TYPES"));
            String method = poDocument.getPurchaseOrderTransmissionMethodCode();
            can = methods.contains(method);
        }
        return can;
    }

    protected boolean canResendCxml(PurchaseOrderDocument poDocument) {
        boolean can = "Error occurred sending cxml".equals(poDocument.getApplicationDocumentStatus());
        can = can && poDocument.isPurchaseOrderCurrentIndicator() && !poDocument.isPendingActionIndicator();
        return can;
    }

    PurapService getPurapService() {
        if (this.purapService == null) {
            this.purapService = (PurapService)SpringContext.getBean(PurapService.class);
        }
        return this.purapService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }
}

